/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;

public class FilterManager
implements HasLifecycle {
    private static final Logger FCSLOG = Logger.getLogger(FilterManager.class.getName());
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<Filter> filters = new ArrayList<Filter>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected final TreeMap<String, Filter> filtersMapByName = new TreeMap();
    private final TreeMap<Integer, Filter> filtersMapByID = new TreeMap();
    private final TreeMap<String, Filter> filtersMapByObservatoryName = new TreeMap();

    public TreeMap<String, Filter> getFiltersMapByName() {
        TreeMap filtersMap = (TreeMap)this.filtersMapByName.clone();
        return filtersMap;
    }

    public TreeMap<Integer, Filter> getFiltersMapByID() {
        TreeMap filtersMap = (TreeMap)this.filtersMapByID.clone();
        return filtersMap;
    }

    public void init() {
        for (Filter f : this.filters) {
            FCSLOG.info("Add filter to filterManager:" + f.getName());
            this.filtersMapByID.put(f.getFilterID(), f);
            this.filtersMapByObservatoryName.put(f.getObservatoryName(), f);
        }
    }

    public List<String> getFilterNames() {
        return this.filtersMapByName.keySet().stream().toList();
    }

    public Filter getFilterByName(String filterName) {
        if (this.filtersMapByName.containsKey(filterName)) {
            return this.filtersMapByName.get(filterName);
        }
        if (this.filtersMapByObservatoryName.containsKey(filterName)) {
            return this.filtersMapByObservatoryName.get(filterName);
        }
        throw new IllegalArgumentException("The filter '" + filterName + "' does not exist");
    }

    public int getFilterID(String filterName) {
        return this.getFilterByName(filterName).getFilterID();
    }

    public Filter getFilterByID(int id) {
        if (this.containsFilterID(id)) {
            return this.filtersMapByID.get(id);
        }
        FCSLOG.severe(this.name + " filterId=" + id + " is unknown in fcs configuration.");
        Filter unknownF = new Filter(id, 0.0, FcsEnumerations.FilterFamily.U);
        unknownF.setName("filterID_" + id);
        this.filtersMapByID.put(id, unknownF);
        return unknownF;
    }

    public boolean containsFilterID(int id) {
        return this.filtersMapByID.containsKey(id);
    }

    public boolean containsFilterName(String filterName) {
        return this.filtersMapByName.containsKey(filterName) || this.filtersMapByObservatoryName.containsKey(filterName);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return filter name which corresponds to the filterID.")
    public String getFilterNameByID(int id) {
        if (this.containsFilterID(id)) {
            return this.filtersMapByID.get(id).getName();
        }
        FCSLOG.warning(this.name + ": " + id + "  unknown filter ID. Please update filterManager configuration.");
        return "UnknownFilterID_" + id;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return filter observatory (OCS) name which corresponds to ID.")
    public String getObservatoryNameByID(int id) {
        if (this.containsFilterID(id)) {
            return this.filtersMapByID.get(id).getObservatoryName();
        }
        FCSLOG.warning(this.name + ": " + id + "  unknown filter ID. Please update filterManager configuration.");
        return "UnknownFilterID_" + id;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return a printed list of filters with their properties.", alias="printFilterList")
    public String toString() {
        String fmt = "%-9s%-7s%-14s%-20s\n";
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(fmt, "Name", "ID", "Weight (kg)", "Family"));
        sb.append(String.format(fmt, "----", "--", "-----------", "------"));
        this.filtersMapByName.forEach((name, filter) -> sb.append(String.format(fmt, name, filter.getFilterID(), filter.getWeight(), filter.getFamily().getFamilyName())));
        return sb.toString();
    }
}

