/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.pfeiffer;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class TPG261
extends Ascii {
    private String terminator = "\r\n";
    private int verbose = 1;

    public void open(String serialname, int baud) throws DriverException {
        System.out.println("opening connection to the TPG261 Vacuum Gauge");
        this.open(DriverConstants.ConnType.SERIAL, serialname, baud);
    }

    public void init() throws DriverException {
    }

    public void close() throws DriverException {
    }

    public String getID() throws DriverException {
        try {
            String idString = this.getReply("TID");
            if (this.verbose == 1) {
                System.out.println("TPG261ID: " + idString);
            }
            return idString;
        }
        catch (DriverException e) {
            System.out.println("TPG261 getID: Caught Exception " + (Object)((Object)e));
            return "";
        }
    }

    public String getError() throws DriverException {
        try {
            String errString = this.getReply("ERR");
            if (this.verbose == 1) {
                if (errString.charAt(0) == '\u0001') {
                    System.out.println("TPG261 getError: Controller Error");
                }
                if (errString.charAt(1) == '\u0001') {
                    System.out.println("TPG261 getError: Hardware Error");
                }
                if (errString.charAt(2) == '\u0001') {
                    System.out.println("TPG261 getError: Parameter Error");
                }
                if (errString.charAt(3) == '\u0001') {
                    System.out.println("TPG261 getError: Syntax Error");
                }
            }
            return errString;
        }
        catch (DriverException e) {
            System.out.println("TPG261 getError: Caught Exception" + (Object)((Object)e));
            return "";
        }
    }

    public String getStatus() throws DriverException {
        try {
            String statString = this.getReply("SEN");
            String[] subStrs = statString.split(",");
            Integer stat1 = Integer.valueOf(subStrs[0]);
            Integer stat2 = Integer.valueOf(subStrs[1]);
            if (this.verbose == 1) {
                switch (stat1) {
                    case 1: {
                        System.out.println("TPG261 getStatus: Gauge 1 off");
                        break;
                    }
                    case 2: {
                        System.out.println("TPG261 getStatus: Gauge 1 on");
                    }
                }
                switch (stat2) {
                    case 1: {
                        System.out.println("TPG261 getStatus: Gauge 2 off");
                        break;
                    }
                    case 2: {
                        System.out.println("TPG261 getStatus: Gauge 2 on");
                    }
                }
            }
            return statString;
        }
        catch (DriverException e) {
            System.out.println("TPG261 getStatus: Caught Exception");
            return "";
        }
    }

    public double getPressure() throws DriverException {
        double pressure = 0.0;
        try {
            String replyString = this.getReply("PR1");
            String[] subStrs = replyString.split(",");
            Integer status = Integer.valueOf(subStrs[0]);
            pressure = Double.parseDouble(subStrs[1]);
            if (this.verbose == 1) {
                if (status == 0) {
                    System.out.println("TPG261 getPressure: OK");
                } else {
                    switch (status) {
                        case 1: {
                            System.out.println("TPG261 getPressure: Under Range");
                            break;
                        }
                        case 2: {
                            System.out.println("TPG261 getPressure: Over Range");
                            break;
                        }
                        case 3: {
                            System.out.println("TPG261 getPressure: Sensor Error");
                            break;
                        }
                        case 4: {
                            System.out.println("TPG261 getPressure: Sensor Off");
                            break;
                        }
                        case 5: {
                            System.out.println("TPG261 getPressure: No Sensor");
                            break;
                        }
                        case 6: {
                            System.out.println("TPG261 getPressure: ID Error");
                            break;
                        }
                        default: {
                            System.out.println("TPG261 getPressure: unknown error");
                        }
                    }
                }
            }
        }
        catch (DriverException e) {
            System.out.println("TPG261 getPressure: Caught Exception " + (Object)((Object)e));
            return 0.0;
        }
        return pressure;
    }

    public void gaugeOn(Integer gauge) throws DriverException {
        if (gauge < 1 || gauge > 2) {
            System.out.println("TPG261On: bad gauge number");
            return;
        }
        String command = "";
        command = gauge == 1 ? "SEN,2,0" : "SEN,0,2";
        try {
            this.sendCommand(command);
        }
        catch (DriverException e) {
            System.out.println("TPG261On: Caught Exception");
        }
    }

    public void gaugeOff(Integer gauge) throws DriverException {
        if (gauge < 1 || gauge > 2) {
            System.out.println("TPG261On: bad gauge number");
            return;
        }
        String cmd = "";
        cmd = gauge == 1 ? "SEN,1,0" : "SEN,0,1";
        try {
            this.sendCommand(cmd);
        }
        catch (DriverException e) {
            System.out.println("TPG261On: Caught Exception");
            return;
        }
    }

    public void sendCommand(String command) throws DriverException {
        if (this.verbose == 1) {
            System.out.println("TPG261Command: " + command);
        }
        this.writeTPG261(command);
        String ack = this.readTPG261();
        if (ack.charAt(0) != '\u0006') {
            System.out.println("TPG261Command: Acknowledge error");
            throw new DriverException();
        }
    }

    public String getReply(String command) throws DriverException {
        if (this.verbose == 1) {
            System.out.println("TPG261Query: " + command);
        }
        this.writeTPG261(command);
        String ack = this.readTPG261();
        if (ack.charAt(0) != '\u0006') {
            throw new DriverException("PG261Query: Acknowledge error");
        }
        this.writeTPG261(String.valueOf('\u0005'));
        String reply = this.readTPG261();
        return reply;
    }

    public synchronized void writeTPG261(String command) throws DriverException {
        this.write(command + this.terminator);
    }

    public synchronized String readTPG261() throws DriverException {
        return this.read();
    }

    public synchronized String readTPG261(String command) throws DriverException {
        this.writeTPG261(command);
        return this.readTPG261();
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

