/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.airwatch.main.Alerts;
import org.lsst.ccs.subsystem.airwatch.main.DataPoint;

public class AnalogPoint
extends DataPoint {
    private final Double value;
    private final Double lowBound;
    private final Double highBound;

    public AnalogPoint(Double value, boolean limitViolation, boolean malfunction, String quality, String time, Double lowBound, Double highBound) {
        super(limitViolation, malfunction, quality, time);
        this.value = value;
        this.lowBound = lowBound;
        this.highBound = highBound;
    }

    AnalogPoint() {
        this(0.0, false, false, "Good", "2021-05-22T13:55:21-07:00", 0.0, 0.0);
    }

    public final Double getValue() {
        return this.value;
    }

    public final Double getLowBound() {
        return this.lowBound;
    }

    public final Double getHighBound() {
        return this.highBound;
    }

    @Override
    public final KeyValueDataList makeKvdList(String locName, String chanName) {
        KeyValueDataList kvdl = super.makeKvdList(locName, chanName);
        kvdl.addData(kvdl.getKey() + "/value", (Serializable)this.getValue());
        return kvdl;
    }

    @Override
    public final void checkData(AlertService alsvc, String locName, String chanName, boolean locIsEnabled) {
        if (!this.getQuality().equals("Good") || this.hasMalfunction()) {
            Alerts.DATA_QUALITY.raise(alsvc, AlertState.WARNING, Alerts.dataQualityMsg(locName, chanName, this.getQuality()), AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
        }
        if (this.hasLimitViolation()) {
            Alerts.LIMIT_VIOLATION.raise(alsvc, AlertState.WARNING, Alerts.analogViolationMsg(locName, chanName, this.getValue(), this.getLowBound(), this.getHighBound()), AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
        }
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AnalogPoint{value=").append(this.value);
        sb.append(", ");
        sb.append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}

