/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.example;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.readout.ReadOutParametersNew;

public class FitsFile
implements Comparable<FitsFile> {
    private static final Pattern DATASEC_PATTERN = Pattern.compile("\\[(\\d+):(\\d+),(\\d+):(\\d+)\\]");
    private final File file;
    private final String obsId;
    private final String raftBay;
    private final String ccdSlot;
    private final int naxis1;
    private final int naxis2;
    private final int[] datasec = new int[4];

    public FitsFile(File file, Header primary, Header image) throws FitsException {
        this.file = file;
        if (primary.containsKey("CCDSLOT")) {
            this.ccdSlot = FitsFile.getNonNullHeader(primary, "CCDSLOT");
            this.raftBay = FitsFile.getNonNullHeader(primary, "RAFTBAY");
        } else {
            String chipId = FitsFile.getNonNullHeader(primary, "CHIPID");
            String[] split = chipId.split("_");
            this.raftBay = split[0];
            this.ccdSlot = split[1];
        }
        this.obsId = FitsFile.getNonNullHeader(primary, "OBSID");
        boolean isCompressed = image.getBooleanValue("ZIMAGE");
        if (isCompressed) {
            this.naxis1 = image.getIntValue("ZNAXIS1");
            this.naxis2 = image.getIntValue("ZNAXIS2");
        } else {
            this.naxis1 = image.getIntValue("NAXIS1");
            this.naxis2 = image.getIntValue("NAXIS2");
        }
        String dataSecString = FitsFile.getNonNullHeader(image, "DATASEC");
        Matcher matcher = DATASEC_PATTERN.matcher(dataSecString);
        if (!matcher.matches()) {
            throw new FitsException("Invalid datasec: " + dataSecString);
        }
        this.datasec[0] = Integer.parseInt(matcher.group(1)) - 1;
        this.datasec[1] = Integer.parseInt(matcher.group(2));
        this.datasec[2] = Integer.parseInt(matcher.group(3)) - 1;
        this.datasec[3] = Integer.parseInt(matcher.group(4));
    }

    private static String getNonNullHeader(Header header, String itemName) throws FitsException {
        String result = header.getStringValue(itemName);
        if (result == null) {
            throw new FitsException("Missing " + itemName + " in FITS header");
        }
        return result;
    }

    public File getFile() {
        return this.file;
    }

    public String getObsId() {
        return this.obsId;
    }

    public String getRaftBay() {
        return this.raftBay;
    }

    public String getCcdSlot() {
        return this.ccdSlot;
    }

    public int[] getReadOutParameters() {
        List<String> DEFAULT_NAMES = Arrays.asList(ReadOutParametersNew.DEFAULT_NAMES);
        int[] result = new int[DEFAULT_NAMES.size()];
        result[DEFAULT_NAMES.indexOf((Object)"UnderCols")] = this.datasec[0];
        result[DEFAULT_NAMES.indexOf((Object)"PreRows")] = this.datasec[2];
        result[DEFAULT_NAMES.indexOf((Object)"ReadCols")] = this.datasec[1] - this.datasec[0];
        result[DEFAULT_NAMES.indexOf((Object)"ReadRows")] = this.datasec[3] - this.datasec[2];
        result[DEFAULT_NAMES.indexOf((Object)"OverCols")] = this.naxis1 - result[DEFAULT_NAMES.indexOf("ReadCols")] - result[DEFAULT_NAMES.indexOf("UnderCols")];
        result[DEFAULT_NAMES.indexOf((Object)"OverRows")] = this.naxis2 - result[DEFAULT_NAMES.indexOf("ReadRows")] - result[DEFAULT_NAMES.indexOf("PreRows")];
        result[DEFAULT_NAMES.indexOf((Object)"OpFlags")] = this.datasec[0] == 3 ? 1 : 2;
        return result;
    }

    public String toString() {
        return "FitsFile{file=" + this.file + ", obsId=" + this.obsId + ", raftBay=" + this.raftBay + ", ccdSlot=" + this.ccdSlot + "}";
    }

    @Override
    public int compareTo(FitsFile other) {
        int result = this.obsId.compareTo(other.obsId);
        if (result != 0) {
            return result;
        }
        result = this.raftBay.compareTo(other.raftBay);
        if (result != 0) {
            return result;
        }
        return this.ccdSlot.compareTo(other.ccdSlot);
    }

    static class FitsSource
    extends Source {
        private final TreeMap<FitsFile, int[]> files = new TreeMap();

        FitsSource(Location location) {
            super(location);
        }

        private void add(FitsFile fitsFile, Path meta) throws IOException {
            int[] metaData;
            if (meta == null) {
                metaData = fitsFile.getReadOutParameters();
            } else {
                try (BufferedReader reader = Files.newBufferedReader(meta);){
                    String line = reader.readLine();
                    metaData = Arrays.stream(line.substring(1, line.length() - 1).split(",")).map(String::trim).mapToInt(Integer::parseInt).toArray();
                }
                catch (IOException x) {
                    throw new IOException("Error reading: " + meta);
                }
            }
            this.files.put(fitsFile, metaData);
        }

        public TreeMap<FitsFile, int[]> getFiles() {
            return this.files;
        }

        public String toString() {
            return "FitsSource{location=" + this.location + ", files=" + this.files + "}";
        }
    }

    static class RawSource
    extends Source {
        private final Path raw;
        private final int[] meta;

        RawSource(Location location, Path raw, Path meta) throws IOException {
            super(location);
            this.raw = raw;
            if (meta == null) {
                this.meta = NOMETA;
            } else {
                String line = Files.newBufferedReader(meta).readLine();
                this.meta = Arrays.stream(line.substring(1, line.length() - 1).split(",")).map(String::trim).mapToInt(Integer::parseInt).toArray();
            }
        }

        public String toString() {
            return "RawSource{location=" + this.location + ", raw=" + this.raw + ", meta=" + Arrays.toString(this.meta) + "}";
        }

        int[] getMetaData() {
            return this.meta;
        }

        Path getRaw() {
            return this.raw;
        }
    }

    static class Source {
        protected final Location location;
        protected static final int[] NOMETA = new int[0];

        Source(Location location) {
            this.location = location;
        }

        public Location getLocation() {
            return this.location;
        }
    }

    static class ObsId {
        private final String obsId;
        private final Map<Location, Source> sources;

        ObsId(String obsId) {
            this.obsId = obsId;
            this.sources = new TreeMap<Location, Source>();
        }

        void add(FitsFile fitsFile, Path meta) throws IOException {
            String ccdSlot = fitsFile.getCcdSlot();
            Location location = Location.of((String)(fitsFile.getRaftBay() + "/Reb" + ccdSlot.substring(1, 2)));
            FitsSource source = (FitsSource)this.sources.get(location);
            if (source == null) {
                source = new FitsSource(location);
                this.sources.put(location, source);
            }
            source.add(fitsFile, meta);
        }

        void add(Location location, Path raw, Path meta) throws IOException {
            this.sources.put(location, new RawSource(location, raw, meta));
        }

        public String getObsId() {
            return this.obsId;
        }

        public Set<Location> getLocations() {
            return this.sources.keySet();
        }

        public Map<Location, Source> getSources() {
            return this.sources;
        }

        public String toString() {
            return "ObsId{obsId=" + this.obsId + ", sources=" + this.sources + "}";
        }
    }
}

