/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.guider;

import java.time.Instant;
import java.util.List;
import org.lsst.ccs.utilities.location.SensorLocation;

public class Series {
    private final Instant begin;
    private final int sequence;
    private final int stamps;
    private final List<SensorLocation> configured;
    private final List<SensorLocation> remaining;

    private Series(long timestampNanos, int sequence, int stamps, List<SensorLocation> configured, List<SensorLocation> remaining) {
        this.begin = Instant.ofEpochSecond(timestampNanos / 1000000000L, timestampNanos % 1000000000L);
        this.sequence = sequence;
        this.stamps = stamps;
        this.configured = configured;
        this.remaining = remaining;
    }

    public Instant getBegin() {
        return this.begin;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getStamps() {
        return this.stamps;
    }

    public List<SensorLocation> getConfigured() {
        return this.configured;
    }

    public List<SensorLocation> getRemaining() {
        return this.remaining;
    }

    public String toString() {
        return "Series{begin=" + this.begin + ", sequence=" + this.sequence + ", stamps=" + this.stamps + ", configured=" + this.configured + ", remaining=" + this.remaining + "}";
    }
}

