/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.limits;

import java.util.List;
import org.lsst.ccs.subsystem.teststand.limits.LimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.LimitsInterface;
import org.lsst.ccs.subsystem.teststand.limits.TransitionAlgorithm;

class RatchetTransitionAlgorithm
implements TransitionAlgorithm {
    private LimitAlgorithm limitAlgorithm;
    private double lastValue;
    private boolean goingUp;
    private LimitsInterface limits;

    RatchetTransitionAlgorithm() {
    }

    @Override
    public void init(List<Double> parameters, LimitAlgorithm limitAlgorithm, double initialValue, LimitsInterface limits, long startTime) {
        if (!parameters.isEmpty()) {
            throw new IllegalArgumentException("RatchetTransitionAlgorithm does not take any parameters");
        }
        this.limitAlgorithm = limitAlgorithm;
        this.lastValue = initialValue;
        this.goingUp = limitAlgorithm.getTargetValue() > initialValue;
        this.limits = limits;
    }

    @Override
    public boolean isAtTarget(double currentValue, long time) {
        return currentValue > this.limitAlgorithm.getTargetLimits().getWarnLow() && currentValue < this.limitAlgorithm.getTargetLimits().getWarnHigh();
    }

    @Override
    public void adjustLimits(double currentValue, long time) {
        if (this.goingUp && currentValue > this.lastValue) {
            this.lastValue = currentValue;
            this.limitAlgorithm.adjust(currentValue, this.limits);
        } else if (!this.goingUp && currentValue < this.lastValue) {
            this.lastValue = currentValue;
            this.limitAlgorithm.adjust(currentValue, this.limits);
        }
    }

    @Override
    public void completeTransition(long time) {
        this.limitAlgorithm.getTargetLimits().copyTo(this.limits);
    }

    @Override
    public LimitsInterface getLimits() {
        return this.limits;
    }
}

