/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.daq.guider.ClearParameters;
import org.lsst.ccs.daq.guider.Config;
import org.lsst.ccs.daq.guider.ROICommon;
import org.lsst.ccs.daq.guider.ROICommonExtended;
import org.lsst.ccs.daq.guider.ROISpec;
import org.lsst.ccs.daq.guider.SeriesStatus;
import org.lsst.ccs.daq.guider.Status;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Guider;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.focalplane.SequencerConfig;
import org.lsst.ccs.subsystem.focalplane.states.GuidingState;
import org.lsst.ccs.utilities.location.SensorLocationSet;

public class Guiding {
    private static final Logger LOG = Logger.getLogger(Guiding.class.getName());
    private static Map<Status.State, GuidingState> stateMap = Map.of(Status.State.STOPPED, GuidingState.STOPPED, Status.State.OFF, GuidingState.OFF, Status.State.ERROR, GuidingState.ERROR, Status.State.PAUSED, GuidingState.PAUSED, Status.State.RUNNING, GuidingState.RUNNING, Status.State.UNDEFINED, GuidingState.UNDEFINED, Status.State.CLEARING, GuidingState.CLEARING);
    private final SequencerConfig sequencerConfig;
    private final AgentStateService agentStateService;
    private ROISpec roiSpec;
    private static final SensorLocationSet NO_SENSORS = new SensorLocationSet();

    public Guiding(SequencerConfig config, AgentStateService agentStateService) {
        this.sequencerConfig = config;
        this.agentStateService = agentStateService;
        boolean hasGuiderPartition = this.sequencerConfig.hasGuiderPartition();
        if (hasGuiderPartition) {
            try {
                Status.State out = this.sequencerConfig.getGuider().series().getStatus().getOut();
                this.updateState(out);
                if (out != Status.State.STOPPED && out != Status.State.OFF) {
                    this.stopGuiding();
                }
            }
            catch (DAQException x) {
                LOG.log(Level.SEVERE, "Error initializing guider state", x);
                agentStateService.updateAgentState(new Enum[]{GuidingState.UNDEFINED});
            }
        } else {
            agentStateService.updateAgentState(new Enum[]{GuidingState.UNDEFINED});
        }
    }

    private void updateState(Status.State state) {
        LOG.log(Level.INFO, "Initial guding state {0}", state);
        this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(state)});
    }

    void initGuiders(String roiSpec) throws DAQException {
        this.roiSpec = ROISpec.parse((String)roiSpec);
        Guider guider = this.sequencerConfig.getGuider();
        SeriesStatus series = guider.series();
        Status.State out = series.getStatus().getOut();
        if (out == Status.State.OFF) {
            guider.wake(this.sequencerConfig.getGuiderIdleClearParameters());
        } else if (out == Status.State.ERROR) {
            this.recoverFromErrorBeforeInitGuiders(guider);
        } else if (out == Status.State.PAUSED) {
            LOG.log(Level.WARNING, "Accepting initGuiders when guiders already in PAUSED state");
            Status status = guider.stop();
            this.checkStatus(status, GuidingState.STOPPED);
        }
        ROICommonExtended rce = new ROICommonExtended(this.roiSpec.getCommon(), this.sequencerConfig.getExtendedROIParameters());
        Status status = guider.start((ROICommon)rce, this.roiSpec.getLocations());
        this.checkStatus(status, GuidingState.PAUSED);
    }

    int validate(String roiSpec) throws DAQException {
        ROISpec spec = ROISpec.parse((String)roiSpec);
        Guider guider = this.sequencerConfig.getGuider();
        spec.sanityCheck(guider.getConfiguredLocations());
        spec.sanityCheckWithSensorLocations(this.sequencerConfig.getGuiderLocations());
        ROICommon common = spec.getCommon();
        guider.validate(common, spec.getLocations());
        int rows = common.getRows();
        int cols = common.getCols();
        int ns = 32751760 + 490700 * rows + 1030 * cols * rows;
        return common.getIntegrationTimeMillis() + ns / 1000000;
    }

    void resumeGuiding(String imageName) throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        try {
            Status status = guider.resume(imageName);
            this.checkStatus(status, GuidingState.RUNNING);
        }
        catch (DAQException x) {
            Status.State out = guider.series().getStatus().getOut();
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
            throw x;
        }
    }

    int pauseGuiding() throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        try {
            Status status = guider.pause();
            this.checkStatus(status, GuidingState.PAUSED);
            int stamps = guider.series().getSeries().getStamps();
            return stamps;
        }
        catch (DAQException x) {
            Status.State in = guider.series().getStatus().getIn();
            if (in == Status.State.ERROR) {
                this.recoverFromErrorBeforePause(guider);
                return 0;
            }
            Status.State out = guider.series().getStatus().getOut();
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
            throw x;
        }
    }

    private void recoverFromErrorBeforePause(Guider guider) throws DAQException {
        try {
            LOG.log(Level.WARNING, "Attempting to recover from ERROR before pause, transitioning to STOPPED");
            Status status = guider.stop();
            this.checkStatus(status, GuidingState.STOPPED);
        }
        catch (DAQException x) {
            Status.State out = guider.series().getStatus().getOut();
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
            throw x;
        }
    }

    private void recoverFromErrorBeforeInitGuiders(Guider guider) throws DAQException {
        try {
            LOG.log(Level.WARNING, "Attempting to recover from ERROR before initGuiders, transitioning to STOPPED");
            Status status = guider.stop();
            this.checkStatus(status, GuidingState.STOPPED);
        }
        catch (DAQException x) {
            Status.State out = guider.series().getStatus().getOut();
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
            throw x;
        }
    }

    boolean isROISet() {
        return this.roiSpec != null;
    }

    void stopGuiding() throws DAQException {
        this.roiSpec = null;
        Guider guider = this.sequencerConfig.getGuider();
        Status.State out = guider.series().getStatus().getOut();
        if (out != Status.State.OFF && out != Status.State.UNDEFINED && out != Status.State.STOPPED) {
            try {
                Status status = guider.stop();
                this.checkStatus(status, GuidingState.STOPPED);
            }
            catch (DAQException x) {
                out = guider.series().getStatus().getOut();
                this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
                throw x;
            }
        } else {
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
        }
    }

    SensorLocationSet getSensors() {
        return this.roiSpec == null ? NO_SENSORS : this.roiSpec.getSensorLocations();
    }

    void sleepGuider() throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        try {
            Status status = guider.sleep();
            this.checkStatus(status, GuidingState.OFF);
        }
        catch (DAQException x) {
            Status.State out = guider.series().getStatus().getOut();
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
            throw x;
        }
    }

    void wakeGuider() throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        try {
            Status status = guider.wake(this.sequencerConfig.getGuiderIdleClearParameters());
            this.checkStatus(status, GuidingState.STOPPED);
        }
        catch (DAQException x) {
            Status.State out = guider.series().getStatus().getOut();
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
            throw x;
        }
    }

    void clearGuider(ClearParameters clearParameters) throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        try {
            Status status = guider.clear(clearParameters);
            this.checkStatus(status, GuidingState.CLEARING);
        }
        catch (DAQException x) {
            Status.State out = guider.series().getStatus().getOut();
            this.agentStateService.updateAgentState(new Enum[]{(Enum)stateMap.get(out)});
            throw x;
        }
    }

    SeriesStatus series() throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        return guider.series();
    }

    Config config() throws DAQException {
        Guider guider = this.sequencerConfig.getGuider();
        return guider.config();
    }

    private void checkStatus(Status status, GuidingState expectedState) {
        GuidingState newState = this.mapStateToGuidingState(status.getOut());
        this.agentStateService.updateAgentState(new Enum[]{newState});
        if (newState != expectedState) {
            throw new RuntimeException("Guider entered unexpected state, expected=" + expectedState + " actual=" + newState);
        }
    }

    private GuidingState mapStateToGuidingState(Status.State state) {
        return stateMap.getOrDefault(state, GuidingState.UNDEFINED);
    }
}

