/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.io;

import java.util.Hashtable;
import org.freehep.xml.io.XMLIOFactory;
import org.freehep.xml.io.XMLIOProxy;
import org.freehep.xml.io.XMLIORegistry;

public class DefaultXMLIORegistry
implements XMLIORegistry {
    private Hashtable factoryHash = new Hashtable();
    private Hashtable proxyHash = new Hashtable();
    private Hashtable classIds = new Hashtable();
    private Hashtable idClasses = new Hashtable();

    @Override
    public void register(Object obj) {
        int i;
        Class[] classes;
        if (!(obj instanceof XMLIOFactory) && !(obj instanceof XMLIOProxy)) {
            throw new IllegalArgumentException("Cannot register object " + obj + "." + "Only XMLIOFactories and XMLIOProxies can be registered!");
        }
        if (obj instanceof XMLIOFactory) {
            XMLIOFactory xmlioFactory = (XMLIOFactory)obj;
            classes = xmlioFactory.XMLIOFactoryClasses();
            for (i = 0; i < classes.length; ++i) {
                if (this.factoryHash.containsKey(classes[i])) {
                    throw new IllegalArgumentException("Identifier " + classes[i] + " has already been registered!!");
                }
                this.factoryHash.put(classes[i], xmlioFactory);
                this.addClassId(classes[i]);
            }
        }
        if (obj instanceof XMLIOProxy) {
            XMLIOProxy xmlioProxy = (XMLIOProxy)obj;
            classes = xmlioProxy.XMLIOProxyClasses();
            for (i = 0; i < classes.length; ++i) {
                if (this.proxyHash.containsKey(classes[i])) {
                    throw new IllegalArgumentException("Class " + classes[i] + " has already been registered!!");
                }
                this.proxyHash.put(classes[i], xmlioProxy);
            }
        }
    }

    private void addClassId(Class clazz) {
        String objClassString = clazz.toString();
        String classId = objClassString.substring(objClassString.lastIndexOf(".") + 1);
        if (this.classIds.containsValue(classId = classId.replace('$', '-'))) {
            throw new RuntimeException("Already registered ClassId in the registry!!! " + classId);
        }
        this.classIds.put(clazz, classId);
        this.idClasses.put(classId, clazz);
    }

    @Override
    public XMLIOFactory getXMLIOFactory(Class objClass) {
        return (XMLIOFactory)this.factoryHash.get(objClass);
    }

    @Override
    public XMLIOProxy getXMLIOProxy(Class objClass) {
        return (XMLIOProxy)this.proxyHash.get(objClass);
    }

    @Override
    public String getClassId(Class clName) {
        if (!this.classIds.containsKey(clName)) {
            this.addClassId(clName);
        }
        return (String)this.classIds.get(clName);
    }

    @Override
    public Class getIdClass(String objName) {
        return (Class)this.idClasses.get(objName);
    }
}

