/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.twistorr.TwisTorr;
import org.lsst.ccs.subsystem.common.devices.turbopump.TwisTorrDevice;
import org.lsst.ccs.subsystem.vacuum.SwitchDevice;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;

public class VacTurboDevice
extends TwisTorrDevice
implements SwitchDevice {
    private static final Logger LOG = Logger.getLogger(VacTurboDevice.class.getName());
    public static final int SW_PUMP = 0;
    public static final int SW_VENT = 1;
    private static final Map<TwisTorr.PumpStatus, DeviceState> turboStateMap = new HashMap<TwisTorr.PumpStatus, DeviceState>();
    private static final Map<String, TwisTorr.CmndBool> registerBoolMap;
    private static final Map<String, TwisTorr.CmndNumeric> registerNumMap;
    private int deviceId = -1;
    private TwisTorr.CntlrModels model = null;

    public VacTurboDevice(int deviceId, String modelName) throws DriverException {
        LOG.fine("modelName = " + modelName);
        if (modelName != null) {
            this.model = TwisTorr.CntlrModels.valueOf((String)modelName);
            this.setModel(this.model);
        }
        LOG.fine("model = " + this.model);
        this.deviceId = deviceId;
    }

    @Override
    public int getSwitchDevice() {
        return this.deviceId;
    }

    @Override
    public void setSwitch(int sw, boolean on) throws DriverException {
        if (sw == 0) {
            if (on) {
                this.startTurboPump();
            } else {
                this.stopTurboPump();
            }
        } else if (sw == 1) {
            if (on) {
                this.timedPulseVentValve();
            } else {
                this.closeVentValve();
            }
        } else {
            LOG.log(Level.WARNING, String.format("setSwitch(sw=%d, on=%s): invalid argument sw", sw, on));
        }
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        if (sw == 0) {
            DeviceState st = this.getDeviceState();
            return st == null ? null : Boolean.valueOf(st != DeviceState.STOPPED && st != DeviceState.BRAKING);
        }
        if (sw == 1) {
            return this.getVentValveOpenState();
        }
        LOG.log(Level.WARNING, String.format("isSwitchon(sw=%d): invalid argument sw", sw));
        return null;
    }

    public DeviceState getDeviceState() {
        try {
            return turboStateMap.get(this.readTurboStatus());
        }
        catch (DriverException e) {
            return null;
        }
    }

    public Boolean getVentValveOpenState() {
        try {
            return this.isVentValveOpen();
        }
        catch (DriverException e) {
            return null;
        }
    }

    static {
        turboStateMap.put(TwisTorr.PumpStatus.STOP, DeviceState.STOPPED);
        turboStateMap.put(TwisTorr.PumpStatus.WAIT_INTLK, DeviceState.WAITING);
        turboStateMap.put(TwisTorr.PumpStatus.STARTING, DeviceState.STARTNG);
        turboStateMap.put(TwisTorr.PumpStatus.NORMAL, DeviceState.NORMAL);
        turboStateMap.put(TwisTorr.PumpStatus.BRAKING, DeviceState.BRAKING);
        turboStateMap.put(TwisTorr.PumpStatus.FAIL, DeviceState.FAILED);
        turboStateMap.put(TwisTorr.PumpStatus.AUTO_TUNING, DeviceState.AUTOTUN);
        registerBoolMap = new HashMap<String, TwisTorr.CmndBool>();
        registerBoolMap.put("lowSpeedMode", TwisTorr.CmndBool.LOW_SPEED_MODE);
        registerBoolMap.put("softStartMode", TwisTorr.CmndBool.SOFT_START_MODE);
        registerBoolMap.put("interlockType", TwisTorr.CmndBool.INTERLOCK_TYPE);
        registerBoolMap.put("ventvalveByCmnd", TwisTorr.CmndBool.VENTVALVE_BY_CMND);
        registerBoolMap.put("speedReadActive", TwisTorr.CmndBool.SPEED_READ_ACTIVATE);
        registerBoolMap.put("setpointActive", TwisTorr.CmndBool.SETPOINT_ACTIVE);
        registerBoolMap.put("ventvalveType", TwisTorr.CmndBool.VENTVALVE_TYPE);
        registerBoolMap.put("activeStopMode", TwisTorr.CmndBool.ACTIVE_STOP_MODE);
        registerBoolMap.put("waterCooling", TwisTorr.CmndBool.WATER_COOLING);
        registerBoolMap.put("gasType", TwisTorr.CmndBool.GAS_TYPE_ARGON);
        registerNumMap = new HashMap<String, TwisTorr.CmndNumeric>();
        registerNumMap.put("setpointType", TwisTorr.CmndNumeric.SETPOINT_TYPE);
        registerNumMap.put("setpointThresh", TwisTorr.CmndNumeric.SETPOINT_THRESH);
        registerNumMap.put("ventDelay", TwisTorr.CmndNumeric.VENT_DELAY);
        registerNumMap.put("rotfreq_set", TwisTorr.CmndNumeric.ROTFREQ_SET);
        registerNumMap.put("rotfreq_low", TwisTorr.CmndNumeric.ROTFREQ_LOW);
        registerNumMap.put("gasType", TwisTorr.CmndNumeric.GAS_TYPE);
    }
}

