/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import java.util.concurrent.locks.Condition;
import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.sim.AddressSpace;
import org.lsst.ccs.drivers.reb.sim.AutoCloseableReentrantLock;
import org.lsst.ccs.drivers.reb.sim.DAQSimulation;
import org.lsst.ccs.drivers.reb.sim.HandleAndIdManager;
import org.lsst.ccs.drivers.reb.sim.PixelCounter;
import org.lsst.ccs.drivers.reb.sim.REB3Simulation;
import org.lsst.ccs.drivers.reb.sim.SequencerSimulation;
import org.lsst.ccs.drivers.reb.sim.SimulatedImage;
import org.lsst.ccs.drivers.reb.sim.SimulationException;

public class ImageClientDaq1Simulation
implements ImageClient.Impl {
    private final HandleAndIdManager manager;
    private REB3Simulation reb3;
    private final DAQSimulation daq;
    private final AutoCloseableReentrantLock stateLock = new AutoCloseableReentrantLock();
    private final Condition imageDelivered = this.stateLock.newCondition();
    private final PixelCounter pixelCounter = new PixelCounter();
    private int schema;
    private int version;
    private int id;
    private long tag;
    private int length;
    private final SequencerSimulation.StateListener stateListener = (oldState, newState) -> {
        try (AutoCloseableReentrantLock lock = this.stateLock.open();){
            if (newState == SequencerSimulation.State.RUNNING) {
                this.tag = this.reb3.getTriggerTime(2);
                this.pixelCounter.reset();
            }
            if (oldState == SequencerSimulation.State.RUNNING && newState == SequencerSimulation.State.STOPPED) {
                this.length = this.pixelCounter.getPixels() * 16 * 4;
                if (this.length > 0) {
                    this.imageDelivered.signalAll();
                }
            }
        }
    };

    ImageClientDaq1Simulation(HandleAndIdManager manager, DAQSimulation daq) {
        this.manager = manager;
        this.daq = daq;
    }

    @Override
    public void newImageClient(int id, String ifc) {
        AddressSpace rs = this.manager.getAddressSpaceForId(id);
        if (rs instanceof REB3Simulation) {
            if (this.reb3 != null) {
                throw new SimulationException("Unsupported repeat call to newImageClient");
            }
        } else {
            throw new SimulationException("Unsupported implementation of AddressSpace returned");
        }
        this.reb3 = (REB3Simulation)rs;
        this.reb3.getSequencer().addStateListener(this.stateListener);
        this.reb3.getSequencer().addWaveformListener(this.pixelCounter);
        this.schema = this.reb3.read(0);
        this.version = this.reb3.read(1);
        this.id = this.reb3.read(2);
    }

    @Override
    public void deleteImageClient() {
        if (this.reb3 != null) {
            this.reb3.getSequencer().removeStateListener(this.stateListener);
            this.reb3.getSequencer().removeWaveformListener(this.pixelCounter);
        }
    }

    @Override
    public Image waitForImage(Image image) {
        SimulatedImage result = image instanceof SimulatedImage ? (SimulatedImage)image : new SimulatedImage(this);
        result.setSchema(this.schema);
        result.setVersion(this.version);
        result.setAddress(this.id);
        result.setRebType(this.daq.getRebType());
        AutoCloseableReentrantLock lock = this.stateLock.open();
        try {
            this.imageDelivered.await();
            result.setLength(this.length * result.getNumCcds());
            result.setTag(this.tag);
            SimulatedImage simulatedImage = result;
            if (lock != null) {
                lock.close();
            }
            return simulatedImage;
        }
        catch (Throwable throwable) {
            try {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException ex) {
                throw new SimulationException("Interrupted while waiting for image", new Object[]{ex});
            }
        }
    }

    @Override
    public boolean getImage(Image image) {
        if (image instanceof SimulatedImage) {
            SimulatedImage simImage = (SimulatedImage)image;
            int[] registers = this.daq.getRegisters();
            int[] metadata = null;
            if (registers != null) {
                metadata = new int[registers.length];
                for (int i = 0; i < registers.length; ++i) {
                    this.reb3.readRegs(registers[i], metadata, i, 1);
                }
            }
            simImage.setRegisters(metadata);
            simImage.setName(this.daq.getImageName());
            simImage.setData(this.daq.getDataProvider().getData(image.getMetadata()));
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
    }

    @Override
    public void deleteImageMetadataRef(Image image) {
    }
}

