/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.EncoderSample;
import org.lsst.ccs.subsystem.shutter.common.HallTransition;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.plc.MsgToCCS;
import org.lsst.ccs.subsystem.shutter.plc.Tools;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.subsystem.shutter.status.PtpDeviceState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class MotionDonePLC
extends MsgToCCS {
    private static final Logger LOG = Logger.getLogger(MotionDonePLC.class.getName());
    final MotionDone motion;
    private static final int HALL_TRANSITION_SIZE;
    private static final int ENCODER_SAMPLE_SIZE;

    public MotionDonePLC(int sequence, MotionDone motion) {
        super(sequence);
        this.motion = motion;
    }

    public MotionDonePLC(ByteBuffer data) {
        super(data);
        int i;
        MotionDone.Builder builder = new MotionDone.Builder().side(ShutterSide.fromAxis(Axis.fromAxisNum(data.getInt())));
        long dcTime64Start = data.getLong();
        LOG.log(Level.FINER, "Raw motion start time: {0}", new Object[]{Long.toUnsignedString(dcTime64Start)});
        builder.startPosition(data.getDouble()).targetDuration(Tools.fromDcDuration(data.getLong())).targetPosition(data.getDouble()).endPosition(data.getDouble()).actualDuration(Tools.fromDcDuration(data.getLong())).hallTransitions(new ArrayList<HallTransition>()).encoderSamples(new ArrayList<EncoderSample>());
        int ntrans = data.getInt();
        int maxtrans = data.getInt();
        int nsamples = data.getInt();
        int maxsamples = data.getInt();
        int tranStart = data.position();
        data.position(data.position() + maxtrans * HALL_TRANSITION_SIZE + maxsamples * ENCODER_SAMPLE_SIZE);
        builder.ptpState(PtpDeviceState.fromStateNumber(data.getInt()));
        int leaps = data.getInt();
        builder.leapSeconds(leaps).leapIsValid(Tools.getBoolean(data)).startTime(Tools.fromDcTime64(dcTime64Start, leaps));
        int postPtp = data.position();
        data.position(tranStart);
        LOG.log(Level.FINER, "[Raw Hall transitions] id, time, pos, on");
        for (i = 0; i < ntrans; ++i) {
            builder.addHallTransition(this.decodeHallTransition(data, leaps));
        }
        LOG.log(Level.FINER, "[End Hall]");
        data.position(tranStart + maxtrans * HALL_TRANSITION_SIZE);
        for (i = 0; i < nsamples; ++i) {
            builder.addEncoderSample(MotionDonePLC.decodeEncoderSample(data, leaps));
        }
        data.position(data.position() + (maxsamples - nsamples) * ENCODER_SAMPLE_SIZE);
        data.position(postPtp);
        this.motion = builder.build();
    }

    @Override
    public void encode(ByteBuffer data) {
        super.encode(data);
        Axis ax = this.motion.side() == ShutterSide.PLUSX ? Axis.getPlusXSide() : Axis.getMinusXSide();
        data.putInt(ax.getPLCAxisNum());
        data.putLong(Tools.toDcTime64(this.motion.startTime()));
        int tdai = (int)Duration.between(this.motion.startTime().getUTCInstant(), this.motion.startTime().getTAIInstant()).getSeconds();
        data.putDouble(this.motion.startPosition());
        data.putLong(Tools.toDcDuration(this.motion.targetDuration()));
        data.putDouble(this.motion.targetPosition());
        data.putDouble(this.motion.endPosition());
        data.putLong(Tools.toDcDuration(this.motion.actualDuration()));
        int ntrans = this.motion.hallTransitions().size();
        int unused = 5;
        data.putInt(ntrans);
        data.putInt(ntrans + 5);
        int nsamples = this.motion.encoderSamples().size();
        data.putInt(nsamples);
        data.putInt(nsamples + 5);
        for (HallTransition trans : this.motion.hallTransitions()) {
            MotionDonePLC.encodeHallTransition(data, trans, tdai);
        }
        data.position(data.position() + 5 * HALL_TRANSITION_SIZE);
        for (EncoderSample sample : this.motion.encoderSamples()) {
            MotionDonePLC.encodeEncoderSample(data, sample, tdai);
        }
        data.position(data.position() + 5 * ENCODER_SAMPLE_SIZE);
        data.putInt(PtpDeviceState.toStateNumber(PtpDeviceState.SLAVE));
        data.putInt(tdai);
        Tools.putBoolean(data, true);
    }

    private HallTransition decodeHallTransition(ByteBuffer data, int leapSeconds) {
        int id = data.getInt();
        long rawtime = data.getLong();
        CCSTimeStamp time = Tools.fromDcTime64(rawtime, leapSeconds);
        double pos = data.getDouble();
        boolean on = Tools.getBoolean(data);
        LOG.log(Level.FINER, "{0}, {1}, {2}, {3}", new Object[]{id, Long.toUnsignedString(rawtime), pos, on});
        return new HallTransition(time, id, pos, on);
    }

    private static int encodeHallTransition(ByteBuffer data, HallTransition hall, int leapSeconds) {
        int start = data.position();
        data.putInt(hall.getSensorId());
        data.putLong(Tools.toDcTime64(hall.getTime()));
        data.putDouble(hall.getPosition());
        Tools.putBoolean(data, hall.isOn());
        return data.position() - start;
    }

    private static EncoderSample decodeEncoderSample(ByteBuffer data, int leapSeconds) {
        CCSTimeStamp time = Tools.fromDcTime64(data.getLong(), leapSeconds);
        double pos = data.getDouble();
        return new EncoderSample(time, pos);
    }

    private static int encodeEncoderSample(ByteBuffer data, EncoderSample sample, int leapSeconds) {
        int start = data.position();
        data.putLong(Tools.toDcTime64(sample.getTime()));
        data.putDouble(sample.getPosition());
        return data.position() - start;
    }

    @Override
    public String toString() {
        return "MotionDonePLC{" + super.toString() + " motion=" + this.motion.toString() + "}";
    }

    public MotionDone getStatusBusMessage() {
        return this.motion;
    }

    static {
        ByteBuffer data = ByteBuffer.allocate(1000);
        HallTransition hall = new HallTransition(CCSTimeStamp.currentTime(), 0, 0.0, false);
        HALL_TRANSITION_SIZE = MotionDonePLC.encodeHallTransition(data, hall, 0);
        EncoderSample sample = new EncoderSample(CCSTimeStamp.currentTime(), 0.0);
        ENCODER_SAMPLE_SIZE = MotionDonePLC.encodeEncoderSample(data, sample, 0);
    }
}

