/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lambda;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.drivers.i2c.I2c;

public class Cpfe1000
extends I2c
implements PowerSupplyDriver {
    public static final int MODEL_UNKNOWN = -1;
    public static final int MODEL_12 = 0;
    public static final int MODEL_28 = 1;
    public static final int MODEL_48 = 2;
    public static final int MODEL_I12 = 3;
    public static final int MODEL_I28 = 4;
    public static final int MODEL_I48 = 5;
    public static final int STATUS_OFF = 1;
    public static final int STATUS_DSAB = 2;
    public static final int STATUS_IOGB = 4;
    public static final int STATUS_OTW = 8;
    public static final int STATUS_OTP = 16;
    public static final int STATUS_VBAD = 32;
    public static final int STATUS_IBAD = 64;
    public static final int STATUS_MASK = 127;
    private static final int REG_STATUS = 7;
    private static final int REG_SERIAL_NO = 1;
    private static final int REG_FIRMWARE_REV = 2;
    private static final int REG_PRODUCT_REV = 3;
    private static final int REG_UNIT_PART_NO = 8;
    private static final int REG_MFG_DATE = 9;
    private static final int REG_MFG_LOCATION = 16;
    private static final int REG_VOLTAGE = 4;
    private static final int REG_CURRENT = 5;
    private static final int REG_TEMPERATURE = 6;
    private static final int REG_TURN_ON = 26;
    private static final int REG_TURN_OFF = 10;
    private static final int LENG_STATUS = 1;
    private static final int LENG_SERIAL_NO = 20;
    private static final int LENG_FIRMWARE_REV = 3;
    private static final int LENG_FIRMWARE_REV_I = 4;
    private static final int LENG_PRODUCT_REV = 4;
    private static final int LENG_UNIT_PART_NO = 11;
    private static final int LENG_UNIT_PART_NO_I = 12;
    private static final int LENG_MFG_DATE = 8;
    private static final int LENG_MFG_LOCATION = 3;
    private static final int LENG_VOLTAGE = 2;
    private static final int LENG_CURRENT = 2;
    private static final int LENG_TEMPERATURE = 2;
    private static final int LENG_TURN_ON = 1;
    private static final int LENG_TURN_OFF = 1;
    private static final int ADC_BAD_MASK = 64512;
    private static final Map<String, Integer> modelMap = new HashMap<String, Integer>();
    private static final double[] vScales;
    private static final double[] iScales;
    private static final double[] tScales;
    private static final int[] lengFirmwareRevs;
    private static final int[] lengUnitPartNos;
    private int busAddr;
    private int model;
    private int lengFirmwareRev;
    private int lengUnitPartNo;
    private double vScale;
    private double iScale;
    private double tScale;

    @Override
    public void open(String ident, int addr) throws DriverException {
        super.open(ident, 0);
        this.busAddr = addr;
        this.model = -1;
        this.lengUnitPartNo = 11;
        try {
            String mName = this.getUnitPartNo();
            if (mName.startsWith("CPFE1000F")) {
                Integer mod = modelMap.get(mName.substring(9));
                int n = this.model = mod == null ? this.model : mod;
            }
            if (this.model == -1) {
                throw new DriverException("Unrecognized Lambda PS model: " + mName);
            }
            this.vScale = vScales[this.model];
            this.iScale = iScales[this.model];
            this.tScale = tScales[this.model / 3];
            this.lengFirmwareRev = lengFirmwareRevs[this.model / 3];
            this.lengUnitPartNo = lengUnitPartNos[this.model / 3];
        }
        catch (DriverException e) {
            this.close();
            throw e;
        }
    }

    public int getModel() {
        return this.model;
    }

    public String getSerialNo() throws DriverException {
        return this.readString(1, 20);
    }

    public String getFirmwareRev() throws DriverException {
        return this.readString(2, this.lengFirmwareRev);
    }

    public String getProductRev() throws DriverException {
        return this.readString(3, 4);
    }

    public String getUnitPartNo() throws DriverException {
        return this.readString(8, this.lengUnitPartNo);
    }

    public String getManufactureDate() throws DriverException {
        return this.readString(9, 8);
    }

    public String getManufactureLoc() throws DriverException {
        return this.readString(16, 3);
    }

    public int readStatus() throws DriverException {
        return this.readInt(7, 1) & 0x7F;
    }

    public double readVoltage() throws DriverException {
        return Cpfe1000.fixValue(this.readInt(4, 2)) * this.vScale;
    }

    public double readCurrent() throws DriverException {
        return Cpfe1000.fixValue(this.readInt(5, 2)) * this.iScale;
    }

    public double readTemperature() throws DriverException {
        return (Cpfe1000.fixValue(this.readInt(6, 2)) - 610.0) / this.tScale + 25.0;
    }

    public void powerOn() throws DriverException {
        this.write(this.busAddr, 26, new byte[1]);
    }

    public void powerOff() throws DriverException {
        this.write(this.busAddr, 10, new byte[1]);
    }

    private int readInt(int reg, int count) throws DriverException {
        byte[] data = this.doRead(reg, count);
        int value = data[0] & 0xFF;
        if (count == 2) {
            value = value << 8 | data[1] & 0xFF;
        }
        return value;
    }

    private String readString(int reg, int count) throws DriverException {
        return new String(this.doRead(reg, count));
    }

    private byte[] doRead(int reg, int count) throws DriverException {
        byte[] data = new byte[count];
        int nread = this.read(this.busAddr, reg, data);
        if (nread < count) {
            throw new DriverException("Data deficit: " + nread + "/" + count + " bytes read");
        }
        return data;
    }

    private static double fixValue(int raw) {
        return (raw & 0xFC00) == 0 ? (double)raw : Double.NaN;
    }

    public void open(DriverConstants.ConnType connType, String ident, int addr) throws DriverException {
        if (connType != DriverConstants.ConnType.SERIAL) {
            throw new DriverException("Invalid connection type: " + connType);
        }
        this.open(ident, addr);
    }

    public double readCurrent(int chan) throws DriverException {
        return this.readCurrent();
    }

    public double getCurrent(int chan) throws DriverException {
        return this.readCurrent();
    }

    public void setCurrent(double value, int chan) throws DriverException {
    }

    public double readVoltage(int chan) throws DriverException {
        return this.readVoltage();
    }

    public double getVoltage(int chan) throws DriverException {
        return this.readVoltage();
    }

    public void setVoltage(double value, int chan) {
    }

    public void setOffDelay(double value, int chan) {
    }

    public void setOnDelay(double value, int chan) {
    }

    public boolean getOutput(int chan) throws DriverException {
        return (this.readStatus() & 1) == 0;
    }

    public void setOutput(boolean on, int chan) throws DriverException {
        if (on) {
            this.powerOn();
        } else {
            this.powerOff();
        }
    }

    static {
        modelMap.put("12", 0);
        modelMap.put("28", 1);
        modelMap.put("48", 2);
        modelMap.put("I1", 3);
        modelMap.put("I2", 4);
        modelMap.put("I4", 5);
        vScales = new double[]{0.034, 0.0777, 0.1355, 0.01668, 0.03973, 0.06772};
        iScales = new double[]{0.0815, 0.0488, 0.0282, 0.0815, 0.0488, 0.0282};
        tScales = new double[]{1.8, 2.048};
        lengFirmwareRevs = new int[]{3, 4};
        lengUnitPartNos = new int[]{11, 12};
    }
}

