/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;

public class PcpPowerControl
implements HasLifecycle,
Maq20Device.Maq20Control {
    protected static final int CHAN_IN_VOLTAGE = 0;
    protected static final int CHAN_OUT_VOLTAGE = 1;
    protected static final int CHAN_IN_CURRENT = 2;
    protected static final int CHAN_OUT_CURRENT = 3;
    protected static final int CHAN_IN_ENABLED = 4;
    protected static final int NUM_CHANNELS = 5;
    private static final Map<Integer, Double> inScaleMap = new HashMap<Integer, Double>();
    private static final Map<Integer, Double> outScaleMap;
    @LookupName
    protected String name;
    @LookupPath
    protected String path;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    protected Maq20Device maqDevc;
    protected Integer ident;
    protected String inVoltage;
    protected String outVoltage;
    protected String inCurrent;
    protected String outCurrent;
    protected String inEnabled;
    protected Double maxCurrent;
    private static final Logger LOG;
    protected final ChannelDesc[] channelDescs = new ChannelDesc[5];

    public void init() {
        if (this.ident == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"ident", (String)"has not been specified");
        }
        if (this.ident < 0 || this.ident >= 3) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"ident", (String)"must be non-negative and less than 3");
        }
        this.channelDescs[0] = this.decodeChannel("inVoltage", this.inVoltage, false);
        this.channelDescs[1] = this.decodeChannel("outVoltage", this.outVoltage, true);
        this.channelDescs[2] = this.decodeChannel("inCurrent", this.inCurrent, false);
        this.channelDescs[3] = this.decodeChannel("outCurrent", this.outCurrent, true);
        this.channelDescs[4] = this.decodeChannel("inEnabled", this.inEnabled, false);
        if (this.maxCurrent == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"currentLimit", (String)"has not been specified");
        }
    }

    public void initialize() throws DriverException {
        for (ChannelDesc chanDesc : this.channelDescs) {
            chanDesc.moduleData.maqAna.setRange(chanDesc.hwChannel, chanDesc.range);
        }
        this.setCurrent(this.maxCurrent);
    }

    public void close() {
    }

    public double readVoltage() throws DriverException {
        ChannelDesc chanDesc = this.channelDescs[0];
        return chanDesc.moduleData.maqAnaIn.readValue(chanDesc.hwChannel) / chanDesc.scale;
    }

    public void setVoltage(double value) throws DriverException {
        ChannelDesc chanDesc = this.channelDescs[1];
        chanDesc.moduleData.maqAnaOut.writeValue(chanDesc.hwChannel, chanDesc.scale * value);
    }

    public double readCurrent() throws DriverException {
        ChannelDesc chanDesc = this.channelDescs[2];
        return chanDesc.moduleData.maqAnaIn.readValue(chanDesc.hwChannel) / chanDesc.scale;
    }

    public void setCurrent(double value) throws DriverException {
        ChannelDesc chanDesc = this.channelDescs[3];
        chanDesc.moduleData.maqAnaOut.writeValue(chanDesc.hwChannel, chanDesc.scale * value);
    }

    public boolean isOutputOn() throws DriverException {
        ChannelDesc chanDesc = this.channelDescs[4];
        return chanDesc.moduleData.maqAnaIn.readValue(chanDesc.hwChannel) < 0.5;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public int getIdent() {
        return this.ident;
    }

    private ChannelDesc decodeChannel(String chanName, String channel, boolean isOut) {
        int hwChannel = 0;
        double fullScale = 0.0;
        Maq20Device.ModuleData modData = null;
        String[] words = channel.split(":");
        if (words.length != 4) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)chanName, (String)"does not contain exactly four elements");
        }
        try {
            int modIndex = Integer.valueOf(words[0]);
            modData = this.maqDevc.getModuleData(modIndex);
            if (modData == null) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)(chanName + " modIndex (" + modIndex + ")"), (String)"specifies non-existent module");
            }
            Maq20Device.ModuleDef modDef = modData.modDef;
            if (modDef.opType != (isOut ? 1 : 0)) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)(chanName + " modIndex (" + modIndex + ")"), (String)("does not specify analog " + (isOut ? "output" : "input") + " module"));
            }
        }
        catch (NumberFormatException e) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)(chanName + " modIndex (" + words[0] + ")"), (String)"is not an integer");
        }
        try {
            hwChannel = Integer.valueOf(words[1]);
        }
        catch (NumberFormatException e) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)(chanName + " hwChannel (" + words[1] + ")"), (String)"is not an integer");
        }
        Integer range = (Integer)modData.modDef.rangeMap.get(words[2]);
        if (range == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)(chanName + " range (" + words[2] + ")"), (String)"is not a valid range");
        }
        try {
            fullScale = Double.valueOf(words[3]);
        }
        catch (NumberFormatException e) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)(chanName + " fullScale (" + words[3] + ")"), (String)"is not a floating-point number");
        }
        return new ChannelDesc(modData, hwChannel, range, (isOut ? outScaleMap : inScaleMap).get(range) / fullScale);
    }

    static {
        inScaleMap.put(0, 60.0);
        inScaleMap.put(1, 40.0);
        inScaleMap.put(2, 20.0);
        inScaleMap.put(3, 10.0);
        inScaleMap.put(4, 5.0);
        outScaleMap = new HashMap<Integer, Double>();
        outScaleMap.put(0, 10.0);
        outScaleMap.put(1, 5.0);
        outScaleMap.put(2, 2.0);
        outScaleMap.put(3, 10.0);
        outScaleMap.put(4, 5.0);
        outScaleMap.put(5, 2.0);
        LOG = Logger.getLogger(PcpPowerControl.class.getName());
    }

    protected static class ChannelDesc {
        Maq20Device.ModuleData moduleData;
        int hwChannel;
        int range;
        double scale;

        private ChannelDesc(Maq20Device.ModuleData moduleData, int hwChannel, int range, double scale) {
            this.moduleData = moduleData;
            this.hwChannel = hwChannel;
            this.range = range;
            this.scale = scale;
        }
    }
}

