/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20DiscControl;

public class ChillerMaq20Device
extends Maq20Device {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Maq20DiscControl discCtrl;
    private static final Logger LOG = Logger.getLogger(ChillerMaq20Device.class.getName());

    protected void initDevice() {
        super.initDevice();
        if (this.discCtrl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"MAQ20 discrete control", (String)"not defined");
        }
    }

    public void setLightOn(LightNumber light, boolean on) throws DriverException {
        this.discCtrl.setLineOn(light.getChannel(), on);
    }

    public Boolean isLightOn(LightNumber light) {
        return this.discCtrl.isLineOn(light.getChannel());
    }

    public static enum LightNumber {
        LIGHT1(0, "DIOL channel for light 1"),
        LIGHT2(1, "DIOL channel for light 2");

        private int channel;
        private String descr;

        private LightNumber(int channel, String descr) {
            this.channel = channel;
            this.descr = descr;
        }

        public int getChannel() {
            return this.channel;
        }

        public String getDescr() {
            return this.descr;
        }
    }
}

