/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.vacuum.Mks9xxDevice;
import org.lsst.ccs.subsystem.vacuum.SwitchDevice;

public class VacMksDevice
extends Mks9xxDevice
implements SwitchDevice {
    private int deviceId = -1;
    private volatile long ccAutoPowerTimeStamp = 0L;
    private volatile Boolean ccAutoPowerState = null;
    private volatile long ccAutoPowerMaxAge = 100000L;

    @Override
    public int getSwitchDevice() {
        return this.deviceId;
    }

    @Override
    public void setSwitch(int sw, boolean on) throws DriverException {
        if (on) {
            this.setLock(false);
            this.setCCAutoPower(true);
            this.setLock(true);
        } else {
            this.setLock(false);
            this.setCCAutoPower(false);
            this.setLock(true);
        }
        this.ccAutoPowerState = this.isCCAutoPowerOn();
        this.ccAutoPowerTimeStamp = System.currentTimeMillis();
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        if (System.currentTimeMillis() - this.ccAutoPowerTimeStamp > this.ccAutoPowerMaxAge) {
            try {
                this.ccAutoPowerState = this.isCCAutoPowerOn();
                this.ccAutoPowerTimeStamp = System.currentTimeMillis();
            }
            catch (DriverException e) {
                return null;
            }
        }
        return this.ccAutoPowerState;
    }
}

