/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.framework.HasLifecycle;

public class CompLimits
implements HasLifecycle {
    protected static final String COMP_LIMITS = "CompLimits";
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="psia", description="Discharge pressure limit causing immediate compressor shutoff")
    private volatile double discPressImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="psia", description="Discharge pressure limit causing delayed compressor shutoff")
    private volatile double discPressDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="Celsius", description="Discharge temperature limit causing immediate compressor shutoff")
    private volatile double discTempImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="Celsius", description="Discharge temperature limit causing delayed compressor shutoff")
    private volatile double discTempDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="second", description="Time delay before excess discharge temperature causes compressor shutoff")
    private volatile int discTempDelayTime;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="Celsius", description="Suction temperature limit causing immediate compressor shutoff")
    private volatile double suctTempImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="Watt", description="Compressor power limit causing immediate compressor shutoff")
    private volatile double cmprPowerImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="Watt", description="Compressor power limit causing delayed compressor shutoff")
    private volatile double cmprPowerDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true, units="second", description="Time delay before excess compressor power causes compressor shutoff")
    private volatile int cmprPowerDelayTime;
    protected final LimitData[] limitData = new LimitData[17];

    public CompLimits() {
        for (int j = 0; j < 17; ++j) {
            this.limitData[j] = new LimitData();
        }
    }

    public void postInit() {
        this.limitData[2].isLower = true;
        this.limitData[2].delayLimit = Double.NaN;
    }

    @ConfigurationParameterChanger
    public void setDiscPressImmedLimit(double value) {
        this.discPressImmedLimit = value;
        this.limitData[0].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setDiscPressDelayLimit(double value) {
        this.discPressDelayLimit = value;
        this.limitData[0].delayLimit = value;
    }

    @ConfigurationParameterChanger
    public void setDiscTempImmedLimit(double value) {
        this.discTempImmedLimit = value;
        this.limitData[1].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setDiscTempDelayLimit(double value) {
        this.discTempDelayLimit = value;
        this.limitData[1].delayLimit = value;
    }

    @ConfigurationParameterChanger
    public void setDiscTempDelayTime(int value) {
        this.discTempDelayTime = value;
        this.limitData[1].delayTime = 1000 * value;
    }

    @ConfigurationParameterChanger
    public void setSuctTempImmedLimit(double value) {
        this.suctTempImmedLimit = value;
        this.limitData[2].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setCmprPowerImmedLimit(double value) {
        this.cmprPowerImmedLimit = value;
        this.limitData[3].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setCmprPowerDelayLimit(double value) {
        this.cmprPowerDelayLimit = value;
        this.limitData[3].delayLimit = value;
    }

    @ConfigurationParameterChanger
    public void setCmprPowerDelayTime(int value) {
        this.cmprPowerDelayTime = value;
        this.limitData[3].delayTime = 1000 * value;
    }

    public LimitData[] getLimitData() {
        return this.limitData;
    }

    public static class LimitData {
        protected boolean isLower = false;
        protected double immedLimit = 0.0;
        protected double delayLimit = 0.0;
        protected int delayTime = 0;
    }
}

