/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.indilib.i4j.INDIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassInstantiator {
    private static final Logger LOG = LoggerFactory.getLogger(ClassInstantiator.class);

    private ClassInstantiator() {
    }

    public static Object instantiate(String[] possibleClassNames, Object[] arguments) throws INDIException {
        for (String className : possibleClassNames) {
            try {
                Class<?> theClass = Class.forName(className);
                Constructor[] constructors = theClass.getConstructors();
                Constructor constructor = ClassInstantiator.getSuitableConstructor(constructors, arguments);
                Object obj = constructor.newInstance(arguments);
                return obj;
            }
            catch (ClassNotFoundException ex) {
                LOG.error("Could not instantiate", (Throwable)ex);
            }
            catch (InstantiationException ex) {
                LOG.error("Could not instantiate", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                LOG.error("Could not instantiate", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                LOG.error("Could not instantiate", (Throwable)ex);
            }
        }
        throw new INDIException("No suitable class to instantiate. Probably some libraries are missing in the classpath.");
    }

    private static Constructor getSuitableConstructor(Constructor[] constructors, Object[] arguments) throws INDIException {
        for (Constructor c : constructors) {
            Class<?>[] cClassParam = c.getParameterTypes();
            boolean match = true;
            if (cClassParam.length != arguments.length) {
                match = false;
            }
            for (int h = 0; h < arguments.length; ++h) {
                if (cClassParam[h].isInstance(arguments[h])) continue;
                match = false;
            }
            if (!match) continue;
            return c;
        }
        throw new INDIException("No suitable class to instantiate. Probably some libraries are missing in the classpath.");
    }
}

