/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.File;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.imagehandling.CommandExecutor;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.imagedb.ImageDatabaseService;
import org.lsst.ccs.subsystem.imagehandling.imagedb.ImageFileDatabase;

public class Resender {
    private static final Logger LOG = Logger.getLogger(Resender.class.getName());

    public static void main(String[] args) throws SQLException, ExecutionException, InterruptedException {
        for (String arg : args) {
            System.out.println(arg);
        }
        String dbURL = args[0];
        String dayobs = args[1];
        String command = args[2];
        int limit = args.length > 3 ? Integer.parseInt(args[3]) : 1;
        int threads = args.length > 4 ? Integer.parseInt(args[4]) : 1;
        ImageDatabaseService imageDatabaseService = ImageDatabaseService.testInstance(dbURL);
        ImageFileDatabase ifd = new ImageFileDatabase(imageDatabaseService);
        ifd.openConnection();
        ConcurrentLinkedQueue<ImageFileDatabase.MissingFile> missingFiles = new ConcurrentLinkedQueue<ImageFileDatabase.MissingFile>(ifd.missingFailedUSDFFileNames(dayobs, limit));
        LOG.log(Level.INFO, "Found {0} files to resend for {1}", new Object[]{missingFiles.size(), dayobs});
        ImageHandlingConfig config = new ImageHandlingConfig();
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("USDF_BUCKET", "rubin-summit");
        env.put("INSTRUMENT", "LSSTCam");
        env.put("USDF_MC_HOST", "usdf");
        env.put("USDF_USE_S3DAEMON", "true");
        CommandExecutor commandExecutor = new CommandExecutor(config, null, ifd);
        Runnable task = () -> {
            try {
                ImageFileDatabase.MissingFile missingFile;
                while ((missingFile = (ImageFileDatabase.MissingFile)missingFiles.poll()) != null) {
                    LOG.log(Level.INFO, "Resending {0}", missingFile.file());
                    List<String> commands = Collections.singletonList(command);
                    File file = new File(missingFile.file());
                    String fileType = missingFile.fileType();
                    LinkedHashMap<String, String> newEnv = new LinkedHashMap<String, String>(env);
                    newEnv.put("FILETYPE", fileType);
                    newEnv.put("FILE", file.getAbsolutePath());
                    newEnv.put("DATE", missingFile.dayobs());
                    if ("FITS".equals(missingFile.fileType())) {
                        newEnv.put("FITSFILE", file.getAbsolutePath());
                    }
                    CompletableFuture<File> futureFile = commandExecutor.executeMissingFile(commands, file, missingFile.fileId(), newEnv);
                    File logFile = futureFile.get();
                    LOG.log(Level.INFO, "Log {0}", logFile);
                }
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Error handling missing files", t);
            }
        };
        ExecutorService threadPool = Executors.newFixedThreadPool(threads);
        for (int i = 0; i < threads; ++i) {
            threadPool.submit(task);
        }
        threadPool.shutdown();
        threadPool.awaitTermination(1L, TimeUnit.DAYS);
    }
}

