/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.messaging.LockLevelService;
import org.lsst.ccs.services.AgentLockServiceDelegate;
import org.lsst.ccs.services.AgentLoginService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.LocalAgentLockService;
import org.lsst.ccs.services.RemoteAgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;

public class AgentLockService
implements LockLevelService,
ServiceLifecycle,
AgentService {
    public static final String LOCK_MANAGER_SUBSYSTEM_NAME = "lockmanager";
    AgentLockServiceDelegate delegate;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentLoginService agentLoginService;

    Agent getAgent() {
        return this.agent;
    }

    public AgentStateService getAgentStateService() {
        return this.agentStateService;
    }

    public AgentLoginService getAgentLoginService() {
        return this.agentLoginService;
    }

    @Override
    public String getAgentServiceName() {
        return "lockService";
    }

    @Override
    public void preInit() {
        String p;
        switch (p = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.lockservice", "local")) {
            case "remote": {
                this.delegate = new RemoteAgentLockService(this);
                break;
            }
            case "local": {
                this.delegate = new LocalAgentLockService(this);
                break;
            }
            default: {
                throw new RuntimeException("Invalid org.lsst.ccs.lockservice value " + p);
            }
        }
        this.delegate.preInit();
    }

    @Override
    public void preStart() {
        this.delegate.preStart();
    }

    public void setLevelForAgent(String agentName, int level) throws UnauthorizedLevelException, UnauthorizedLockException {
        this.delegate.setLevelForAgent(agentName, level);
    }

    public int getLevelForAgent(String agentName) {
        return this.delegate.getLevelForAgent(agentName);
    }

    public AgentLock getLockForAgent(String agentName) {
        return this.delegate.getLockForAgent(agentName);
    }

    public AgentLock getExistingLockForAgent(String agentName) {
        return this.delegate.getExistingLockForAgent(agentName);
    }

    public void lockAgent(String agentName) throws UnauthorizedLockException {
        this.delegate.lockAgent(agentName);
    }

    public void unlockAgent(String agentName) throws UnauthorizedLockException {
        this.delegate.unlockAgent(agentName);
    }

    public void attachLock(String agentName) throws UnauthorizedLockException {
        this.delegate.attachLock(agentName);
    }

    public void detachLock(String agentName) throws UnauthorizedLockException {
        this.delegate.detachLock(agentName);
    }

    public Map<String, AgentLock> getLocks() {
        return this.delegate.getLocks();
    }

    public Map<String, AgentLock> getHeldLocks() {
        return this.delegate.getHeldLocks();
    }

    public String validateLock(DictionaryCommand command, CommandRequest request) {
        return this.delegate.validateLock(command, request);
    }

    public String getUserId() {
        return this.agentLoginService.getUserId();
    }

    public void addAgentLockUpdateListener(AgentLockUpdateListener slul) {
        this.delegate.addAgentLockUpdateListener(slul);
    }

    public void removeAgentLockUpdateListener(AgentLockUpdateListener l) {
        this.delegate.removeAgentLockUpdateListener(l);
    }

    public List<String> getLockableAgents() {
        return this.delegate.getLockableAgents();
    }

    public List<String> getAttachableAgents() {
        return this.delegate.getAttachableAgents();
    }

    public List<String> getDetachableAgents() {
        return this.delegate.getDetachableAgents();
    }

    public List<String> getLockedAgents() {
        return this.delegate.getLockedAgents();
    }

    public List<String> getAllLockedAgents() {
        return this.delegate.getAllLockedAgents();
    }

    public List<String> getLocallyLockedAgents() {
        return this.delegate.getLocallyLockedAgents();
    }

    public List<String> getAllWorkerAgents() {
        return this.delegate.getAllWorkerAgents();
    }

    public void destroyLock(String agentName, String userId) {
        this.delegate.destroyLock(agentName, userId);
    }

    public int getMaxLevel(String user, String agentName) {
        return this.delegate.getMaxLevel(user, agentName);
    }

    public static Map<String, Integer> getMaxLevelsUser(String user, Map<String, Map<String, String>> config) {
        config = AgentLockService.trimMaxLevelsConfig(config);
        return AgentLockService.getMaxLevels(user, config, new HashSet<String>(8));
    }

    public static Map<String, Integer> getMaxLevelsSubsystem(String agentName, Map<String, Map<String, String>> config) {
        config = AgentLockService.trimMaxLevelsConfig(config);
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        for (String user : config.keySet()) {
            Map<String, Integer> v = AgentLockService.getMaxLevels(user, config, new HashSet<String>(8));
            int level = AgentLockService.getMaxLevel(agentName, v);
            if (level <= 0) continue;
            out.put(user, level);
        }
        return out;
    }

    public static int getMaxLevel(String agentName, Map<String, Integer> maxLevelsUser) {
        Integer out = maxLevelsUser.get(agentName);
        if (out == null) {
            for (Map.Entry<String, Integer> e : maxLevelsUser.entrySet()) {
                if (!e.getKey().contains("*") || !agentName.matches(e.getKey().replace("*", ".*")) || out != null && out.compareTo(e.getValue()) >= 0) continue;
                out = e.getValue();
            }
        }
        return out == null ? 0 : out;
    }

    public static Map<String, Map<String, String>> trimMaxLevelsConfig(Map<String, Map<String, String>> config) {
        TreeMap<String, Map<String, String>> out = new TreeMap<String, Map<String, String>>();
        config.forEach((user, map) -> {
            String newUser = user.trim();
            TreeMap newMap = new TreeMap();
            map.forEach((key, value) -> newMap.put(key.trim(), value.trim()));
            out.put(newUser, newMap);
        });
        return out;
    }

    private static Map<String, Integer> getMaxLevels(String user, Map<String, Map<String, String>> config, HashSet<String> groups) {
        Map<String, String> v = config.get(user);
        if (v == null) {
            return Collections.emptyMap();
        }
        groups.add(user);
        TreeMap<String, Integer> out = new TreeMap<String, Integer>();
        v.forEach((key, value) -> {
            if (value.isEmpty()) {
                if (!groups.contains(key)) {
                    Map<String, Integer> extra = AgentLockService.getMaxLevels(key, config, groups);
                    HashMap accept = new HashMap(extra.size() * 2);
                    extra.forEach((k, level) -> {
                        Integer prevLevel = (Integer)out.get(k);
                        if (prevLevel == null) {
                            if (k.contains("*")) {
                                accept.put(k, level);
                            } else {
                                boolean hasMatchingTemplate = false;
                                for (Map.Entry e : out.entrySet()) {
                                    String template = (String)e.getKey();
                                    if (!template.contains("*") || !k.matches(template.replace("*", ".*"))) continue;
                                    hasMatchingTemplate = true;
                                    break;
                                }
                                if (!hasMatchingTemplate) {
                                    accept.put(k, level);
                                }
                            }
                        } else if (k.contains("*") && prevLevel.compareTo((Integer)level) < 0) {
                            accept.put(k, level);
                        }
                    });
                    out.putAll(accept);
                }
            } else {
                try {
                    int level2 = Command.Level.parse((String)value, (int)-1);
                    if (level2 >= 0 && level2 <= 99) {
                        out.put((String)key, level2);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        return out;
    }

    public static interface AgentLockUpdateListener {
        default public void onAgentHeldLockUpdate(String agentName, AgentLock lock) {
        }

        default public void onAgentLockUpdate(String agentName, String owner, AgentLock lock) {
        }

        default public void onGlobalLockUpdate(String agentName, String owner, AgentLock lock) {
        }

        default public void onAgentLevelChange(String agentName, int level) {
        }
    }
}

