/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.location;

public enum Camera {
    LSSTCAM,
    AUXTEL,
    COMCAM,
    TS8;


    @Deprecated
    public static Camera forDaqPartition(String partition) {
        switch (partition) {
            case "lsstcam": 
            case "camera": 
            case "guider": 
            case "bts": {
                return LSSTCAM;
            }
            case "comcam": {
                return COMCAM;
            }
            case "lat": {
                return AUXTEL;
            }
            case "ts8": {
                return TS8;
            }
        }
        throw new RuntimeException("Unrecognized DAQ partition: " + partition);
    }

    public static Camera forDAQPartitionAndPlatform(String partition, String platform) {
        switch (partition) {
            case "lsstcam": 
            case "camera": 
            case "guider": 
            case "bts": {
                return LSSTCAM;
            }
            case "comcam": {
                return COMCAM;
            }
            case "lat": {
                return AUXTEL;
            }
            case "ts8": {
                return TS8;
            }
            case "emu": {
                switch (platform) {
                    case "comcam": {
                        return COMCAM;
                    }
                    case "auxtel": {
                        return AUXTEL;
                    }
                }
                throw new RuntimeException("Unrecognized DAQ platform: " + platform);
            }
        }
        throw new RuntimeException("Unrecognized DAQ partition: " + partition);
    }
}

