/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.refrig.ChillerSubsystem;
import org.lsst.ccs.subsystem.refrig.constants.ChillerAlerts;
import org.lsst.ccs.subsystem.refrig.constants.ChillerState;

public class ChillerBlockingListener
implements AlertListener,
HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private ChillerSubsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupName
    private String name;
    private static final Logger LOG = Logger.getLogger(ChillerSubsystem.class.getName());
    private List<Alert> alerts = new ArrayList<Alert>();

    public void init() {
        for (ChillerAlerts ca : this.subsys.blockingAlerts) {
            this.alerts.add(ca.newAlert());
        }
        LOG.log(Level.INFO, this.name + " listening to Alerts from " + this.subsys.getName());
    }

    public void start() {
        this.alertService.addListener((AlertListener)this);
    }

    public void shutdown() {
        this.alertService.removeListener((AlertListener)this);
    }

    public void onAlert(AlertEvent event) {
        if (event.getType() == AlertEvent.AlertEventType.ALERT_RAISED && this.alerts.contains(event.getAlert()) && event.getLevel() == AlertState.ALARM) {
            LOG.fine(this.name + " received " + event.getAlert().toString());
            ChillerState cs = (ChillerState)this.stateService.getState(ChillerState.class);
            if (cs == ChillerState.SETPOINT || cs == ChillerState.CONTROLLING) {
                LOG.info("Quitting control due to " + event.getAlert().toString());
                try {
                    this.subsys.quitControllingTemperature();
                }
                catch (Exception e) {
                    LOG.severe("Exception while trying to quit: " + e);
                }
            }
        }
    }
}

