/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.Arrays;
import java.util.HashSet;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexLookupBatch;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class BaseIndex
extends SchemaObjectBase
implements Index {
    protected IndexColumn[] indexColumns;
    protected Column[] columns;
    protected int[] columnIds;
    protected Table table;
    protected IndexType indexType;
    protected boolean isMultiVersion;

    protected void initBaseIndex(Table table, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initSchemaObjectBase(table.getSchema(), n, string, 5);
        this.indexType = indexType;
        this.table = table;
        if (indexColumnArray != null) {
            this.indexColumns = indexColumnArray;
            this.columns = new Column[indexColumnArray.length];
            int n2 = this.columns.length;
            this.columnIds = new int[n2];
            for (int i = 0; i < n2; ++i) {
                Column column;
                this.columns[i] = column = indexColumnArray[i].column;
                this.columnIds[i] = column.getColumnId();
            }
        }
    }

    protected static void checkIndexColumnTypes(IndexColumn[] indexColumnArray) {
        for (IndexColumn indexColumn : indexColumnArray) {
            int n = indexColumn.column.getType();
            if (n != 16 && n != 15) continue;
            throw DbException.getUnsupportedException("Index on BLOB or CLOB column: " + indexColumn.column.getCreateSQL());
        }
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    protected DbException getDuplicateKeyException(String string) {
        String string2 = this.getName() + " ON " + this.table.getSQL() + "(" + this.getColumnListSQL() + ")";
        if (string != null) {
            string2 = string2 + " VALUES " + string;
        }
        DbException dbException = DbException.get(23505, string2);
        dbException.setSource(this);
        return dbException;
    }

    @Override
    public String getPlanSQL() {
        return this.getSQL();
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeIndex(this);
        this.remove(session);
        this.database.removeMeta(session, this.getId());
    }

    @Override
    public boolean canFindNext() {
        return false;
    }

    @Override
    public Cursor find(TableFilter tableFilter, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(tableFilter.getSession(), searchRow, searchRow2);
    }

    @Override
    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        throw DbException.throwInternalError();
    }

    protected final long getCostRangeIndex(int[] nArray, long l, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, boolean bl) {
        int n2;
        int n3;
        int n4 = 0;
        long l2 = l += 1000L;
        if (nArray != null) {
            int n5 = this.columns.length;
            for (int i = 0; i < n5; ++i) {
                long l3;
                Column column = this.columns[i];
                n3 = column.getColumnId();
                n2 = nArray[n3];
                if ((n2 & 1) == 1) {
                    if (i == this.columns.length - 1 && this.getIndexType().isUnique()) {
                        l2 = 3L;
                        break;
                    }
                    l3 = l * (long)(n4 = 100 - (100 - n4) * (100 - column.getSelectivity()) / 100) / 100L;
                    if (l3 <= 0L) {
                        l3 = 1L;
                    }
                } else {
                    if ((n2 & 6) == 6) {
                        l2 = 2L + l / 4L;
                        break;
                    }
                    if ((n2 & 2) == 2) {
                        l2 = 2L + l / 3L;
                        break;
                    }
                    if ((n2 & 4) != 4) break;
                    l2 = l / 3L;
                    break;
                }
                l2 = 2L + Math.max(l / l3, 1L);
            }
        }
        long l4 = 0L;
        if (sortOrder != null) {
            l4 = 100L + l / 10L;
        }
        if (sortOrder != null && !bl) {
            boolean bl2 = true;
            n3 = 0;
            int[] nArray2 = sortOrder.getSortTypes();
            TableFilter tableFilter = tableFilterArray == null ? null : tableFilterArray[n];
            int n6 = nArray2.length;
            for (int i = 0; i < n6 && i < this.indexColumns.length; ++i) {
                Column column = sortOrder.getColumn(i, tableFilter);
                if (column == null) {
                    bl2 = false;
                    break;
                }
                IndexColumn indexColumn = this.indexColumns[i];
                if (!column.equals(indexColumn.column)) {
                    bl2 = false;
                    break;
                }
                int n7 = nArray2[i];
                if (n7 != indexColumn.sortType) {
                    bl2 = false;
                    break;
                }
                ++n3;
            }
            if (bl2) {
                l4 = 100 - n3;
            }
        }
        boolean bl3 = true;
        if (!bl) {
            HashSet<Column> hashSet = New.hashSet();
            for (n2 = 0; n2 < tableFilterArray.length; ++n2) {
                if (tableFilterArray[n2].getSelect() == null) continue;
                tableFilterArray[n2].getSelect().isEverything(ExpressionVisitor.getColumnsVisitor(hashSet));
            }
            if (!hashSet.isEmpty()) {
                HashSet hashSet2 = New.hashSet();
                for (Column column : hashSet) {
                    if (column.getTable() != this.getTable()) continue;
                    hashSet2.add(column);
                }
                hashSet2.removeAll(Arrays.asList(this.columns));
                if (hashSet2.isEmpty()) {
                    bl3 = false;
                }
            }
        }
        long l5 = bl ? l2 + l4 + 20L : (bl3 ? l2 + l2 + l4 + 20L : l2 + l4 + (long)(20 - this.columns.length));
        return l5;
    }

    @Override
    public int compareRows(SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == searchRow2) {
            return 0;
        }
        int n = this.indexColumns.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.columnIds[i];
            Value value = searchRow.getValue(n2);
            Value value2 = searchRow2.getValue(n2);
            if (value == null || value2 == null) {
                return 0;
            }
            int n3 = this.compareValues(value, value2, this.indexColumns[i].sortType);
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    protected boolean containsNullAndAllowMultipleNull(SearchRow searchRow) {
        Mode mode = this.database.getMode();
        if (mode.uniqueIndexSingleNull) {
            return false;
        }
        if (mode.uniqueIndexSingleNullExceptAllColumnsAreNull) {
            for (int n : this.columnIds) {
                Value value = searchRow.getValue(n);
                if (value == ValueNull.INSTANCE) continue;
                return false;
            }
            return true;
        }
        for (int n : this.columnIds) {
            Value value = searchRow.getValue(n);
            if (value != ValueNull.INSTANCE) continue;
            return true;
        }
        return false;
    }

    int compareKeys(SearchRow searchRow, SearchRow searchRow2) {
        long l;
        long l2 = searchRow.getKey();
        if (l2 == (l = searchRow2.getKey())) {
            if (this.isMultiVersion) {
                int n = searchRow.getVersion();
                int n2 = searchRow2.getVersion();
                return MathUtils.compareInt(n2, n);
            }
            return 0;
        }
        return l2 > l ? 1 : -1;
    }

    private int compareValues(Value value, Value value2, int n) {
        if (value == value2) {
            return 0;
        }
        int n2 = this.table.compareTypeSafe(value, value2);
        if ((n & 1) != 0) {
            n2 = -n2;
        }
        return n2;
    }

    @Override
    public int getColumnIndex(Column column) {
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            if (!this.columns[i].equals(column)) continue;
            return i;
        }
        return -1;
    }

    private String getColumnListSQL() {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (IndexColumn indexColumn : this.indexColumns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(indexColumn.getSQL());
        }
        return statementBuilder.toString();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        StringBuilder stringBuilder = new StringBuilder("CREATE ");
        stringBuilder.append(this.indexType.getSQL());
        stringBuilder.append(' ');
        if (this.table.isHidden()) {
            stringBuilder.append("IF NOT EXISTS ");
        }
        stringBuilder.append(string);
        stringBuilder.append(" ON ").append(table.getSQL());
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuilder.append('(').append(this.getColumnListSQL()).append(')');
        return stringBuilder.toString();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    @Override
    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public void commit(int n, Row row) {
    }

    void setMultiVersion(boolean bl) {
        this.isMultiVersion = bl;
    }

    @Override
    public Row getRow(Session session, long l) {
        throw DbException.getUnsupportedException(this.toString());
    }

    @Override
    public boolean isHidden() {
        return this.table.isHidden();
    }

    @Override
    public boolean isRowIdIndex() {
        return false;
    }

    @Override
    public boolean canScan() {
        return true;
    }

    @Override
    public void setSortedInsertMode(boolean bl) {
    }

    @Override
    public IndexLookupBatch createLookupBatch(TableFilter tableFilter) {
        return null;
    }
}

