/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.lockmanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.bus.messages.StatusLock;
import org.lsst.ccs.bus.messages.StatusLockAggregate;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.utilities.logging.Logger;

public class LockManager
extends Subsystem
implements HasLifecycle {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.lockmanager");
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    AgentLockService agentLockService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    private AgentMessagingLayer aml;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PersistencyService localPersistenceService;
    @Persist
    volatile ConcurrentHashMap<String, AgentLockInfo.AgentLockInfoString> locksByAgentName = new ConcurrentHashMap();
    @ConfigurationParameter(description="Map of max levels", maxLength=50, units="unitless")
    private volatile Map<String, Map<String, String>> maxLevelMap = new ConcurrentHashMap<String, Map<String, String>>();
    ConcurrentHashMap<String, AgentLockInfo.AgentLockInfoString> locksByToken = new ConcurrentHashMap();
    ConcurrentHashMap<String, CountDownLatch> latches = new ConcurrentHashMap();
    Set<String> lockUnawareWorkers = new HashSet<String>();
    private final ThreadLocal<Boolean> executingLockOrAttach = new ThreadLocal();
    StatusMessageListener sml = new StatusMessageListener(){

        public void onStatusMessage(StatusMessage msg) {
            Serializable o = msg.getObject();
            if (!(o instanceof AgentLockInfo)) {
                return;
            }
            AgentLockInfo lock = (AgentLockInfo)o;
            String source = msg.getOriginAgentInfo().getName();
            if ("lockmanager".equals(source)) {
                return;
            }
            log.info((Object)("LM got message from " + source + " : " + lock));
            CountDownLatch latch = LockManager.this.latches.get(lock.getAgentName());
            if (latch == null) {
                return;
            }
            if (lock.getStatus() != AgentLockInfo.Status.ACKNOWLEDGED && lock.getStatus() != AgentLockInfo.Status.REJECTED) {
                return;
            }
            if (lock.getStatus() == AgentLockInfo.Status.REJECTED) {
                log.warning((Object)("Rejected lock " + lock));
                LockManager.this.latches.remove(lock.getAgentName());
                LockManager.this.removeLock(lock);
                latch.countDown();
                return;
            }
            if (!LockManager.this.locksByAgentName.containsKey(lock.getAgentName()) && LockManager.this.locksByAgentName.get(lock.getAgentName()).getLockInfo().getStatus() != AgentLockInfo.Status.REQUESTED) {
                log.error((Object)("Inconsistent state, received " + lock + " with latch " + latch + " and request " + LockManager.this.locksByAgentName.get(lock.getAgentName())));
                LockManager.this.latches.remove(lock.getAgentName());
                LockManager.this.removeLock(lock);
                latch.countDown();
                return;
            }
            log.info((Object)("received acknowledged lock " + lock));
            LockManager.this.addLock(lock);
            LockManager.this.localPersistenceService.persistNow();
            latch.countDown();
        }
    };
    AgentPresenceListener apl = new AgentPresenceListener(){

        public void connected(AgentInfo ... agents) {
            HashSet<String> sent = new HashSet<String>();
            boolean lockerHasConnected = false;
            for (AgentInfo ai : agents) {
                String lockableInfo;
                AgentLockInfo.AgentLockInfoString lis;
                AgentLockInfo lockInfo;
                AgentInfo.AgentType tp = ai.getType();
                if (!(lockerHasConnected || tp != AgentInfo.AgentType.CONSOLE && tp != AgentInfo.AgentType.MCM && tp != AgentInfo.AgentType.OCS_BRIDGE)) {
                    lockerHasConnected = true;
                }
                AgentLockInfo agentLockInfo = lockInfo = (lis = LockManager.this.locksByAgentName.get(ai.getName())) == null ? null : lis.getLockInfo();
                if (lockInfo != null) {
                    log.info((Object)("refreshing lock, agent just connected " + lockInfo.getAgentName() + " by " + lockInfo.getOwner()));
                    AgentLockInfo refresh = AgentLockInfo.createReminder((AgentLockInfo)lockInfo);
                    StatusLock msg = new StatusLock(refresh);
                    LockManager.this.sendStatusMessage((StatusMessage)msg);
                    sent.add(lockInfo.getToken());
                }
                if ("true".equals(lockableInfo = ai.getAgentProperty("lockable"))) continue;
                LockManager.this.lockUnawareWorkers.add(ai.getName());
            }
            if (lockerHasConnected) {
                ArrayList<AgentLockInfo> ll = new ArrayList<AgentLockInfo>();
                for (AgentLockInfo.AgentLockInfoString lis : LockManager.this.locksByAgentName.values()) {
                    AgentLockInfo lock = lis.getLockInfo();
                    if (sent.contains(lock.getToken())) continue;
                    AgentLockInfo refresh = AgentLockInfo.createInfo((AgentLockInfo)lock);
                    ll.add(refresh);
                }
                AgentLockInfo[] larr = ll.toArray(new AgentLockInfo[0]);
                StatusLockAggregate msg = new StatusLockAggregate(larr);
                LockManager.this.sendStatusMessage((StatusMessage)msg);
            }
        }

        public void disconnected(AgentInfo ... agents) {
            for (AgentInfo ai : agents) {
                AgentLockInfo lockInfo;
                LockManager.this.lockUnawareWorkers.remove(ai.getName());
                if (ai.getType() != AgentInfo.AgentType.CONSOLE || (lockInfo = LockManager.this.getLockInfo(ai.getName())) == null) continue;
                LockManager.this.locksByAgentName.remove(lockInfo.getAgentName());
                lockInfo = AgentLockInfo.createRelease((String)lockInfo.getAgentName(), (String)lockInfo.getOwner());
                StatusLock msg = new StatusLock(lockInfo);
                msg.setState(LockManager.this.agentStateService.getState());
                LockManager.this.aml.sendStatusMessage((StatusMessage)msg);
            }
        }
    };

    public LockManager(String name) {
        super(name, AgentInfo.AgentType.LOCK_MANAGER);
    }

    public LockManager() {
        super("lockmanager", AgentInfo.AgentType.LOCK_MANAGER);
    }

    protected void addLock(AgentLockInfo lock) {
        AgentLockInfo.AgentLockInfoString lis = new AgentLockInfo.AgentLockInfoString(lock);
        this.locksByAgentName.put(lock.getAgentName(), lis);
        this.locksByToken.put(lock.getToken(), lis);
    }

    protected void removeLock(AgentLockInfo lock) {
        if (lock != null && lock.getToken() == null) {
            lock = this.locksByAgentName.get(lock.getAgentName()).getLockInfo();
        }
        if (lock != null) {
            this.locksByAgentName.remove(lock.getAgentName());
            this.locksByToken.remove(lock.getToken());
        }
    }

    public void init() {
        boolean loadAtStartup = true;
        boolean persistAtShutdown = true;
        this.localPersistenceService.setAutomatic(loadAtStartup, persistAtShutdown);
    }

    public void postInit() {
    }

    public void postStart() {
        this.aml = this.agent.getMessagingAccess();
        this.aml.addStatusMessageListener(this.sml, BusMessageFilterFactory.embeddedObjectClass(AgentLockInfo.class));
        this.aml.getAgentPresenceManager().addAgentPresenceListener(this.apl);
        for (AgentLockInfo.AgentLockInfoString lis : this.locksByAgentName.values()) {
            String token;
            boolean deadConsole;
            AgentLockInfo lock = lis.getLockInfo();
            String agentName = lock.getAgentName();
            boolean bl = deadConsole = agentName.startsWith("ccs-shell_") || agentName.startsWith("CCS-Graphical-Console_");
            if (deadConsole) {
                boolean bl2 = deadConsole = !this.aml.getAgentPresenceManager().agentExists(agentName);
            }
            if ((token = lock.getToken()) == null || deadConsole) {
                this.locksByAgentName.remove(agentName);
                continue;
            }
            this.locksByToken.put(token, lis);
        }
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="destroys a lock", level=0, autoAck=false)
    public void destroyLock(@Argument(name="agentName", description="agent name") String agentName, String userId) {
        AgentLockInfo lockInfo = this.getLockInfo(agentName);
        if (lockInfo == null) {
            this.sendNack((Serializable)((Object)"The subsystem is not locked."));
            return;
        }
        if (this.agentLockService.getMaxLevel(userId, lockInfo.getAgentName()) < 50) {
            this.sendNack((Serializable)((Object)("User " + userId + " is not authorized to destroy locks.")));
            return;
        }
        this.sendAck(null);
        this.locksByAgentName.remove(lockInfo.getAgentName());
        lockInfo = AgentLockInfo.createRelease((String)lockInfo.getAgentName(), (String)lockInfo.getOwner());
        StatusLock msg = new StatusLock(lockInfo);
        msg.setState(this.agentStateService.getState());
        this.aml.sendStatusMessage((StatusMessage)msg);
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="lock a subsystem", level=0, autoAck=false)
    public AgentLockInfo lockAgent(@Argument(name="lock", description="Lock request") AgentLockInfo lock) {
        log.info((Object)("got lock command for " + lock.getAgentName() + " from " + lock.getOwner()));
        if (lock.getOwner() == null) {
            this.sendNack((Serializable)((Object)"Cannot lock with null user."));
            return null;
        }
        if (lock.getStatus() != AgentLockInfo.Status.REQUESTED) {
            this.sendNack((Serializable)((Object)("Lock request with bad status " + lock.getStatus())));
            return null;
        }
        AgentLockInfo lockInfo = this.getLockInfo(lock.getAgentName());
        if (lockInfo != null) {
            if (!lock.getOwner().equals(lockInfo.getOwner())) {
                this.sendNack((Serializable)((Object)("Lock is owned by another user: " + lockInfo.getOwner())));
                return null;
            }
            if (this.executingLockOrAttach.get() == null) {
                this.sendNack((Serializable)((Object)("You already own the lock, please use \"attachLock " + lockInfo.getAgentName() + "\"")));
                return null;
            }
            throw new IllegalStateException();
        }
        this.sendAck(null);
        AgentLockInfo.AgentLockInfoString old = this.locksByAgentName.putIfAbsent(lock.getAgentName(), new AgentLockInfo.AgentLockInfoString(lock));
        if (old != null) {
            return null;
        }
        AgentLockInfo updatedLock = null;
        if (this.lockUnawareWorkers.contains(lock.getAgentName())) {
            updatedLock = AgentLockInfo.createAcknowledgeLegacy((AgentLockInfo)lock, (int)this.agentLockService.getMaxLevel(lock.getOwner(), lock.getAgentName()));
            StatusLock msg = new StatusLock(updatedLock);
            this.sendStatusMessage((StatusMessage)msg);
            this.addLock(updatedLock);
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            AgentLockInfo lockRequest = AgentLockInfo.createLockRequest((AgentLockInfo)lock, (int)this.agentLockService.getMaxLevel(lock.getOwner(), lock.getAgentName()));
            this.latches.put(lockRequest.getAgentName(), latch);
            StatusLock msg = new StatusLock(lockRequest);
            this.sendStatusMessage((StatusMessage)msg);
            log.info((Object)("sent message, waiting. Level: " + lockRequest.getMaxLevel()));
            try {
                latch.await(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            updatedLock = this.getLockInfo(lock.getAgentName());
            if (updatedLock != null && updatedLock.getStatus() != AgentLockInfo.Status.ACKNOWLEDGED) {
                log.info((Object)("did not receive ack for" + updatedLock + " status " + updatedLock.getStatus()));
                this.locksByAgentName.remove(updatedLock.getAgentName());
                updatedLock = null;
            }
            if (updatedLock != null) {
                log.info((Object)("got lock ack " + updatedLock + " token " + updatedLock.getToken()));
            }
            assert (updatedLock == null || updatedLock.getStatus() == AgentLockInfo.Status.ACKNOWLEDGED);
            this.latches.remove(lock.getAgentName());
        }
        return updatedLock;
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="unlock a subsystem", level=0, autoAck=false)
    public void unlockAgent(@Argument(name="lock", description="Unlock request") AgentLockInfo lock) {
        log.debug((Object)("got unlock command for " + lock.getAgentName() + " from " + lock.getOwner()));
        if (lock.getStatus() != AgentLockInfo.Status.RELEASED) {
            this.sendNack((Serializable)((Object)("Lock request with bad status " + lock.getStatus())));
            return;
        }
        AgentLockInfo lockInfo = this.getLockInfo(lock.getAgentName());
        if (lockInfo == null) {
            this.sendNack((Serializable)((Object)"The subsystem is not locked."));
            return;
        }
        if (!lockInfo.getOwner().equals(lock.getOwner())) {
            this.sendNack((Serializable)((Object)("Lock is owned by another user: " + lockInfo.getOwner())));
            return;
        }
        this.sendAck(null);
        this.removeLock(lock);
        StatusLock msg = new StatusLock(lock);
        msg.setState(this.agentStateService.getState());
        this.aml.sendStatusMessage((StatusMessage)msg);
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="attach a locked subsystem", level=0, autoAck=false)
    public AgentLockInfo attachLock(@Argument(name="lock", description="Attach request") AgentLockInfo lock) {
        log.debug((Object)("got attachLock command for " + lock.getAgentName() + " from " + lock.getOwner()));
        if (lock.getStatus() != AgentLockInfo.Status.ATTACH) {
            this.sendNack((Serializable)((Object)("Lock request with bad status " + lock.getStatus())));
            return null;
        }
        AgentLockInfo knownLock = null;
        if (lock.getToken() != null) {
            knownLock = this.locksByToken.get(lock.getToken()).getLockInfo();
            if (knownLock == null) {
                this.sendNack((Serializable)((Object)("invalid lock token " + lock.getToken())));
                return null;
            }
            if (lock.getAgentName() != null && !lock.getAgentName().equals(knownLock.getAgentName())) {
                this.sendNack((Serializable)((Object)("inconsistent agent name for lock: " + lock.getToken() + " " + lock.getAgentName() + " " + knownLock.getAgentName())));
                return null;
            }
        } else if (lock.getAgentName() != null) {
            AgentLockInfo.AgentLockInfoString ls = this.locksByAgentName.get(lock.getAgentName());
            if (ls != null) {
                knownLock = ls.getLockInfo();
            }
        } else {
            this.sendNack((Serializable)((Object)"Invalid lock info, no token, no agentName"));
            return null;
        }
        if (knownLock == null) {
            this.sendNack((Serializable)((Object)"The subsystem is not locked."));
            return null;
        }
        if (!knownLock.getOwner().equals(lock.getOwner())) {
            this.sendNack((Serializable)((Object)("Lock is owned by another user: " + knownLock.getOwner())));
            return null;
        }
        StatusLock msg = new StatusLock(lock);
        this.sendStatusMessage((StatusMessage)msg);
        this.sendAck(null);
        return knownLock;
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="detach a locked subsystem", level=0)
    public void detachLock(@Argument(name="lock", description="Detach request") AgentLockInfo lock) {
        log.debug((Object)("got detachLock command for " + lock.getAgentName() + " from " + lock.getOwner()));
        StatusLock msg = new StatusLock(lock);
        this.sendStatusMessage((StatusMessage)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="lock a subsystem, or attach a lock if it already exists", level=0, autoAck=false)
    public AgentLockInfo lockOrAttach(@Argument(name="lock", description="Lock request") AgentLockInfo lock) {
        this.executingLockOrAttach.set(true);
        try {
            AgentLockInfo agentLockInfo = this.lockAgent(lock);
            return agentLockInfo;
        }
        catch (IllegalStateException x) {
            AgentLockInfo request = AgentLockInfo.createAttachRequest((AgentLockInfo)lock, (AgentLockInfo)lock);
            AgentLockInfo agentLockInfo = this.attachLock(request);
            return agentLockInfo;
        }
        finally {
            this.executingLockOrAttach.set(null);
        }
    }

    private AgentLockInfo getLockInfo(String agentName) {
        AgentLockInfo.AgentLockInfoString lockInfoString = this.locksByAgentName.get(agentName);
        return lockInfoString == null ? null : lockInfoString.getLockInfo();
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="for the given user, returns a map of name or name wildcard to maximum allowed level", level=0, autoAck=false)
    public Map<String, Integer> getMaxLevelUser(@Argument(name="user", description="User ID") String user) {
        Map out = AgentLockService.getMaxLevelsUser((String)user, this.maxLevelMap);
        log.fine((Object)("Responding to getMaxLevelUser with " + out));
        return out;
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="for the given agent, returns a map of users to maximum allowed levels", level=0, autoAck=false)
    public Map<String, Integer> getMaxLevelSubsystem(@Argument(name="subsystem", description="Subsystem name") String subsystem) {
        Map out = AgentLockService.getMaxLevelsSubsystem((String)subsystem, this.maxLevelMap);
        log.fine((Object)("Responding to getMaxLevelSubsystem with " + out));
        return out;
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.USER, description="Adds, removes, or modifies an authorized user.", level=50, autoAck=false)
    public String addUser(@Argument(name="user", description="User ID") String user, @Argument(name="maxLevels", description="Map of subsystem names to maximum allowed levels.") Map<String, String> maxLevels) {
        boolean remove;
        Map old = AgentLockService.trimMaxLevelsConfig(this.maxLevelMap);
        boolean bl = remove = maxLevels == null || maxLevels.isEmpty();
        if (remove) {
            old.remove(user);
        } else {
            old.put(user, maxLevels);
        }
        ConfigurationService serv = (ConfigurationService)this.getAgentService(ConfigurationService.class);
        serv.change("/", "maxLevelMap", new ConcurrentHashMap(old));
        if (remove) {
            return "Removed user " + user;
        }
        StringBuilder sb = new StringBuilder("Max levels for ").append(user).append(":").append(System.lineSeparator());
        TreeMap<String, Integer> levels = new TreeMap<String, Integer>(this.getMaxLevelUser(user));
        levels.forEach((sub, level) -> sb.append("  ").append((String)sub).append(" = ").append(level).append(System.lineSeparator()));
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.USER, description="Prints maximum authorized lock levels for the specified user", level=1, autoAck=false)
    public String printMaxLevels(@Argument(name="user", description="User ID. Leave empty to print max levels for all users.", defaultValue="") String user, @Argument(name="expand", description="If true, any groups the user belongs to are expanded, and actual max levels for subsystems are printed.", defaultValue="false") boolean expand) {
        if (this.maxLevelMap.isEmpty()) {
            return "";
        }
        if (expand) {
            if (user == null || user.isEmpty()) {
                LinkedList<String> users = new LinkedList<String>();
                for (String u2 : this.maxLevelMap.keySet()) {
                    u2 = u2.trim();
                    Map<String, Integer> userMap = this.getMaxLevelUser(u2);
                    StringBuilder sb = new StringBuilder();
                    sb.append(u2).append(" : [");
                    sb.append(String.join((CharSequence)", ", userMap.entrySet().stream().map(e -> (String)e.getKey() + " : " + e.getValue()).toList()));
                    sb.append("]");
                    users.add(sb.toString());
                }
                return String.join((CharSequence)System.lineSeparator(), users);
            }
            Map<String, Integer> userMap = this.getMaxLevelUser(user);
            return String.join((CharSequence)System.lineSeparator(), userMap.entrySet().stream().map(e -> (String)e.getKey() + " : " + e.getValue()).toList());
        }
        Map config = AgentLockService.trimMaxLevelsConfig(this.maxLevelMap);
        if (user == null || user.isEmpty()) {
            MaxLevelOrder comp = new MaxLevelOrder();
            StringBuilder sb = new StringBuilder();
            config.forEach((u, m) -> {
                sb.append((String)u).append(" : [");
                sb.append(String.join((CharSequence)", ", comp.entryList((Map<String, String>)m).stream().map(e -> (String)e.getKey() + " : " + (String)e.getValue()).toList()));
                sb.append("]").append(System.lineSeparator());
            });
            return sb.toString();
        }
        Map userMap = (Map)config.get(user);
        if (userMap == null || userMap.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e2 : new MaxLevelOrder().entryList(userMap)) {
            sb.append(e2.getKey()).append(" : ").append(e2.getValue()).append(System.lineSeparator());
        }
        return sb.toString();
    }

    private class MaxLevelOrder
    implements Comparator<Map.Entry<String, String>> {
        private MaxLevelOrder() {
        }

        @Override
        public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
            return e2.getValue().compareTo(e1.getValue());
        }

        @Override
        public Comparator<Map.Entry<String, String>> thenComparing(Comparator<? super Map.Entry<String, String>> other) {
            return (e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey());
        }

        List<Map.Entry<String, String>> entryList(Map<String, String> map) {
            ArrayList<Map.Entry<String, String>> out = new ArrayList<Map.Entry<String, String>>(map.entrySet());
            out.sort(this);
            return out;
        }
    }
}

