/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.shutter.Alerts;
import org.lsst.ccs.subsystem.shutter.Controller;
import org.lsst.ccs.subsystem.shutter.Publisher;
import org.lsst.ccs.subsystem.shutter.StateMachine;
import org.lsst.ccs.subsystem.shutter.Watchdog;
import org.lsst.ccs.subsystem.shutter.common.EncoderSample;
import org.lsst.ccs.subsystem.shutter.common.HallTransition;
import org.lsst.ccs.subsystem.shutter.common.PLCError;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.Error;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SynchronousChannel;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class SimulatedActions
implements Actions {
    private static final Logger LOG = Logger.getLogger((String)SimulatedActions.class.getName());
    private static final Alert SYNC_ALERT = new Alert("SYNC", "Simulated status of tracking of controller state.");
    private static final Alert PLC_ALERT = new Alert("PLC", "Notice of simulated shutter controller errors.");
    private final Controller control;
    private final StateMachine machine;
    private final Subsystem subsys;
    private final Publisher publish;
    private final Watchdog wdog;
    private final Scheduler resetSched = new Scheduler("Reset submitter", 1);

    public SimulatedActions(Controller control, StateMachine machine, Subsystem subsys, Publisher publish, Watchdog wdog) {
        this.control = control;
        this.machine = machine;
        this.subsys = subsys;
        this.publish = publish;
        this.wdog = wdog;
    }

    @Override
    public boolean axisIsEnabled(ShutterSide side) {
        ShutterStatus status = this.publish.getShutterStatus();
        return status.getAxisStatus(side).isEnabled();
    }

    @Override
    public boolean brakeIsEngaged(ShutterSide side) {
        if (this.brakePowerIsOn()) {
            ShutterStatus status = this.publish.getShutterStatus();
            return status.getAxisStatus(side).isBrakeEngaged();
        }
        return true;
    }

    @Override
    public boolean brakePowerIsOn() {
        return this.machine.brakePowerIsOn();
    }

    @Override
    public void cancelSyncTimer() {
        LOG.info((Object)"{ACTION cancelSyncTimer()}");
    }

    @Override
    public void disableWatchdog() {
        LOG.info((Object)"{ACTION disableWatchdog()}");
        try {
            this.wdog.disable();
        }
        catch (InterruptedException exc) {
            LOG.info((Object)"Watchdog disable was interrupted.");
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void enableWatchdog() {
        LOG.info((Object)"{ACTION enableWatchdog()}");
        try {
            this.wdog.enable();
        }
        catch (InterruptedException exc) {
            LOG.info((Object)"Watchdog enable was interrupted.");
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean isBadExposureTime(Duration exposureTime) {
        LOG.info((Object)"{ACTION isBadExposure()}");
        return this.control.isBadExposureTime(exposureTime);
    }

    @Override
    public boolean makePartialContact() {
        LOG.info((Object)"{ACTION makePartialContact()}");
        this.control.simulateContact();
        return true;
    }

    @Override
    public boolean makeFullContact() {
        LOG.info((Object)"{ACTION makeFullContact()}");
        return true;
    }

    @Override
    public void publishBrakePowerStatus(boolean powerIsOn) {
        this.publish.publishBrakePowerStatus(powerIsOn);
    }

    @Override
    public void publishEnableStatus(boolean isEnabled) {
        this.publish.setEnableStatus(isEnabled);
    }

    @Override
    public void setPhysicalState(PhysicalState newState) {
        LOG.info((Object)String.format("{ACTION setPhysicalState(%s)}", new Object[]{newState}));
        this.machine.setPhysicalState(newState);
    }

    @Override
    public void setSoftwareState(SoftwareState newState) {
        LOG.info((Object)String.format("{ACTION setSoftwareState(%s)}", new Object[]{newState}));
        this.machine.setSoftwareState(newState);
    }

    @Override
    public void raisePLCAlert(Error err) {
        LOG.fine((Object)"{ACTION raisePLCAlert()}");
        for (PLCError e : err.getErrors()) {
            LOG.log(Level.WARNING, "PLC error {0} - {1}.", new Object[]{e.toString(), e.getDescription()});
        }
        String errlist = err.getErrors().stream().map(Enum::toString).collect(Collectors.joining(", "));
        Alerts.PLC.raise((AlertService)this.subsys.getAgentService(AlertService.class), AlertState.ALARM, errlist, AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
    }

    @Override
    public void raiseSyncAlert(String reason) {
        LOG.fine((Object)"{ACTION raiseSyncAlert()}");
        Alerts.SYNC.raise((AlertService)this.subsys.getAgentService(AlertService.class), AlertState.ALARM, reason, AlertService.RaiseAlertStrategy.ALWAYS);
    }

    @Override
    public void raiseStopCmdAlert() {
        LOG.fine((Object)"{ACTION raiseStopCmdAlert()}");
        Alerts.STOP_CMD.raise((AlertService)this.subsys.getAgentService(AlertService.class), AlertState.ALARM, "", AlertService.RaiseAlertStrategy.ALWAYS);
    }

    @Override
    public boolean readyForCalibration() {
        LOG.info((Object)"{ACTION readyForCalibration()}");
        return true;
    }

    @Override
    public void resetPLC() {
        LOG.info((Object)"{ACTION resetPLC()}");
        this.control.simulateResetPLC();
    }

    @Override
    public void relay(MsgToPLC eventMsg) {
        LOG.log(Level.INFO, "'{'ACTION relay({0})'}'", eventMsg.getClass());
        this.control.simulateRelay(eventMsg);
    }

    @Override
    public void saveCalib(CalibDone cal) {
        LOG.info((Object)"{ACTION saveCalib() - not yet implemented.}");
    }

    @Override
    public void sendProfile(MotionDonePLC mot) {
        LOG.info((Object)"{ACTION sendProfile()}");
        this.dumpMotionDone(mot.getStatusBusMessage());
        this.control.checkHallTransitions(mot);
        this.publish.publishMotionDone(mot.getStatusBusMessage());
    }

    @Override
    public void signalAReset() {
        Runnable resetTask = () -> {
            try {
                SynchronousChannel<EventReply> replyChan = new SynchronousChannel<EventReply>();
                this.machine.reset(replyChan);
                EventReply eventReply = (EventReply)replyChan.read();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        };
        this.resetSched.schedule(resetTask, 0L, TimeUnit.SECONDS);
    }

    private void dumpMotionDone(MotionDone mot) {
        StringBuilder bld = new StringBuilder();
        bld.append("[MotionDone begin]\n");
        bld.append("side " + (Object)((Object)mot.side()) + "\n");
        bld.append("startPosition " + mot.startPosition() + " mm\n");
        bld.append("startTime " + mot.startTime().getUTCInstant().toEpochMilli() + " Unix epoch ms\n");
        bld.append("targetPosition " + mot.targetPosition() + " mm\n");
        bld.append("targetDuration " + mot.targetDuration().toMillis() + " ms\n");
        bld.append("endPosition " + mot.endPosition() + " mm\n");
        bld.append("actualDuration " + mot.actualDuration().toMillis() + " ms\n");
        bld.append("[Hall begin] time(Unix epoch ms) ID position(mm) isOn\n");
        for (HallTransition hall : mot.hallTransitions()) {
            bld.append(hall.getTime().getUTCInstant().toEpochMilli());
            bld.append(" ");
            bld.append(hall.getSensorId());
            bld.append(" ");
            bld.append(hall.getPosition());
            bld.append(" ");
            bld.append(hall.isOn());
            bld.append("\n");
        }
        bld.append("[Hall end]\n");
        bld.append("[Encoder begin] time(Unix epoch ms) position(mm)\n");
        for (EncoderSample enc : mot.encoderSamples()) {
            bld.append(enc.getTime().getUTCInstant().toEpochMilli());
            bld.append(" ");
            bld.append(enc.getPosition());
            bld.append("\n");
        }
        bld.append("[Encoder end]\n");
        bld.append("[MotionDone end]\n");
        LOG.fine((Object)bld.toString());
    }

    @Override
    public void startFirstCentering() {
        LOG.info((Object)"{ACTION startFirstCentering()}");
        this.control.startFirstCentering();
    }

    @Override
    public void startSecondCentering() {
        LOG.info((Object)"{ACTION startSecondCentering(};}");
        this.control.startSecondCentering();
    }

    @Override
    public String shutterIsReady() {
        LOG.info((Object)"{ACTION shutterIsReady()}");
        return null;
    }

    @Override
    public void startSyncTimer() {
        LOG.info((Object)"{ACTION startSyncTimer()}");
    }

    @Override
    public void terminateContact() {
        LOG.info((Object)"{ACTION terminateContact()}");
    }
}

