import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.Subscale;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.refrig.MCCDevice;
import org.lsst.ccs.subsystem.refrig.DcsDevice;
import org.lsst.ccs.subsystem.refrig.WUDevice;
import org.lsst.ccs.subsystem.refrig.GP390Device;
import org.lsst.ccs.subsystem.refrig.DL34970Device;
import org.lsst.ccs.subsystem.common.devices.Maq20Device;
import org.lsst.ccs.subsystem.common.devices.PlutoDevice;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Page;

//String limitLo = "limitLo"
//String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig-subscale"]

builder.main (Subscale, tickMillis: 10000, monMillis: 1000, checkMillis: 7500,
              cmprPowerLines: [["CmprLine1"], ["CmprLine2"]] as List[],
              loadPowerLines: ["LoadLine"] as String[],
              loadPowerDevc: "Power",
              alarmDsabChans: ["EvapTemp1"] as String[],
              loadTempChans: ["EvapDLTC04"] as String[],
              tempCtrl: "TempCtrl") {

    TempCtrl   (TempControl, gain: 25.0, timeConst: 1000.0, smoothTime: 120.0,
                maxOutput: 250.0, awGain: 4.0, basePower: 0.0, tolerance: 0.05,
                updateTime: 30000)

    MaqCmpr    (Maq20Device, node: "192.168.128.100",
                serial: ["0098704-16", "0100762-06"] as String[])

    PlutoCmpr  (PlutoDevice, node: "192.168.0.100", areas: [1, 1, 1, 2, 1, 3])

    MccCmpr    (MCCDevice, devName: "TC_AI", serial: "00087534")

    Mod1       (MCCDevice, devName: "TC_AI", serial: "00099707")

    Mod2       (MCCDevice, devName: "TEMP", serial: "018F9BA8")

    Mod3       (MCCDevice, devName: "TEMP", serial: "018F9BAA")

    HxMod1     (MCCDevice, devName: "TC_AI", serial: "00099629")

    Vac1       (GP390Device, serial: "AE01BAG1", address: 2)

    Logger     (DL34970Device, connType: "SERIAL", devcId: "/dev/ttyS0")

    Power      (DcsDevice, connType: "FTDI", ident: "A602LIHA")

    //WattsCmpr1 (WUDevice, serial: "AH02WF20")

    WattsCmpr2 (WUDevice, serial: "AH02WF20")

    CmprLine1  (Line, devcName: "PlutoCmpr", chan: 16)

    CmprLine2  (Line, devcName: "MccCmpr", chan: 7)

    LoadLine   (Line, devcName: "Mod1", chan: 0)

    ResetLine  (Line, devcName: "PlutoCmpr", chan: 0)

    AlarmCmpr1 (Alarm, description: "Trips off compressor 1 power", eventParm: 0)

    AlarmCmpr2 (Alarm, description: "Trips off compressor 2 power", eventParm: 1)

    Page0      (Page, id: 0, label: "Cryostat")

    Page1      (Page, id: 1, label: "Circuit 1")

    Page2      (Page, id: 2, label: "Circuit 2")

    Page3      (Page, id: 3, label: "Temperature Profiles")

/*
    Chanxxx    (Channel, description: "",
                format: ".2f", units: "", devcName: "xxx, hwChan: 0,
                type: "", subtype: "", offset: 0, scale: 1,
                checkLo: "flag", limitLo: 0.0, dbandLo: 0.0, alarmLo: null,
                checkHi: "flag", limitHi: 0.0, dbandHi: 0.0, alarmHi: null)
*/  

    "C1.CmpPower"   (Channel, description: "Compressor\\Power", units: "Watts",
                devcName: null, type: "PROD", subtype: "C1.CmpVolts:C1.CmpCurr", pageId: 1,
                checkHi: "alarm", alarmHi: "AlarmCmpr1", offset: 30.0)
/*
    "C1.CmpPower"   (Channel, description: "Compressor\\Power", units: "Watts",
                devcName: "PlutoCmpr", hwChan: 16, type: "GLOBAL:1", pageId: 1,
                checkHi: "alarm", alarmHi: "AlarmCmpr1")

    "C1.CmpPower"   (Channel, description: "Compressor\\Power", units: "Watts",
                devcName: "WattsCmpr1", hwChan: 0, type: "POWER", pageId: 1,
                checkHi: "alarm", alarmHi: "AlarmCmpr1")
*/
    "C1.CmpDisPrs"  (Channel, description: "Discharge pressure", units: "Psig",
                devcName: "PlutoCmpr", hwChan: 1, type: "ADDREG:0", pageId: 1,
                offset: -4.0, scale: 0.1,
                checkHi: "alarm", alarmHi: "AlarmCmpr1")

    "C1.CmpSucPrs"  (Channel, description: "Suction pressure", units: "Psig",
                devcName: "MaqCmpr", hwChan: 5, type: "VOLT:0", subtype: "V5", pageId: 1,
                scale: 40.0,
                checkLo: "alarm", alarmLo: "AlarmCmpr1")

    "C1.CmpDisTmp"  (Channel, description: "Discharge temperature", units: "\u00b0C",
                devcName: "MaqCmpr", hwChan: 2, type: "TTC:1", subtype: "T220", pageId: 1,
                checkHi: "alarm", alarmHi: "AlarmCmpr1")

    "C1.CmpSepTmp"  (Channel, description: "Separator temperature", units: "\u00b0C",
                devcName: "MaqCmpr", hwChan: 0, type: "TTC:1", subtype: "T220", pageId: 1)

    "C1.CmpAmbTmp"  (Channel, description: "Ambient temperature", units: "\u00b0C",
                devcName: "MaqCmpr", hwChan: 1, type: "TTC:1", subtype: "T220", pageId: 1)

    "C1.CmpVolts"  (Channel, description: "Line voltage", units: "Volts",
                devcName: "MaqCmpr", hwChan: 0, type: "VOLT:0", subtype: "V5", scale: 50.0, pageId: 1)

    "C1.CmpCurr"   (Channel, description: "Current", units: "Amps",
                devcName: "MaqCmpr", hwChan: 1, type: "VOLT:0", subtype: "V5", scale: 5.0, pageId: 1)
/*
    "C1.CmpVolts"  (Channel, description: "Line voltage", units: "Volts",
                devcName: "WattsCmpr1", hwChan: 1, type: "POWER", pageId: 1)

    "C1.CmpFreq"   (Channel, description: "Line frequency", units: "Hz",
                devcName: "WattsCmpr1", hwChan: 2, type: "POWER", pageId: 1)
*/
    "C1.CmpFlowLow" (Channel, description: "Water flow low latch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 29, type: "GLOBAL:1", pageId: 1)

    "C1.CmpTempHi" (Channel, description: "Temperature high latch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 24, type: "GLOBAL:1", pageId: 1)

    "C1.C3LiqdTmp"  (Channel, description: "Heat Exchanger\\C3 liq capillary temperature",
                units: "\u00b0C",
                devcName: "Mod1", hwChan: 0, type: "TEMP", subtype: "TC:T", pageId: 1)

    "C1.PreC3Tmp"   (Channel, description: "Pre C3 temperature", units: "\u00b0C",
                devcName: "Mod2", hwChan: 6, type: "TEMP", subtype: "TC:T", pageId: 1)

    "C1.PostC3Tmp"  (Channel, description: "Post C3 temperature", units: "\u00b0C",
                devcName: "Mod2", hwChan: 7, type: "TEMP", subtype: "TC:T", pageId: 1)

    "C1.PreC4Tmp"   (Channel, description: "Pre C4 temperature", units: "\u00b0C",
                devcName: "Mod1", hwChan: 1, type: "TEMP", subtype: "TC:T", pageId: 1)

    "C1.PostC4Tmp"  (Channel, description: "Post C4 temperature", units: "\u00b0C",
                devcName: "Mod1", hwChan: 2, type: "TEMP", subtype: "TC:T", pageId: 1)

    "C1.EvapVcrTmp" (Channel, description: "Evaporator outlet VCR temp", units: "\u00b0C",
                devcName: "Mod2", hwChan: 5, type: "TEMP", subtype: "TC:T", pageId: 1)

    "C1.HXRetnTmp"  (Channel, description: "Return line temperature", units: "\u00b0C",
                devcName: "Mod1", hwChan: 3, type: "TEMP", subtype: "TC:T", pageId: 1)

    "C1.LiqSupTmpVac" (Channel, description: "Liquid supply temp by vac can", units: "\u00b0C",
                devcName: "Logger", hwChan: 116, type: "TEMP", subtype: "T", pageId: 1)

    "C1.VapSupTmpVac" (Channel, description: "Vapor supply temp by vac can", units: "\u00b0C",
                devcName: "Logger", hwChan: 117, type: "TEMP", subtype: "T", pageId: 1)

    "C1.RetnTmpVac" (Channel, description: "Return temp by vac can", units: "\u00b0C",
                devcName: "Logger", hwChan: 118, type: "TEMP", subtype: "T", pageId: 1)

    "C1.SrgTankTmp" (Channel, description: "Surge tank temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 119, type: "TEMP", subtype: "T", pageId: 1)

    "C1.AprnAmbTmp" (Channel, description: "Ambient temperature", units: "\u00b0C",
                devcName: "Mod2", hwChan: 3, type: "TEMP", subtype: "TC:T", pageId: 1)

    "C1.HexVapPrs"  (Channel, description: "Vapor supply pressure", units: "Psig",
                devcName: "Mod1", hwChan: 5, type: "VOLTS", subtype: "1.25V", pageId: 1,
                offset: 4.84, scale: 5000.0,
                checkHi: "alarm", alarmHi: "AlarmCmpr1")

    "C1.HexLiqPrs"  (Channel, description: "Liquid supply pressure", units: "Psig",
                devcName: "Mod1", hwChan: 4, type: "VOLTS", subtype: "1.25V", pageId: 1,
                offset: 1.71, scale: 5000.0,
                checkHi: "alarm", alarmHi: "AlarmCmpr1")

    "C1.HexPrsDiff" (Channel, description: "Vapor/liquid delta P", units: "Psi",
                devcName: null, type: "DIFF", subtype: "C1.HexLiqPrs:C1.HexVapPrs", pageId: 1,
                checkLo: "none", checkHi: "none")

    "C1.HexSucPrs"  (Channel, description: "Return pressure", units: "Psig",
                devcName: "Mod1", hwChan: 7, type: "VOLTS", subtype: "1.25V", pageId: 1,
                offset: -0.05, scale: 1000.0)

    "C1.HexVacuum"  (Channel, description: "Vacuum pressure", format: ".3G", units: "Torr",
                devcName: "Vac1", hwChan: 0, pageId: 1)

    "C2.CmpPower"   (Channel, description: "Compressor\\Power", units: "Watts",
                devcName: "WattsCmpr2", hwChan: 0, type: "POWER", pageId: 2,
                checkHi: "alarm", alarmHi: "AlarmCmpr2")

    "C2.CmpDisPrs"  (Channel, description: "Discharge pressure", units: "Psig",
                devcName: "MccCmpr", hwChan: 6, type: "VOLTS", subtype: "1.25V", pageId: 2,
                offset: -2.5, scale: 10000.0,
                checkHi: "alarm", alarmHi: "AlarmCmpr2")

    "C2.CmpSucPrs"  (Channel, description: "Suction pressure", units: "Psig",
                devcName: "MccCmpr", hwChan: 7, type: "VOLTS", subtype: "1.25V", pageId: 2,
                offset: 0.77, scale: 1000.0,
                checkLo: "alarm", alarmLo: "AlarmCmpr2")

    "C2.CmpDisTmp"  (Channel, description: "Discharge temperature", units: "\u00b0C",
                devcName: "MccCmpr", hwChan: 0, type: "TEMP", subtype: "TC:T", pageId: 2,
                checkHi: "alarm", alarmHi: "AlarmCmpr2")

    "C2.CmpSepTmp"  (Channel, description: "Separator temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 211, type: "TEMP", subtype: "T", pageId: 2)

    "C2.CmpSumpTmp"  (Channel, description: "Oil Sump temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 215, type: "TEMP", subtype: "T", pageId: 2)

    "C2.CmpBodyTmp"  (Channel, description: "Body temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 214, type: "TEMP", subtype: "T", pageId: 2)

    "C2.CmpRetnTmp"  (Channel, description: "Return temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 210, type: "TEMP", subtype: "T", pageId: 2)

    "C2.CndsInTmp"  (Channel, description: "Condenser inlet temp", units: "\u00b0C",
                devcName: "Logger", hwChan: 212, type: "TEMP", subtype: "T", pageId: 2)

    "C2.CndsOutTmp"  (Channel, description: "Condenser outlet temp", units: "\u00b0C",
                devcName: "Logger", hwChan: 213, type: "TEMP", subtype: "T", pageId: 2)

    "C2.WtrSupTmp"  (Channel, description: "Water supply temp", units: "\u00b0C",
                devcName: "Logger", hwChan: 216, type: "TEMP", subtype: "T", pageId: 2)

    "C2.WtrRetnTmp"  (Channel, description: "Water return temp", units: "\u00b0C",
                devcName: "Logger", hwChan: 217, type: "TEMP", subtype: "T", pageId: 2)

    "C2.C3LiqSupTmp"  (Channel, description: "C3 liquid supply temp", units: "\u00b0C",
                devcName: "Logger", hwChan: 218, type: "TEMP", subtype: "T", pageId: 2)

    "C2.C4VapSupTmp"  (Channel, description: "C4 vapor supply temp", units: "\u00b0C",
                devcName: "Logger", hwChan: 209, type: "TEMP", subtype: "T", pageId: 2)
/*
    "C2.CmpSepTmp"  (Channel, description: "Separator temperature", units: "\u00b0C",
                devcName: "MccCmpr", hwChan: 2, type: "TEMP", subtype: "TC:T", pageId: 2)

    "C2.CmpAmbTmp"  (Channel, description: "Ambient temperature", units: "\u00b0C",
                devcName: "MaqCmpr", hwChan: 1, type: "TTC:1", subtype: "T220", pageId: 2)
*/
    "C2.CmpVolts"  (Channel, description: "Line voltage", units: "Volts",
                devcName: "WattsCmpr2", hwChan: 1, type: "POWER", pageId: 2)

    "C2.CmpFreq"   (Channel, description: "Line frequency", units: "Hz",
                devcName: "WattsCmpr2", hwChan: 2, type: "POWER", pageId: 2)
/*
    "C2.CmpFlowLow" (Channel, description: "Water flow low latch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 29, type: "GLOBAL:1", pageId: 2)

    "C2.CmpTempHi" (Channel, description: "Temperature high latch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 24, type: "GLOBAL:1", pageId: 2)
*/
    "C2.C3LiqdTmp"  (Channel, description: "Heat Exchanger\\C3 liq capillary temperature",
                units: "\u00b0C",
                devcName: "Logger", hwChan: 204, type: "TEMP", subtype: "T", pageId: 2)

    "C2.PreC3Tmp"   (Channel, description: "Pre C3 temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 205, type: "TEMP", subtype: "T", pageId: 2)

    "C2.PostC3Tmp"  (Channel, description: "Post C3 temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 206, type: "TEMP", subtype: "T", pageId: 2)

    "C2.PreC4Tmp"   (Channel, description: "Pre C4 temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 202, type: "TEMP", subtype: "T", pageId: 2)

    "C2.PostC4Tmp"  (Channel, description: "Post C4 temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 201, type: "TEMP", subtype: "T", pageId: 2)

    "C2.EvapVcrTmp" (Channel, description: "Evaporator outlet VCR temp", units: "\u00b0C",
                devcName: "Logger", hwChan: 203, type: "TEMP", subtype: "T", pageId: 2)

    "C2.HXRetnTmp"  (Channel, description: "Return line temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 207, type: "TEMP", subtype: "T", pageId: 2)

    "C2.HexVapPrs"  (Channel, description: "Vapor supply pressure", units: "Psig",
                devcName: "HxMod1", hwChan: 6, type: "VOLTS", subtype: "1.25V", pageId: 2,
                offset: 0.0, scale: 5000.0,
                checkHi: "alarm", alarmHi: "AlarmCmpr2")

    "C2.HexLiqPrs"  (Channel, description: "Liquid supply pressure", units: "Psig",
                devcName: "HxMod1", hwChan: 5, type: "VOLTS", subtype: "1.25V", pageId: 2,
                offset: 0.0, scale: 5000.0,
                checkHi: "alarm", alarmHi: "AlarmCmpr2")

    "C2.HexPrsDiff" (Channel, description: "Vapor/liquid delta P", units: "Psi",
                devcName: null, type: "DIFF", subtype: "C2.HexLiqPrs:C2.HexVapPrs", pageId: 2,
                checkLo: "none", checkHi: "none")

    "C2.HexRtnPrs"  (Channel, description: "Return pressure", units: "Psig",
                devcName: "HxMod1", hwChan: 4, type: "VOLTS", subtype: "1.25V", pageId: 2,
                offset: 0.0, scale: 1000.0)
/*
    "C2.HexVacuum"  (Channel, description: "Vacuum pressure", format: ".3G", units: "Torr",
                devcName: "Vac1", hwChan: 0, pageId: 2)
*/
    LoadTmp1   (Channel, description: "Cryostat\\Load temperature 1 RTD", units: "\u00b0C",
                devcName: "Mod3", hwChan: 0, type: "TEMP", subtype: "RTD:3WIRE")

    LoadTmp2   (Channel, description: "Load temperature 2 RTD", units: "\u00b0C",
                devcName: "Mod3", hwChan: 2, type: "TEMP", subtype: "RTD:3WIRE")

    LoadTmp3   (Channel, description: "Load temperature 3 RTD", units: "\u00b0C",
                devcName: "Mod2", hwChan: 0, type: "TEMP", subtype: "RTD:3WIRE")

    LoadTmp4   (Channel, description: "Load temperature 4 RTD", units: "\u00b0C",
                devcName: "Mod3", hwChan: 4, type: "TEMP", subtype: "RTD:3WIRE")

    LoadTmp5   (Channel, description: "Load temperature 5 RTD", units: "\u00b0C",
                devcName: "Mod3", hwChan: 6, type: "TEMP", subtype: "RTD:3WIRE")

    LoadPower  (Channel, description: "Heat load power", units: "Watts",
                devcName: "Power", hwChan: 0, type: "POWER")

    LoadVolts  (Channel, description: "Heat load voltage", units: "Volts",
                devcName: "Power", hwChan: 1, type: "POWER")

    EvapTemp1  (Channel, description: "Evaporator temperature 1", units: "\u00b0C",
                devcName: "Mod2", hwChan: 2, type: "TEMP", subtype: "TC:T",
                checkLo: "alarm", alarmLo: "AlarmCmpr1",
                checkHi: "alarm", alarmHi: "AlarmCmpr1")

    EvapTemp2  (Channel, description: "Evaporator temperature 2", units: "\u00b0C",
                devcName: "Mod2", hwChan: 4, type: "TEMP", subtype: "TC:T")

    EvapDLTC01 (Channel, description: "DL TC 01 Evaporator", units: "\u00b0C",
                devcName: "Logger", hwChan: 101, type: "TEMP", subtype: "T")

    EvapDLTC02 (Channel, description: "DL TC 02 Evaporator", units: "\u00b0C",
                devcName: "Logger", hwChan: 102, type: "TEMP", subtype: "T")

    EvapDLTC03 (Channel, description: "DL TC 03 Evaporator", units: "\u00b0C",
                devcName: "Logger", hwChan: 103, type: "TEMP", subtype: "T")

    EvapDLTC04 (Channel, description: "DL TC 04 Evaporator", units: "\u00b0C",
                devcName: "Logger", hwChan: 104, type: "TEMP", subtype: "T")

    EvapDLTC05 (Channel, description: "DL TC 05 Evaporator", units: "\u00b0C",
                devcName: "Logger", hwChan: 105, type: "TEMP", subtype: "T")

    Running    (Channel, description: "Heater Control Chassis\\Running state", format: ".0f",
                devcName: "Mod1", hwChan: 6, type: "SWITCH")

    Interlock  (Channel, description: "Interlock state", format: ".0f",
                devcName: "Mod1", hwChan: 2, type: "SWITCH")

    ThermRelay (Channel, description: "Thermal relay state", format: ".0f",
                devcName: "Mod1", hwChan: 3, type: "SWITCH")

    LoadEnable (Channel, description: "Load enable state", format: ".0f",
                devcName: "Mod1", hwChan: 4, type: "SWITCH")

    V5Power    (Channel, description: "5-Volt power state", format: ".0f",
                devcName: "Mod1", hwChan: 5, type: "SWITCH")

    XTC06CmpWtrSupp (Channel, description: "Compressor TCs\\DL TC 06 Water Supply", units: "\u00b0C",
                devcName: "Logger", hwChan: 106, type: "TEMP", subtype: "T", pageId: 1)

    XTC07CmpWtrRetn (Channel, description: "DL TC 07 Water Return", units: "\u00b0C",
                devcName: "Logger", hwChan: 107, type: "TEMP", subtype: "T", pageId: 1)

    XTC08CmpLigSupp (Channel, description: "DL TC 08 C3 Liquid Supply", units: "\u00b0C",
                devcName: "Logger", hwChan: 108, type: "TEMP", subtype: "T", pageId: 1)

    XTC09CmpVapSupp (Channel, description: "DL TC 09 C4 Vapor Supply", units: "\u00b0C",
                devcName: "Logger", hwChan: 109, type: "TEMP", subtype: "T", pageId: 1)

    XTC10CmpRtnLine (Channel, description: "DL TC 10 Return Line", units: "\u00b0C",
                devcName: "Logger", hwChan: 110, type: "TEMP", subtype: "T", pageId: 1)

    XTC11CmpOilSep (Channel, description: "DL TC 11 Oil Separator", units: "\u00b0C",
                devcName: "Logger", hwChan: 111, type: "TEMP", subtype: "T", pageId: 1)

    XTC12CmpCondIn (Channel, description: "DL TC 12 Condenser Inlet", units: "\u00b0C",
                devcName: "Logger", hwChan: 112, type: "TEMP", subtype: "T", pageId: 1)

    XTC13CmpCondOut (Channel, description: "DL TC 13 Condenser Outlet", units: "\u00b0C",
                devcName: "Logger", hwChan: 113, type: "TEMP", subtype: "T", pageId: 1)

    XTC14CmpBody (Channel, description: "DL TC 14 Compressor Body", units: "\u00b0C",
                devcName: "Logger", hwChan: 114, type: "TEMP", subtype: "T", pageId: 1)

    XTC15CmpOilSump (Channel, description: "DL TC 15 Oil Sump", units: "\u00b0C",
                devcName: "Logger", hwChan: 115, type: "TEMP", subtype: "T", pageId: 1)

    CM5BackIn  (Channel, description: "Compressor Box TCs\\CM005 Box Backwall Inside", units: "\u00b0C",
                devcName: "Logger", hwChan: 307, type: "TEMP", subtype: "T", pageId: 3)

    CM5FrontIn (Channel, description: "CM005 Box Frontwall Inside", units: "\u00b0C",
                devcName: "Logger", hwChan: 313, type: "TEMP", subtype: "T", pageId: 3)

    CM5Front3Off (Channel, description: "CM005 Box Frontwall Inside 3\" off", units: "\u00b0C",
                devcName: "Logger", hwChan: 314, type: "TEMP", subtype: "T", pageId: 3)

    CM5SideOut (Channel, description: "CM005 Box Sidewall Outside", units: "\u00b0C",
                devcName: "Logger", hwChan: 320, type: "TEMP", subtype: "T", pageId: 3)

    LLSuc1Vac  (Channel, description: "Long Line TCs\\Suction LL 1' from Vac", units: "\u00b0C",
                devcName: "Logger", hwChan: 301, type: "TEMP", subtype: "T", pageId: 3)

    LLSuc3Vac  (Channel, description: "Suction LL 3' from Vac", units: "\u00b0C",
                devcName: "Logger", hwChan: 302, type: "TEMP", subtype: "T", pageId: 3)

    LLSucMiddle (Channel, description: "Suction LL Middle", units: "\u00b0C",
                devcName: "Logger", hwChan: 304, type: "TEMP", subtype: "T", pageId: 3)

    LLSuc1VacOut (Channel, description: "Suction LL 1' from Vac Outside", units: "\u00b0C",
                devcName: "Logger", hwChan: 305, type: "TEMP", subtype: "T", pageId: 3)

    LLAllMidOut (Channel, description: "All LL Middle Outside", units: "\u00b0C",
                devcName: "Logger", hwChan: 306, type: "TEMP", subtype: "T", pageId: 3)

    LLVap1CM5  (Channel, description: "Vapor LL 1' from CM005", units: "\u00b0C",
                devcName: "Logger", hwChan: 308, type: "TEMP", subtype: "T", pageId: 3)

    LLVap3CM5  (Channel, description: "Vapor LL 3' from CM005", units: "\u00b0C",
                devcName: "Logger", hwChan: 309, type: "TEMP", subtype: "T", pageId: 3)

    LLVap6CM5  (Channel, description: "Vapor LL 6' from CM005", units: "\u00b0C",
                devcName: "Logger", hwChan: 310, type: "TEMP", subtype: "T", pageId: 3)

    LLVapMiddle (Channel, description: "Vapor LL Middle", units: "\u00b0C",
                devcName: "Logger", hwChan: 311, type: "TEMP", subtype: "T", pageId: 3)

    LLVap1CM5Out (Channel, description: "Vapor LL 1' from CM005 Outside", units: "\u00b0C",
                devcName: "Logger", hwChan: 312, type: "TEMP", subtype: "T", pageId: 3)

    LLLiq1CM5  (Channel, description: "Liquid LL 1' from CM005", units: "\u00b0C",
                devcName: "Logger", hwChan: 315, type: "TEMP", subtype: "T", pageId: 3)

    LLLiq3CM5  (Channel, description: "Liquid LL 3' from CM005", units: "\u00b0C",
                devcName: "Logger", hwChan: 316, type: "TEMP", subtype: "T", pageId: 3)

    LLLiq6CM5  (Channel, description: "Liquid LL 6' from CM005", units: "\u00b0C",
                devcName: "Logger", hwChan: 317, type: "TEMP", subtype: "T", pageId: 3)

    LLLiqMiddle (Channel, description: "Liquid LL Middle", units: "\u00b0C",
                devcName: "Logger", hwChan: 318, type: "TEMP", subtype: "T", pageId: 3)

    LLLiq1CM5Out (Channel, description: "Liquid LL 1' from CM005 Outside", units: "\u00b0C",
                devcName: "Logger", hwChan: 319, type: "TEMP", subtype: "T", pageId: 3)

/*
    XTC20Spare (Channel, description: "Spare TCs\\DL TC 20", units: "\u00b0C",
                devcName: "Logger", hwChan: 120, type: "TEMP", subtype: "T")

    Cmpr24Volt (Channel, description: "Cmpr Control Chassis\\24V power supply", units: "Volts",
                devcName: "PlutoCmpr", hwChan: 1, type: "ADDREG:1")

    CmprOnSwch (Channel, description: "ON switch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 6, type: "GLOBAL:1")

    CmprPermit (Channel, description: "CCS permit", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 20, type: "GLOBAL:1")

    CmprEnable (Channel, description: "Enable", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 31, type: "GLOBAL:1")

    CmprPwrOn  (Channel, description: "Power on", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 16, type: "GLOBAL:1")

    CmpExtPerm (Channel, description: "External permit", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 5, type: "GLOBAL:1")

    CmpNoExtPrm (Channel, description: "External permit missing", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 30, type: "GLOBAL:1")

    CmpFlowSwi (Channel, description: "Water flow switch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 0, type: "GLOBAL:1")

    CmprTempOk (Channel, description: "Temperature valid", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 23, type: "GLOBAL:1")

    CmpDisPrsOk (Channel, description: "Discharge pressure valid", format: ".0f",
                 devcName: "PlutoCmpr", hwChan: 25, type: "GLOBAL:1")

    CmpDisPrsHi (Channel, description: "Discharge pressure high latch", format: ".0f",
                 devcName: "PlutoCmpr", hwChan: 26, type: "GLOBAL:1")
*/
}
