/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ccob;

import org.lsst.ccs.drivers.ccob.CCOBDataRead;
import org.lsst.ccs.drivers.ccob.CCOBInterface;
import org.lsst.ccs.drivers.commons.DriverException;

public class CCOBSim
implements CCOBInterface {
    private double ledCurr;

    @Override
    public void init() throws DriverException {
    }

    @Override
    public void stop() throws DriverException {
    }

    @Override
    public String misc() throws DriverException {
        return "XXXXXXXX";
    }

    @Override
    public String manu() throws DriverException {
        return "CCS";
    }

    @Override
    public String date() throws DriverException {
        return "1Jan2018";
    }

    @Override
    public String version() throws DriverException {
        return "1.0";
    }

    @Override
    public String device() throws DriverException {
        return "Sim";
    }

    @Override
    public void selectLed(CCOBInterface.LED led) throws DriverException {
    }

    @Override
    public void setLedCurrent(double current) throws DriverException {
        this.ledCurr = current;
    }

    @Override
    public void setExposureTime(double time) throws DriverException {
    }

    @Override
    public void pulse() throws DriverException {
    }

    @Override
    public void shutter() throws DriverException {
    }

    @Override
    public void startExposure() throws DriverException {
    }

    @Override
    public boolean pollEnd() throws DriverException {
        return true;
    }

    @Override
    public CCOBDataRead getAdcValues() throws DriverException {
        double[] values = new double[8];
        values[1] = this.ledCurr;
        values[0] = 0.0;
        values[2] = 0.0;
        values[3] = 25.0;
        values[4] = 25.1;
        values[7] = 24.0;
        values[6] = 30.0;
        values[5] = 0.0;
        return new CCOBDataRead(values);
    }

    @Override
    public double getAdcPhotoDiode() throws DriverException {
        return 0.0;
    }

    @Override
    public void ledOn(int led, int on) throws DriverException {
        if (led < 1 || led > 4) {
            this.throwException("Invalid board LED number");
        }
    }

    @Override
    public boolean readButton(int button) throws DriverException {
        if (button < 0 || button > 4) {
            this.throwException("Invalid button number");
        }
        return (button & 1) == 0;
    }

    private void throwException(String msg) throws DriverException {
        throw new DriverException("CCOB error: " + msg);
    }
}

