/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.drivers.CanCBXAI814;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSensor14bits;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class CanOpenThermometer
extends CanOpenSensor14bits
implements Thermometer {
    private double temperature;

    public CanOpenThermometer(CanCBXAI814 adc, int numOfAnalogInput) {
        super(adc, numOfAnalogInput);
    }

    public static double getDoubleValue(int value) {
        double temp = 0.0;
        double voltage = (double)value * 0.3125;
        FCSCst.FCSLOG.debug((Object)("Value read on the ADC = " + value + " voltage = " + voltage + " volts"));
        temp = voltage / 10.0 - 273.15;
        return temp;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Read temperature on the termometer and returns the new value read.")
    public double readTemperature() {
        double voltage = this.adc.readVoltage(this.numOfAnalogInput);
        this.temperature = voltage / 10.0 - 273.15;
        return this.temperature;
    }

    public double readTemperatureFromPDO() {
        this.adc.checkInitialized();
        if (this.adc.transmissionType != 1) {
            throw new RejectedCommandException("Transmission type for Can Open device must be 1");
        }
        try {
            this.adc.tcpProxy.updatePDOData();
            double voltage = (double)this.adc.getInputs()[this.numOfAnalogInput] * 0.3125;
            this.temperature = voltage / 10.0 - 273.15;
        }
        catch (Exception ex) {
            FCSCst.FCSLOG.error((Object)"cannot read temperature via pdos", (Throwable)ex);
        }
        return this.temperature;
    }

    public void postStart() {
        if (this.adc.isBooted()) {
            this.adc.initializeAndCheckHardware();
        }
    }
}

