/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.trendserver;

import java.net.NetworkInterface;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.trendServer.RestServer;
import org.lsst.ccs.localdb.utils.TrendingConnectionUtils;
import org.lsst.ccs.messaging.NetworkUtilities;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertService;

public class RestServerAgent
extends Subsystem
implements HasLifecycle {
    private static final Logger log = Logger.getLogger(RestServerAgent.class.getName());
    private RestServer rs;
    @ConfigurationParameter(isFinal=true)
    private volatile String hostAddr;
    @ConfigurationParameter(isFinal=true)
    private volatile int port = 8080;
    @ConfigurationParameter(isBuild=true)
    private volatile boolean embeddedServer = true;
    private TrendingConnectionUtils connectionUtils;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentPropertiesService agentPropertiesService;

    public RestServerAgent() throws Exception {
        super("rest-server", AgentInfo.AgentType.SERVICE);
        NetworkInterface ne = NetworkInterface.getByName(NetworkUtilities.getMainInterfaceName());
        if (ne.getInterfaceAddresses().size() > 0) {
            this.hostAddr = ne.getInterfaceAddresses().get(0).getAddress().getHostAddress();
            log.log(Level.INFO, "trend server accessible through : {0}", new Object[]{this.hostAddr});
        } else {
            log.log(Level.WARNING, "cannot determine which network address to transmit");
            this.hostAddr = null;
        }
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void build() {
        if (!this.embeddedServer) {
            this.connectionUtils = new TrendingConnectionUtils(this.hostAddr, this.port);
            AgentPeriodicTask checkRest = new AgentPeriodicTask("check-rest", () -> this.checkRest()).withIsFixedRate(true).withPeriod(Duration.ofMinutes(1L));
            ((AgentPeriodicTaskService)this.getAgentService(AgentPeriodicTaskService.class)).scheduleAgentPeriodicTask(checkRest);
        }
        this.agentPropertiesService.setAgentProperty("rest-service-addr", this.hostAddr);
        this.agentPropertiesService.setAgentProperty("rest-service-port", String.valueOf(this.port));
        this.agentPropertiesService.setAgentProperty("rest-service-entrypoint", "/rest/data");
        this.agentPropertiesService.setAgentProperty("agentCategory", AgentCategory.REST_SERVER.name());
    }

    private void checkRest() {
        long start = System.currentTimeMillis();
        boolean raiseAlert = false;
        String cause = null;
        try {
            DataChannel.DataChannelList channels = this.connectionUtils.getChannelList();
            if (channels == null || channels.list.isEmpty()) {
                raiseAlert = true;
                cause = "The Rest-Server returned " + channels == null ? "a null" : "an empty list of channels";
            }
        }
        catch (Exception ex) {
            cause = "An exception was raised by the Rest-Server when fetching the list of channels: " + ex.getMessage();
            raiseAlert = true;
        }
        if (raiseAlert) {
            this.alertService.raiseAlert(new Alert("RestServerUnavailable", "Alert raised when there are problems communicating with the Rest Server."), AlertState.WARNING, cause);
        }
        long delta = System.currentTimeMillis() - start;
        log.log(Level.FINE, "Rest Server Checked in {0} ms", delta);
    }

    public void startAgent() {
        super.startAgent();
        if (this.embeddedServer) {
            this.rs = new RestServer(this.port);
            this.rs.start();
        }
        log.log(Level.INFO, "Rest Server " + (this.embeddedServer ? "started in an embedded" : "running in an external") + " container ({0}:{1})", new Object[]{this.hostAddr, String.valueOf(this.port)});
    }

    public void shutdown() {
        if (this.rs != null) {
            this.rs.stop();
        }
    }
}

