/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.integrationgantrygui;

import java.util.logging.Logger;
import org.lsst.ccs.integrationgantrygui.ScalableImageProvider;

public abstract class ScalingUtils<T> {
    private static final Logger LOG = Logger.getLogger(ScalingUtils.class.getName());
    private int[] counts;
    private int min;
    private int max;

    ScalingUtils(int[] counts) {
        this.counts = counts;
        this.computeMinMax();
    }

    private void computeMinMax() {
        int i;
        for (i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] <= 0) continue;
            this.min = i;
            break;
        }
        for (i = this.counts.length - 1; i >= 0; --i) {
            if (this.counts[i] <= 0) continue;
            this.max = i;
            break;
        }
        LOG.fine(() -> String.format("min=%d max=%d", this.min, this.max));
    }

    private int[] computeCDF() {
        int[] cdf = new int[this.counts.length];
        int cum = 0;
        for (int i = this.min; i <= this.max; ++i) {
            cdf[i] = cum += this.counts[i];
        }
        return cdf;
    }

    T buildArray(T data, int offset, double maxValue, ScalableImageProvider.Scaling scaling) {
        switch (scaling) {
            case LOG: {
                double logScaleFactor = maxValue / Math.log1p(this.max - this.min);
                for (int i = 0; i < this.max - this.min + 1; ++i) {
                    this.setElement(data, this.min + i - offset, Math.log1p(i) * logScaleFactor);
                }
                break;
            }
            case LINEAR: {
                double linearScaleFactor = maxValue / (double)(this.max - this.min);
                for (int i = 0; i < this.max - this.min + 1; ++i) {
                    this.setElement(data, this.min + i - offset, (double)i * linearScaleFactor);
                }
                break;
            }
            case HIST: {
                int[] cdf = this.computeCDF();
                int range = cdf[this.max] - cdf[this.min];
                for (int i = 0; i < this.max - this.min + 1; ++i) {
                    this.setElement(data, this.min + i - offset, (double)(cdf[this.min + i] - cdf[this.min]) * maxValue / (double)range);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Scaling: " + (Object)((Object)scaling));
            }
        }
        return data;
    }

    int getMax() {
        return this.max;
    }

    int getMin() {
        return this.min;
    }

    abstract T buildArray(int var1, ScalableImageProvider.Scaling var2);

    abstract void setElement(T var1, int var2, double var3);

    static class ShortScalingUtils
    extends ScalingUtils<short[]> {
        public ShortScalingUtils(int[] counts) {
            super(counts);
        }

        @Override
        short[] buildArray(int offset, ScalableImageProvider.Scaling scaling) {
            short[] result = new short[this.getMax() + 1 - offset];
            this.buildArray(result, offset, 65535.0, scaling);
            return result;
        }

        @Override
        void setElement(short[] data, int index, double value) {
            data[index] = (short)value;
        }
    }

    static class ByteScalingUtils
    extends ScalingUtils<byte[]> {
        public ByteScalingUtils(int[] counts) {
            super(counts);
        }

        @Override
        byte[] buildArray(int offset, ScalableImageProvider.Scaling scaling) {
            byte[] result = new byte[this.getMax() + 1 - offset];
            this.buildArray(result, offset, 255.0, scaling);
            return result;
        }

        @Override
        void setElement(byte[] data, int index, double value) {
            data[index] = (byte)value;
        }
    }
}

