/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.crypto.util;

import java.io.IOException;
import java.math.BigInteger;
import org.python.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.python.bouncycastle.asn1.x9.X9ECParameters;
import org.python.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.python.bouncycastle.crypto.params.DSAParameters;
import org.python.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.python.bouncycastle.crypto.params.ECDomainParameters;
import org.python.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.python.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.python.bouncycastle.crypto.params.RSAKeyParameters;
import org.python.bouncycastle.crypto.util.SSHBuffer;
import org.python.bouncycastle.crypto.util.SSHBuilder;
import org.python.bouncycastle.math.ec.ECCurve;
import org.python.bouncycastle.math.ec.custom.sec.SecP256R1Curve;
import org.python.bouncycastle.util.Strings;

public class OpenSSHPublicKeyUtil {
    private static final String RSA = "ssh-rsa";
    private static final String ECDSA = "ecdsa";
    private static final String ED_25519 = "ssh-ed25519";
    private static final String DSS = "ssh-dss";

    private OpenSSHPublicKeyUtil() {
    }

    public static AsymmetricKeyParameter parsePublicKey(byte[] byArray) {
        SSHBuffer sSHBuffer = new SSHBuffer(byArray);
        return OpenSSHPublicKeyUtil.parsePublicKey(sSHBuffer);
    }

    public static byte[] encodePublicKey(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("cipherParameters was null.");
        }
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            if (asymmetricKeyParameter.isPrivate()) {
                throw new IllegalArgumentException("RSAKeyParamaters was for encryption");
            }
            BigInteger bigInteger = ((RSAKeyParameters)asymmetricKeyParameter).getExponent();
            BigInteger bigInteger2 = ((RSAKeyParameters)asymmetricKeyParameter).getModulus();
            SSHBuilder sSHBuilder = new SSHBuilder();
            sSHBuilder.writeString(RSA);
            sSHBuilder.rawArray(bigInteger.toByteArray());
            sSHBuilder.rawArray(bigInteger2.toByteArray());
            return sSHBuilder.getBytes();
        }
        if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
            SSHBuilder sSHBuilder = new SSHBuilder();
            String string2 = null;
            if (!(((ECPublicKeyParameters)asymmetricKeyParameter).getParameters().getCurve() instanceof SecP256R1Curve)) {
                throw new IllegalArgumentException("unable to derive ssh curve name for " + ((ECPublicKeyParameters)asymmetricKeyParameter).getParameters().getCurve().getClass().getName());
            }
            string2 = "nistp256";
            sSHBuilder.writeString("ecdsa-sha2-" + string2);
            sSHBuilder.writeString(string2);
            sSHBuilder.rawArray(((ECPublicKeyParameters)asymmetricKeyParameter).getQ().getEncoded(false));
            return sSHBuilder.getBytes();
        }
        if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
            SSHBuilder sSHBuilder = new SSHBuilder();
            sSHBuilder.writeString(DSS);
            sSHBuilder.rawArray(((DSAPublicKeyParameters)asymmetricKeyParameter).getParameters().getP().toByteArray());
            sSHBuilder.rawArray(((DSAPublicKeyParameters)asymmetricKeyParameter).getParameters().getQ().toByteArray());
            sSHBuilder.rawArray(((DSAPublicKeyParameters)asymmetricKeyParameter).getParameters().getG().toByteArray());
            sSHBuilder.rawArray(((DSAPublicKeyParameters)asymmetricKeyParameter).getY().toByteArray());
            return sSHBuilder.getBytes();
        }
        if (asymmetricKeyParameter instanceof Ed25519PublicKeyParameters) {
            SSHBuilder sSHBuilder = new SSHBuilder();
            sSHBuilder.writeString(ED_25519);
            sSHBuilder.rawArray(((Ed25519PublicKeyParameters)asymmetricKeyParameter).getEncoded());
            return sSHBuilder.getBytes();
        }
        throw new IllegalArgumentException("unable to convert " + asymmetricKeyParameter.getClass().getName() + " to private key");
    }

    public static AsymmetricKeyParameter parsePublicKey(SSHBuffer sSHBuffer) {
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        String string2 = Strings.fromByteArray(sSHBuffer.readString());
        if (RSA.equals(string2)) {
            BigInteger bigInteger = sSHBuffer.positiveBigNum();
            BigInteger bigInteger2 = sSHBuffer.positiveBigNum();
            asymmetricKeyParameter = new RSAKeyParameters(false, bigInteger2, bigInteger);
        } else if (DSS.equals(string2)) {
            BigInteger bigInteger = sSHBuffer.positiveBigNum();
            BigInteger bigInteger3 = sSHBuffer.positiveBigNum();
            BigInteger bigInteger4 = sSHBuffer.positiveBigNum();
            BigInteger bigInteger5 = sSHBuffer.positiveBigNum();
            asymmetricKeyParameter = new DSAPublicKeyParameters(bigInteger5, new DSAParameters(bigInteger, bigInteger3, bigInteger4));
        } else if (string2.startsWith(ECDSA)) {
            X9ECParameters x9ECParameters;
            String string3;
            String string4 = string3 = Strings.fromByteArray(sSHBuffer.readString());
            if (string3.startsWith("nist")) {
                string4 = string3.substring(4);
                string4 = string4.substring(0, 1) + "-" + string4.substring(1);
            }
            if ((x9ECParameters = ECNamedCurveTable.getByName(string4)) == null) {
                throw new IllegalStateException("unable to find curve for " + string2 + " using curve name " + string4);
            }
            ECCurve eCCurve = x9ECParameters.getCurve();
            byte[] byArray = sSHBuffer.readString();
            asymmetricKeyParameter = new ECPublicKeyParameters(eCCurve.decodePoint(byArray), new ECDomainParameters(eCCurve, x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed()));
        } else if (string2.startsWith(ED_25519)) {
            asymmetricKeyParameter = new Ed25519PublicKeyParameters(sSHBuffer.readString(), 0);
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("unable to parse key");
        }
        if (sSHBuffer.hasRemaining()) {
            throw new IllegalArgumentException("uncoded key has trailing data");
        }
        return asymmetricKeyParameter;
    }
}

