/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnDevice;

public class ForceSensor
implements SensorPluggedOnDevice {
    @LookupName
    private String name = "unset";
    private int voltage;
    @ConfigurationParameter
    protected volatile String deviceName;
    @ConfigurationParameter
    protected volatile int byteNumero;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getByteNumero() {
        return this.byteNumero;
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public void updateValue(int newValue) {
        FCSCst.FCSLOG.info((Object)(this.name + " updating voltage = " + newValue));
        this.voltage = newValue;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Returns force sensor analog Value. No unit.")
    public int getVoltage() {
        return this.voltage;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns a string representation of ForceSensor")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/deviceName=");
        sb.append(this.deviceName);
        sb.append("/byteNumero=");
        sb.append(String.valueOf(this.byteNumero));
        sb.append("/voltage=");
        sb.append(String.valueOf(this.voltage));
        return sb.toString();
    }
}

