/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.thorlabs;

import java.util.Date;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.thorlabs.ThorlabsSC10;

public class TestSC10 {
    private final ThorlabsSC10 thsc = new ThorlabsSC10();

    @Command(name="timestamp", description="Prints current time")
    public String timestamp() {
        Date now = new Date();
        return now.toString();
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="ident", description="Identification") String ident, @Argument(name="baudRate", description="Baud rate, 9600 or 115200") int baudRate) throws DriverException {
        this.thsc.open(ident, baudRate);
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="ident", description="Identification") String ident) throws DriverException {
        this.thsc.open(ident);
    }

    @Command(name="close", description="Closes connection to device")
    public void close() throws DriverException {
        this.thsc.close();
    }

    @Command(name="readAll", description="Read all controller settings and data")
    public String readAll() {
        String table = "Read all shutter settings and data\n" + this.timestamp() + "\n";
        ThorlabsSC10.CmndSC[] cmndN = ThorlabsSC10.CmndSC.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            table = table + String.format("\n   %-22s", new Object[]{cmndN[i]});
            try {
                String respN = this.thsc.querySC(cmndN[i]);
                table = table + respN;
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        return table;
    }

    @Command(name="readSCpos", description="Read shutter position, <0|1> = <open|closed>")
    public String readSCpos() throws DriverException {
        return this.thsc.querySC(ThorlabsSC10.CmndSC.CLOSED) + "   (<0|1>  = <open|closed>)";
    }

    @Command(name="readMode", description="Decode operation and trigger modes")
    public String readMode() throws DriverException {
        String opstring = ThorlabsSC10.OpMode.decode(this.thsc.querySC(ThorlabsSC10.CmndSC.OPERATING_MODE));
        String trstring = ThorlabsSC10.TrigMode.decode(this.thsc.querySC(ThorlabsSC10.CmndSC.TRIGGER_MODE));
        return "Operating Mode = " + opstring + ",  Trigger Mode = " + trstring;
    }

    @Command(name="listOpModes", description="List option codes for operating modes")
    public String listOpModes() {
        return ThorlabsSC10.OpMode.listModes();
    }

    @Command(name="setTrigMode", description="Set trigger mode")
    public void setTrigMode(@Argument(name="<0|1>", description="trigger mode <internal|external>") int value) throws DriverException {
        this.thsc.setSC(ThorlabsSC10.CmndSC.TRIGGER_MODE, value);
    }

    @Command(name="setOpMode", description="Set operating mode")
    public void setOpMode(@Argument(name="<1|2|3|4|5>", description="operating mode (issue listOpModes for meanings)") int value) throws DriverException {
        this.thsc.setSC(ThorlabsSC10.CmndSC.OPERATING_MODE, value);
    }

    @Command(name="setOutputTrig", description="Set trigger mode")
    public void setOutputTrig(@Argument(name="<0|1>", description="trigger output follows <shutter|controller>") int value) throws DriverException {
        this.thsc.setSC(ThorlabsSC10.CmndSC.TRIG_OUT_MODE, value);
    }

    @Command(name="setRepeatCount", description="Set count for repeat mode")
    public void setRepeatCount(@Argument(name="1-99 repeats", description="in REPEAT mode") int value) throws DriverException {
        this.thsc.setSC(ThorlabsSC10.CmndSC.REPEAT_COUNT, value);
    }

    @Command(name="setOpenDuration", description="Set shutter-open duration")
    public void setOpenDuration(@Argument(name="1-999999 ms", description="shutter-open duration if SINGLE, REPEAT, AUTO") int value) throws DriverException {
        this.thsc.setSC(ThorlabsSC10.CmndSC.OPEN_DURATION, value);
    }

    @Command(name="setClosedDuration", description="Set shutter-closed duration")
    public void setClosedDuration(@Argument(name="1-999999 ms", description="shutter-closed duration if REPEAT or AUTO mode") int value) throws DriverException {
        this.thsc.setSC(ThorlabsSC10.CmndSC.SHUT_DURATION, value);
    }

    @Command(name="toggleEnable", description="Initiate an internal trig or enable external trig")
    public void toggleEnable() throws DriverException {
        this.thsc.enable();
    }

    @Command(name="setDataRate", description="Set baud rate.  Danger: last-resort reset only!")
    public void setDataRate(@Argument(name=" <0|1>", description="baud rate <9600|115200>") int value) throws DriverException {
        this.thsc.setSC(ThorlabsSC10.CmndSC.DATA_RATE, value);
    }

    @Command(name="saveSettings", description="Save some settings to non-volatile flash memory")
    public void saveSettings() throws DriverException {
        this.thsc.saveSC();
    }

    @Command(name="saveToProm", description="Save some settings to EEPROM")
    public void saveToProm() throws DriverException {
        this.thsc.saveProm();
    }

    @Command(name="loadFromProm", description="Load settings stored in EEPROM")
    public void loadFromProm() throws DriverException {
        this.thsc.loadProm();
    }

    @Command(name="setDebug", description="set debug mode <true|false>")
    public void setDebug(@Argument(name="<true|false>", description="debug mode") boolean mode) {
        this.thsc.setDebug(mode);
    }
}

