import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.refrig.RefrigMain
import org.lsst.ccs.subsystem.refrig.ColdCompressor
import org.lsst.ccs.subsystem.refrig.CompSimPlutoDevice
import org.lsst.ccs.subsystem.refrig.CompSimMaq20Device
import org.lsst.ccs.subsystem.refrig.CompMaq20Device
import org.lsst.ccs.subsystem.refrig.SimA1000Device
import org.lsst.ccs.subsystem.refrig.CryoCompressor
import org.lsst.ccs.subsystem.refrig.SubCoolingChannel
import org.lsst.ccs.monitor.Channel

numCold = 2
coldNames = ["Cold1", "Cold2"]
numCryo = 6
cryoNames = ["Cryo5", "Cryo6", "Cryo4", "Cryo3", "Cryo2", "Cryo1"]

CCSBuilder builder = ["refrig-sim"]

builder.main (RefrigMain) {

    for (j = 0; j < numCold; j++) {

        comp = coldNames[j]
        "$comp" (ColdCompressor, discTempChan: "DischrgTmp_P", discPressChan: "DischrgPrs",
                 suctTempChan: "SuctionTmp_P", cmprPowerChan: "CompPower", liquidTempChan: "LiquidTmp_P") {

            Plc (CompSimPlutoDevice)

            Maq20 (CompSimMaq20Device)

            Vfd (SimA1000Device)

            plc = "$comp/Plc"
            maq20 = "$comp/Maq20"
            vfd = "$comp/Vfd"

            DischrgTmp_P (Channel, description: "Discharge Temperature (PLC)", units: "\u00b0C", format: ".1f",
                          devcName: plc, hwChan: 1, type: "ADDREG:0")

            DischrgTmp_M (Channel, description: "Discharge Temperature (Maq20)", units: "\u00b0C", format: ".1f",
                          devcName: maq20, hwChan: 3, type: "0", subtype: "T220")

            DischrgPrs   (Channel, description: "Discharge Pressure", units: "psia", format: ".1f",
                          devcName: plc, hwChan: 1, type: "ADDREG:3")

            SuctionTmp_P (Channel, description: "Suction Temperature (PLC)", units: "\u00b0C", format: ".1f",
                          devcName: plc, hwChan: 1, type: "ADDREG:1")

            SuctionTmp_M (Channel, description: "Suction Temperature (Maq20)", units: "\u00b0C", format: ".1f",
                          devcName: maq20, hwChan: 2, type: "0", subtype: "T220")

            SuctionPrs   (Channel, description: "Suction Pressure", units: "psia", format: ".1f",
                          devcName: plc, hwChan: 1, type: "ADDREG:4")

            LiquidTmp_P  (Channel, description: "Liquid Temperature (PLC)", units: "\u00b0C", format: ".1f",
                          devcName: plc, hwChan: 1, type: "ADDREG:2")

            LiquidTmp_M  (Channel, description: "Liquid Temperature (Maq20)", units: "\u00b0C", format: ".1f",
                          devcName: maq20, hwChan: 1, type: "0", subtype: "T220")

            CompVoltage  (Channel, description: "Compressor Voltage", units: "Volts", format: ".1f",
                          devcName: plc, hwChan: 1, type: "ADDREG:6")

            CompCurrent  (Channel, description: "Compressor Current", units: "Amps", format: ".1f",
                          devcName: plc, hwChan: 1, type: "ADDREG:5")

            CompPower    (Channel, description: "Compressor Power", units: "VA", format: ".1f",
                          devcName: plc, hwChan: 0, type: "ADDINT:9")

            CompVfdVolt  (Channel, description: "Compressor VFD Voltage", units: "Volts", format: ".1f",
                          devcName: vfd, hwChan: SimA1000Device.CHAN_VOLTAGE)

            CompVfdCurr  (Channel, description: "Compressor VFD Current", units: "Amps", format: ".1f",
                          devcName: vfd, hwChan: SimA1000Device.CHAN_CURRENT)

            CompVfdFreq  (Channel, description: "Compressor VFD Frequency", units: "Hz", format: ".1f",
                          devcName: vfd, hwChan: SimA1000Device.CHAN_FREQUENCY)

            HGBValvePosn (Channel, description: "HGB Valve Position", units: "%", format: ".1f",
                          devcName: maq20, hwChan: CompMaq20Device.CHAN_BYPASS_VALVE, type: "3", scale: 10.0)

            CoolValvePosn (Channel, description: "Coolant Valve Position", units: "%", format: ".1f",
                           devcName: maq20, hwChan: CompMaq20Device.CHAN_COOLANT_VALVE, type: "3", scale: 10.0)

            WaterInTmp   (Channel, description: "Water Inlet Temperature", units: "\u00b0C", format: ".1f",
                          devcName: maq20, hwChan: 0, type: "0", subtype: "T220")

            WaterOutTmp  (Channel, description: "Water Outlet Temperature", units: "\u00b0C", format: ".1f",
                          devcName: maq20, hwChan: 4, type: "0", subtype: "T220")

            CabinetTmp   (Channel, description: "Cabinet Temperature", units: "\u00b0C", format: ".1f",
                          devcName: maq20, hwChan: 6, type: "0", subtype: "T220")

            AmbientTmp   (Channel, description: "Ambient Temperature", units: "\u00b0C", format: ".1f",
                          devcName: maq20, hwChan: 5, type: "0", subtype: "T220")

            LiquidSubCooling   (SubCoolingChannel, description: "$comp SubCooling", units: "\u00b0C", format: ".2f",
                        dischargePressureChannel: ref("$comp/DischrgPrs"), liquidTempChannel:ref("$comp/LiquidTmp_M"))

        }
    }

    for (j = 0; j < numCryo; j++) {

        comp = cryoNames[j]
        "$comp" (CryoCompressor, discTempChan: "DischrgTmp_P", discPressChan: "DischrgPrs", suctTempChan: "SuctionTmp_P",
                 suctPressChan: "SuctionPrs", cmprPowerChan: "CompPower", phaseSepTempChan: "PhaseSepTmp") {

            Plc (CompSimPlutoDevice)

            Maq20 (CompSimMaq20Device)

            plc = "$comp/Plc"
            maq20 = "$comp/Maq20"

            DischrgTmp_P (Channel, description: "Discharge Temperature (PLC)", units: "\u00b0C", format: ".1f",
                          devcName: plc, hwChan: 1, type: "ADDREG:0")

            DischrgTmp_M (Channel, description: "Discharge Temperature (MAQ20)", units: "\u00b0C", format: ".1f",
                          devcName: maq20, hwChan: 3, type: "0", subtype: "T220")

            DischrgPrs   (Channel, description: "Discharge Pressure", units: "psia", format: ".1f",
                          devcName: plc, hwChan: 1, type: "ADDREG:3")

            SuctionTmp_P (Channel, description: "Suction Temperature (PLC)", units: "\u00b0C", format: ".1f",
                          devcName: plc, hwChan: 1, type: "ADDREG:1")

            SuctionTmp_M (Channel, description: "Suction Temperature (MAQ20)", units: "\u00b0C", format: ".1f",
                          devcName: maq20, hwChan: 2, type: "0", subtype: "T220")

            SuctionPrs   (Channel, description: "Suction Pressure", units: "psia", format: ".1f",
                          devcName: plc, hwChan: 1, type: "ADDREG:4")

            OilLevel     (Channel, description: "Oil Level", units: "mm", format: ".1f",
                          devcName: plc, hwChan: 1, type: "ADDREG:2")

            CompVoltage  (Channel, description: "Compressor Voltage", units: "Volts", format: ".1f",
                          devcName: plc, hwChan: 1, type: "ADDREG:6")

            CompCurrent  (Channel, description: "Compressor Current", units: "Amps", format: ".1f",
                          devcName: plc, hwChan: 1, type: "ADDREG:5")

            CompPower    (Channel, description: "Compressor Power", units: "VA", format: ".1f",
                          devcName: plc, hwChan: 0, type: "ADDINT:9")

            WaterInTmp   (Channel, description: "Water Inlet Temperature", units: "\u00b0C", format: ".1f",
                          devcName: maq20, hwChan: 0, type: "0", subtype: "T220")

            WaterOutTmp  (Channel, description: "Water Outlet Temperature", units: "\u00b0C", format: ".1f",
                          devcName: maq20, hwChan: 4, type: "0", subtype: "T220")

            AfterCoolTmp (Channel, description: "After Cooler Temperature", units: "\u00b0C", format: ".1f",
                          devcName: maq20, hwChan: 1, type: "0", subtype: "T220")

            PhaseSepTmp  (Channel, description: "Phase Separator Temperature", units: "\u00b0C", format: ".1f",
                          devcName: maq20, hwChan: 5, type: "0", subtype: "T220")

            OilSepTmp    (Channel, description: "Oil Separator Temperature", units: "\u00b0C", format: ".1f",
                          devcName: maq20, hwChan: 6, type: "0", subtype: "T220")

            SurgeTankTmp (Channel, description: "Surge Tank Temperature", units: "\u00b0C", format: ".1f",
                          devcName: maq20, hwChan: 7, type: "0", subtype: "T220")

            if (j % 3 == 0) {
                CabinetTmp (Channel, description: "Cabinet Temperature", units: "\u00b0C", format: ".1f",
                            devcName: maq20, hwChan: 1, type: "1", subtype: "T220")

                AmbientTmp (Channel, description: "Ambient Temperature", units: "\u00b0C", format: ".1f",
                            devcName: maq20, hwChan: 0, type: "1", subtype: "T220")
            }

        }

    }

}
