/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForCarousel;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;

public class CanOpenEPOSCarousel
extends CanOpenEPOS
implements EPOSControllerForCarousel {
    protected int cobid1;
    protected int cobid2;
    private long pdo1;
    private long pdo2;

    public CanOpenEPOSCarousel(int nodeID, String serialNB) {
        super(nodeID, serialNB);
        this.cobid1 = this.nodeID + 384;
        this.cobid2 = this.nodeID + 640;
        this.pdo1 = 0L;
        this.pdo2 = 0L;
    }

    public void setPdo1(long pdo1) {
        this.pdo1 = pdo1;
    }

    public void setPdo2(long pdo2) {
        this.pdo2 = pdo2;
    }

    public long getPdo1() {
        return this.pdo1;
    }

    public long getPdo2() {
        return this.pdo2;
    }

    public int getCobid1() {
        return this.cobid1;
    }

    public int getCobid2() {
        return this.cobid2;
    }

    @Override
    public void doInitializePDOs() throws DriverException {
        this.tcpProxy.addReceivedPDO(this.cobid1);
        this.tcpProxy.addReceivedPDO(this.cobid2);
    }

    @Override
    public void updateFromPDO(PDOData pdo) {
        FCSCst.FCSLOG.finest((Object)(this.name + " updatingFromPDO = " + pdo));
        boolean updated = false;
        if (pdo.getPDOs().containsKey(this.cobid1)) {
            this.pdo1 = (Long)pdo.getPDOs().get(this.cobid1);
            updated = true;
            FCSCst.FCSLOG.info((Object)(this.name + " updatingFromPDO1 = " + this.pdo1 + " binaire:" + Long.toBinaryString(this.pdo1)));
            this.statusWord = CanOpenEPOSCarousel.extractStatusWord(this.pdo1);
            this.current = (short)CanOpenEPOSCarousel.extractCurrentAverage(this.pdo1);
            this.position = CanOpenEPOSCarousel.extractPosition(this.pdo1);
            FCSCst.FCSLOG.info((Object)(this.name + " position = " + this.position + " pdo1 =  binaire:" + Long.toBinaryString(this.pdo1)));
        }
        if (pdo.getPDOs().containsKey(this.cobid2)) {
            this.pdo2 = (Long)pdo.getPDOs().get(this.cobid2);
            updated = true;
            FCSCst.FCSLOG.info((Object)(this.name + " updatingFromPDO2 = " + this.pdo2 + " binaire:" + Long.toBinaryString(this.pdo2)));
            this.followingError = (short)CanOpenEPOSCarousel.extractFollowingError(this.pdo2);
            this.velocity = CanOpenEPOSCarousel.extractVelocity(this.pdo2);
        }
        if (updated) {
            this.publishData();
        }
    }

    public static int extractStatusWord(long pdo) {
        return (int)pdo & 0xFFFF;
    }

    public static int extractCurrentAverage(long pdo) {
        return (int)(pdo >> 16) & 0xFFFF;
    }

    public static int extractPosition(long pdo) {
        return (int)(pdo >> 32) & 0xFFFFFFFF;
    }

    public static int extractFollowingError(long pdo) {
        return (int)(pdo >> 16) & 0xFFFF;
    }

    public static int extractVelocity(long pdo) {
        return (int)(pdo >> 32) & 0xFFFFFFFF;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="print values updated by PDOs to debug and test")
    public String printValuesUpdatedByPDOs() {
        StringBuilder sb = new StringBuilder("=> pdo1 value = ");
        sb.append(this.pdo1);
        sb.append(" / pdo1 = 0x");
        sb.append(Long.toHexString(this.pdo1));
        sb.append(" / status word = 0x");
        sb.append(Long.toHexString(this.statusWord));
        sb.append("\n status word = 0b");
        sb.append(Long.toBinaryString(this.statusWord));
        sb.append("\n current average = ");
        sb.append(this.current);
        sb.append(" / current average = 0x");
        sb.append(Long.toHexString(this.current));
        sb.append("\n position = ");
        sb.append(this.position);
        sb.append(" / position = 0x");
        sb.append(Long.toHexString(this.position));
        sb.append("\n => pdo2 value = ");
        sb.append(this.pdo2);
        sb.append(" / pdo2 = 0x");
        sb.append(Long.toHexString(this.pdo2));
        sb.append("\n followingError = ");
        sb.append(this.followingError);
        sb.append(" / followingError = 0x");
        sb.append(Long.toHexString(this.followingError));
        sb.append(this.followingError);
        sb.append("\n Velocity = ");
        sb.append(this.velocity);
        sb.append(" / velocity = 0x");
        sb.append(Long.toHexString(this.velocity));
        return sb.toString();
    }
}

