/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.parker;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.parker.AcrComm;
import org.lsst.ccs.drivers.parker.AxisBit;
import org.lsst.ccs.drivers.parker.AxisLong;
import org.lsst.ccs.drivers.parker.AxisName;
import org.lsst.ccs.drivers.parker.AxisSingle;
import org.lsst.ccs.drivers.parker.AxisUnsigned;
import org.lsst.ccs.drivers.parker.ConnectionName;
import org.lsst.ccs.drivers.parker.ConnectionUnsigned;
import org.lsst.ccs.drivers.parker.ControllerType;
import org.lsst.ccs.drivers.parker.EncoderLong;
import org.lsst.ccs.drivers.parker.EncoderName;
import org.lsst.ccs.drivers.parker.LocalDouble;
import org.lsst.ccs.drivers.parker.LocalDoubleArray;
import org.lsst.ccs.drivers.parker.LocalLong;
import org.lsst.ccs.drivers.parker.LocalLongArray;
import org.lsst.ccs.drivers.parker.LocalSingle;
import org.lsst.ccs.drivers.parker.LocalSingleArray;
import org.lsst.ccs.drivers.parker.LocalString;
import org.lsst.ccs.drivers.parker.LocalStringArray;
import org.lsst.ccs.drivers.parker.MasterBit;
import org.lsst.ccs.drivers.parker.MasterName;
import org.lsst.ccs.drivers.parker.MasterUnsigned;
import org.lsst.ccs.drivers.parker.ProgramName;
import org.lsst.ccs.drivers.parker.SystemBit;
import org.lsst.ccs.drivers.parker.SystemUnsigned;
import org.lsst.ccs.drivers.parker.UserParameter;

public class TestAcrComm {
    private static final AcrComm[] acr = new AcrComm[]{null};
    private static final MasterName[] MASTER_NAMES = MasterName.values();
    private static final EncoderName[] ENCODER_NAMES = EncoderName.values();
    private static final AxisName[] AXIS_NAMES = AxisName.values();
    private static final ConnectionName[] CONNECTION_NAMES = ConnectionName.values();
    private static final ProgramName[] PROGRAM_NAMES = ProgramName.values();
    private static final UserParameter[] USER_PARAMETERS = UserParameter.values();
    private static final Map<String, BiConsumer<AxisName, String>> AXIS_SETTERS;
    private static final Map<String, BiConsumer<MasterName, String>> MASTER_SETTERS;
    private static final Map<String, BiConsumer<EncoderName, String>> ENCODER_SETTERS;
    private static final Map<String, Consumer<String>> SYSTEM_SETTERS;
    private static final Map<String, Consumer<ProgramName>> PROGRAM_GETTERS;
    private static final Map<String, BiConsumer<ProgramName, String[]>> PROGRAM_SETTERS;

    @Command(name="open", description="Open connections to the controller.")
    public void open_command(@Argument(name="controllerType", description="The type of ACR controller.") ControllerType ctrlType, @Argument(name="controllerHostname", description="The hostname or dotted IP address of the controller.") String controllerHost) throws Exception {
        if (acr[0] != null) {
            System.out.println("Closing the active connection.");
            this.close_command();
        }
        TestAcrComm.acr[0] = AcrComm.newInstance(ctrlType, controllerHost, Optional.of(System.out));
    }

    @Command(name="close", description="Close the current connection, if any, to the controller.")
    public void close_command() {
        if (acr[0] != null) {
            acr[0].cleanup();
            TestAcrComm.acr[0] = null;
        }
    }

    @Command(name="showGlobals", description="Show all the global parameters and flags supported by the Parker driver.")
    public void showGlobals_command() {
        if (acr[0] == null) {
            System.out.println("Use the 'open' command first!");
            return;
        }
        this.showGlobals();
    }

    @Command(name="showSystem", description="Show all system-level parameters supported by the Parker driver.")
    public void showSystem_command() {
        if (acr[0] == null) {
            System.out.println("Use the 'open' command first!");
            return;
        }
        this.showSystem();
    }

    @Command(name="showMaster", description="Show the master-level parameters for a given master.")
    public void showMaster_command(@Argument(name="masterNumber", description="The master's index number.") int masterNum) {
        if (acr[0] == null) {
            System.out.println("Use the 'open' command first!");
            return;
        }
        MasterName master = this.convertMasterNumber(masterNum);
        if (master != null) {
            this.showMaster(master);
        }
    }

    @Command(name="showEncoder", description="Show the encoder-level parameters for a given encoder.")
    public void showEncoder_command(@Argument(name="encoderNumber", description="The encoder's index number.") int encoderNum) {
        if (acr[0] == null) {
            System.out.println("Use the 'open' command first!");
            return;
        }
        EncoderName encoder = this.convertEncoderNumber(encoderNum);
        if (encoder != null) {
            this.showEncoder(encoder);
        }
    }

    @Command(name="showAxis", description="Show the axis-level parameters for a given axis.")
    public void showAxis_command(@Argument(name="axisNumber", description="The axis' index number.") int axisNum) {
        if (acr[0] == null) {
            System.out.println("Use the 'open' command first!");
            return;
        }
        AxisName axis = this.convertAxisNumber(axisNum);
        if (axis != null) {
            this.showAxis(axis);
        }
    }

    @Command(name="showConnection", description="Show the connection-level parameters for a given connection.")
    public void showConnection_command(@Argument(name="connectionNumber", description="The connection's index number.") int connectionNum) {
        if (acr[0] == null) {
            System.out.println("Use the 'open' command first!");
            return;
        }
        ConnectionName connection = this.convertConnectionNumber(connectionNum);
        if (connection != null) {
            this.showConnection(connection);
        }
    }

    @Command(name="showUser", description="Show all user parameters.")
    public void showUser_command() {
        if (acr[0] == null) {
            System.out.println("Use the 'open' command first!");
            return;
        }
        this.showUser();
    }

    @Command(name="showProgram", description="Show a local variable of a program.")
    public void showProgram_command(@Argument(name="programNumber", description="The program's index number.") int programNum, @Argument(name="varName", description="The name of the variable, for example LV0, SA1, etc.") String varName) {
        if (acr[0] == null) {
            System.out.println("Use the 'open' command first!");
            return;
        }
        ProgramName program = this.convertProgramNumber(programNum);
        Consumer<ProgramName> getter = this.programGetter(varName);
        if (program != null && getter != null) {
            getter.accept(program);
        }
    }

    @Command(name="setSystem", description="Set a system parameter/flag.")
    public void setSystem_command(@Argument(name="paramName", description="The name of the system parameter/flag to set.") String paramName, @Argument(name="newValue", description="The new value for the parameter/flag.") String newValue) {
        if (acr[0] == null) {
            System.out.println("Use the 'open' command first!");
            return;
        }
        Consumer<String> setter = this.systemSetter(paramName);
        if (setter != null) {
            setter.accept(newValue);
        }
    }

    @Command(name="setMaster", description="Set a master parameter/flag.")
    public void setMaster_command(@Argument(name="masterNumber", description="The index number of the target master.") int masterNum, @Argument(name="paramName", description="The name of the master parameter/flag to set.") String paramName, @Argument(name="newValue", description="The new value for the parameter/flag.") String newValue) {
        if (acr[0] == null) {
            System.out.println("Use the 'open' command first!");
            return;
        }
        MasterName master = this.convertMasterNumber(masterNum);
        BiConsumer<MasterName, String> setter = this.masterSetter(paramName);
        if (master != null && setter != null) {
            setter.accept(master, newValue);
        }
    }

    @Command(name="setAxis", description="Set an axis parameter/flag.")
    public void setAxis_command(@Argument(name="axisNumber", description="The index number of the target axis.") int axisNum, @Argument(name="paramName", description="The name of the axis parameter/flag to set.") String paramName, @Argument(name="newValue", description="The new value for the parameter/flag.") String newValue) {
        if (acr[0] == null) {
            System.out.println("Use the 'open' command first!");
            return;
        }
        AxisName axis = this.convertAxisNumber(axisNum);
        BiConsumer<AxisName, String> setter = this.axisSetter(paramName);
        if (axis != null && setter != null) {
            setter.accept(axis, newValue);
        }
    }

    @Command(name="setUser", description="Set a user parameter.")
    public void setUser_command(@Argument(name="userNumber", description="The index of the user parameter to set.") int userNum, @Argument(name="newValue", description="The new value of the parameter.") String newValue) {
        if (acr[0] == null) {
            System.out.println("Use the 'open' command first!");
            return;
        }
        UserParameter user = this.convertUserNumber(userNum);
        double[] decoded = TestAcrComm.decodeSingles(newValue);
        if (user != null && decoded.length == 1) {
            acr[0].set(user, decoded[0]);
        }
    }

    @Command(name="setProgram", description="Set a local variable in a program.")
    public void setProgram_command(@Argument(name="programNumber", description="The index number of the target program.") int programNum, @Argument(name="varName", description="The name of the local variable to set.") String varName, String ... newValue) {
        if (acr[0] == null) {
            System.out.println("Use the 'open' command first!");
            return;
        }
        ProgramName program = this.convertProgramNumber(programNum);
        BiConsumer<ProgramName, String[]> setter = this.programSetter(varName, newValue);
        if (program != null && setter != null) {
            setter.accept(program, newValue);
        }
    }

    @Command(name="send", description="Send AcroBasic commands to the controller and display the reply.")
    public void send_command(String ... word) {
        if (acr[0] == null) {
            System.out.println("Use the 'open' command first!");
            return;
        }
        String command = Arrays.stream(word).collect(Collectors.joining(" "));
        acr[0].sendStr(command);
    }

    private void showGlobals() {
        System.out.println("\nsection: System parameters and bits");
        this.showSystem();
        System.out.println("\nsection: Master parameters and bits");
        for (MasterName masterName : MasterName.values()) {
            this.showMaster(masterName);
        }
        System.out.println("\nsection: Encoder parameters and bits");
        for (Enum enum_ : EncoderName.values()) {
            this.showEncoder((EncoderName)enum_);
        }
        System.out.println("\nsection: Axis parameters and bits");
        for (Enum enum_ : AxisName.values()) {
            this.showAxis((AxisName)enum_);
        }
        System.out.println("\nsection: Connection parameters");
        for (Enum enum_ : ConnectionName.values()) {
            this.showConnection((ConnectionName)enum_);
        }
        System.out.println("\nsection: User parameters");
        this.showUser();
    }

    private void showSystem() {
        String line;
        for (SystemUnsigned systemUnsigned : SystemUnsigned.values()) {
            line = String.format("value: %10s %20d %s", systemUnsigned.reference(), acr[0].get(systemUnsigned), systemUnsigned.name());
            System.out.println(line);
        }
        for (Enum enum_ : SystemBit.values()) {
            line = String.format("value: %10s %20b %s", ((SystemBit)enum_).reference(), acr[0].get((SystemBit)enum_), enum_.name());
            System.out.println(line);
        }
    }

    private void showMaster(MasterName master) {
        String line;
        System.out.println("master: " + master.index());
        for (MasterUnsigned masterUnsigned : MasterUnsigned.values()) {
            line = String.format("value: %10s %20d %s", masterUnsigned.reference(master), acr[0].get(master, masterUnsigned), masterUnsigned.name());
            System.out.println(line);
        }
        for (Enum enum_ : MasterBit.values()) {
            line = String.format("value: %10s %20b %s", ((MasterBit)enum_).reference(master), acr[0].get(master, (MasterBit)enum_), enum_.name());
            System.out.println(line);
        }
    }

    private void showEncoder(EncoderName encoder) {
        System.out.println("encoder: " + encoder.index());
        for (EncoderLong x : EncoderLong.values()) {
            String line = String.format("value: %10s %20d %s", x.reference(encoder), acr[0].get(encoder, x), x.name());
            System.out.println(line);
        }
    }

    private void showAxis(AxisName axis) {
        String line;
        System.out.println("axis: " + axis.index());
        for (AxisUnsigned axisUnsigned : AxisUnsigned.values()) {
            line = String.format("value: %10s %20d %s", axisUnsigned.reference(axis), acr[0].get(axis, axisUnsigned), axisUnsigned.name());
            System.out.println(line);
        }
        for (Enum enum_ : AxisLong.values()) {
            line = String.format("value: %10s %20d %s", ((AxisLong)enum_).reference(axis), acr[0].get(axis, (AxisLong)enum_), enum_.name());
            System.out.println(line);
        }
        for (Enum enum_ : AxisSingle.values()) {
            line = String.format("value: %10s %20e %s", ((AxisSingle)enum_).reference(axis), acr[0].get(axis, (AxisSingle)enum_), enum_.name());
            System.out.println(line);
        }
        for (Enum enum_ : AxisBit.values()) {
            line = String.format("value: %10s %20b %s", ((AxisBit)enum_).reference(axis), acr[0].get(axis, (AxisBit)enum_), enum_.name());
            System.out.println(line);
        }
    }

    private void showConnection(ConnectionName conn) {
        System.out.println("connection: " + conn.index());
        for (ConnectionUnsigned x : ConnectionUnsigned.values()) {
            String line = String.format("value: %10s %20d %s", x.reference(conn), acr[0].get(conn, x), x.name());
            System.out.println(line);
        }
    }

    private void showUser() {
        for (UserParameter user : UserParameter.values()) {
            String line = String.format("value: %10s %20e %s", user.reference(), acr[0].get(user), user.name());
            System.out.println(line);
        }
    }

    private MasterName convertMasterNumber(int masterNum) {
        MasterName result = null;
        if (masterNum < 0 | masterNum >= MASTER_NAMES.length) {
            System.out.println("Invalid master number. Use 0-" + (MASTER_NAMES.length - 1) + ".");
        } else {
            result = MASTER_NAMES[masterNum];
        }
        return result;
    }

    private EncoderName convertEncoderNumber(int encoderNum) {
        EncoderName result = null;
        if (encoderNum < 0 | encoderNum >= ENCODER_NAMES.length) {
            System.out.println("Invalid encoder number. Use 0-" + (ENCODER_NAMES.length - 1) + ".");
        } else {
            result = ENCODER_NAMES[encoderNum];
        }
        return result;
    }

    private AxisName convertAxisNumber(int axisNum) {
        AxisName result = null;
        if (axisNum < 0 | axisNum >= AXIS_NAMES.length) {
            System.out.println("Invalid axis number. Use 0-" + (AXIS_NAMES.length - 1) + ".");
        } else {
            result = AXIS_NAMES[axisNum];
        }
        return result;
    }

    private ConnectionName convertConnectionNumber(int connectionNum) {
        ConnectionName result = null;
        if (connectionNum < 0 | connectionNum >= CONNECTION_NAMES.length) {
            System.out.println("Invalid connection number. Use 0-" + (CONNECTION_NAMES.length - 1) + ".");
        } else {
            result = CONNECTION_NAMES[connectionNum];
        }
        return result;
    }

    private ProgramName convertProgramNumber(int programNum) {
        ProgramName result = null;
        if (programNum < 0 | programNum >= PROGRAM_NAMES.length) {
            System.out.println("Invalid program number. Use 0-" + (PROGRAM_NAMES.length - 1) + ".");
        } else {
            result = PROGRAM_NAMES[programNum];
        }
        return result;
    }

    private UserParameter convertUserNumber(int userNum) {
        UserParameter result = null;
        if (userNum < 0 | userNum >= USER_PARAMETERS.length) {
            System.out.println("Invalid user parameter number. Use 0-" + (USER_PARAMETERS.length - 1) + ".");
        } else {
            result = USER_PARAMETERS[userNum];
        }
        return result;
    }

    private static double[] decodeSingles(String ... value) {
        double[] result = Arrays.stream(value).map(val -> {
            Double decoded = null;
            try {
                decoded = Double.valueOf(val);
            }
            catch (NumberFormatException exc) {
                System.out.println("Invalid floating-point value: " + val);
            }
            return decoded;
        }).filter(val -> val != null).mapToDouble(Double::doubleValue).toArray();
        return result;
    }

    private static long[] decodeLongs(String ... value) {
        long[] result = Arrays.stream(value).map(val -> {
            Long decoded = null;
            try {
                decoded = Long.valueOf(val);
            }
            catch (NumberFormatException exc) {
                System.out.println("Invalid integer: " + val);
            }
            return decoded;
        }).filter(val -> val != null).filter(val -> {
            if (val < Integer.MIN_VALUE | val > Integer.MAX_VALUE) {
                System.out.println("Too big to fit in 31 bits + sign: " + val);
                return false;
            }
            return true;
        }).mapToLong(Long::longValue).toArray();
        return result;
    }

    private static long[] decodeUnsigneds(String ... value) {
        long[] result = Arrays.stream(value).map(val -> {
            Long decoded = null;
            try {
                decoded = Long.valueOf(val);
            }
            catch (NumberFormatException exc) {
                System.out.println("Invalid integer: " + val);
            }
            return decoded;
        }).filter(val -> val != null).filter(val -> {
            if (val < 0L | val > 0xFFFFFFFFL) {
                System.out.println("Negative or too big to fit in 32 bits: " + val);
                return false;
            }
            return true;
        }).mapToLong(Long::longValue).toArray();
        return result;
    }

    private static Boolean decodeBit(String value) {
        try {
            return Boolean.valueOf(value);
        }
        catch (NumberFormatException exc) {
            System.out.println("Invalid boolean: " + value);
            return null;
        }
    }

    private BiConsumer<AxisName, String> axisSetter(String paramName) {
        BiConsumer<AxisName, String> result = AXIS_SETTERS.get(paramName.toUpperCase());
        if (result == null) {
            System.out.println("Not a settable axis parameter: " + paramName);
        }
        return result;
    }

    private BiConsumer<MasterName, String> masterSetter(String paramName) {
        BiConsumer<MasterName, String> result = MASTER_SETTERS.get(paramName.toUpperCase());
        if (result == null) {
            System.out.println("Not a settable master parameter: " + paramName);
        }
        return result;
    }

    private BiConsumer<EncoderName, String> encoderSetter(String paramName) {
        BiConsumer<EncoderName, String> result = ENCODER_SETTERS.get(paramName.toUpperCase());
        if (result == null) {
            System.out.println("Not a settable encoder parameter: " + paramName);
        }
        return result;
    }

    private Consumer<String> systemSetter(String paramName) {
        Consumer<String> result = SYSTEM_SETTERS.get(paramName.toUpperCase());
        if (result == null) {
            System.out.println("Not a settable system parameter: " + paramName);
        }
        return result;
    }

    private Consumer<ProgramName> programGetter(String varName) {
        Consumer<ProgramName> result = PROGRAM_GETTERS.get(varName.toUpperCase());
        if (result == null) {
            System.out.println("Unsupported local variable: " + varName);
        }
        return result;
    }

    BiConsumer<ProgramName, String[]> programSetter(String varName, String[] newValue) {
        BiConsumer<ProgramName, String[]> result = PROGRAM_SETTERS.get(varName.toUpperCase());
        if (result == null) {
            System.out.println("Unsupported local variable: " + varName);
        }
        if (newValue.length == 0) {
            result = null;
            System.out.println("Supply at least one new value.");
        }
        return result;
    }

    private static /* synthetic */ void lambda$static$30(LocalStringArray var, ProgramName program, String[] newValue) {
        acr[0].set(program, var, newValue);
    }

    private static /* synthetic */ void lambda$static$29(LocalDoubleArray var, ProgramName program, String[] newValue) {
        double[] decoded = TestAcrComm.decodeSingles(newValue);
        if (decoded.length == newValue.length) {
            acr[0].set(program, var, decoded);
        }
    }

    private static /* synthetic */ void lambda$static$28(LocalSingleArray var, ProgramName program, String[] newValue) {
        double[] decoded = TestAcrComm.decodeSingles(newValue);
        if (decoded.length == newValue.length) {
            acr[0].set(program, var, decoded);
        }
    }

    private static /* synthetic */ void lambda$static$27(LocalLongArray var, ProgramName program, String[] newValue) {
        long[] decoded = TestAcrComm.decodeLongs(newValue);
        if (decoded.length == newValue.length) {
            acr[0].set(program, var, decoded);
        }
    }

    private static /* synthetic */ void lambda$static$26(LocalString var, ProgramName program, String[] newValue) {
        acr[0].set(program, var, newValue[0]);
    }

    private static /* synthetic */ void lambda$static$25(LocalDouble var, ProgramName program, String[] newValue) {
        double[] decoded = TestAcrComm.decodeSingles(newValue);
        if (decoded.length == newValue.length) {
            acr[0].set(program, var, decoded[0]);
        }
    }

    private static /* synthetic */ void lambda$static$24(LocalSingle var, ProgramName program, String[] newValue) {
        double[] decoded = TestAcrComm.decodeSingles(newValue);
        if (decoded.length == newValue.length) {
            acr[0].set(program, var, decoded[0]);
        }
    }

    private static /* synthetic */ void lambda$static$23(LocalLong var, ProgramName program, String[] newValue) {
        long[] decoded = TestAcrComm.decodeLongs(newValue);
        if (decoded.length == newValue.length) {
            acr[0].set(program, var, decoded[0]);
        }
    }

    private static /* synthetic */ void lambda$static$22(LocalStringArray var, ProgramName program) {
        String[] value = acr[0].get(program, var);
        for (int i = 0; i < value.length; ++i) {
            System.out.format("%d: \"%s\"%n", i, value[i]);
        }
    }

    private static /* synthetic */ void lambda$static$21(LocalDoubleArray var, ProgramName program) {
        double[] value = acr[0].get(program, var);
        for (int i = 0; i < value.length; ++i) {
            System.out.println(String.format("%d: %.12g", i, value[i]));
        }
    }

    private static /* synthetic */ void lambda$static$20(LocalSingleArray var, ProgramName program) {
        double[] value = acr[0].get(program, var);
        for (int i = 0; i < value.length; ++i) {
            System.out.println(String.format("%d: %.6g", i, value[i]));
        }
    }

    private static /* synthetic */ void lambda$static$19(LocalLongArray var, ProgramName program) {
        long[] value = acr[0].get(program, var);
        for (int i = 0; i < value.length; ++i) {
            System.out.println(String.format("%d: %d", i, value[i]));
        }
    }

    private static /* synthetic */ void lambda$static$18(LocalString var, ProgramName program) {
        System.out.format("\"%s\"%n", acr[0].get(program, var));
    }

    private static /* synthetic */ void lambda$static$17(LocalDouble var, ProgramName program) {
        System.out.println(String.format("%.12g", acr[0].get(program, var)));
    }

    private static /* synthetic */ void lambda$static$16(LocalSingle var, ProgramName program) {
        System.out.println(String.format("%.6g", acr[0].get(program, var)));
    }

    private static /* synthetic */ void lambda$static$15(LocalLong var, ProgramName program) {
        System.out.println(acr[0].get(program, var));
    }

    private static /* synthetic */ void lambda$static$14(SystemBit b, String val) {
        Boolean decoded = TestAcrComm.decodeBit(val);
        if (decoded != null) {
            acr[0].set(b, decoded);
        }
    }

    private static /* synthetic */ void lambda$static$13(SystemUnsigned p, String val) {
        long[] decoded = TestAcrComm.decodeUnsigneds(val);
        if (decoded.length == 1) {
            acr[0].set(p, decoded[0]);
        }
    }

    private static /* synthetic */ void lambda$static$12(EncoderLong p, EncoderName encoder, String val) {
        long[] decoded = TestAcrComm.decodeLongs(val);
        if (decoded.length == 1) {
            acr[0].set(encoder, p, decoded[0]);
        }
    }

    private static /* synthetic */ void lambda$static$11(MasterBit b, MasterName master, String val) {
        acr[0].set(master, b, (boolean)TestAcrComm.decodeBit(val));
    }

    private static /* synthetic */ void lambda$static$10(AxisBit b, AxisName axis, String val) {
        Boolean decoded = TestAcrComm.decodeBit(val);
        if (decoded != null) {
            acr[0].set(axis, b, (boolean)decoded);
        }
    }

    private static /* synthetic */ void lambda$static$9(AxisLong p, AxisName axis, String val) {
        long[] decoded = TestAcrComm.decodeLongs(val);
        if (decoded.length == 1) {
            acr[0].set(axis, p, decoded[0]);
        }
    }

    static {
        HashMap<String, Object> setters = new HashMap<String, Object>();
        for (AxisSingle axisSingle : AxisSingle.values()) {
            setters.put(axisSingle.name(), (axis, val) -> {
                double[] decoded = TestAcrComm.decodeSingles(val);
                if (decoded.length == 1) {
                    acr[0].set((AxisName)((Object)axis), axisSingle, decoded[0]);
                }
            });
        }
        for (Enum enum_ : AxisLong.values()) {
            setters.put(enum_.name(), (arg_0, arg_1) -> TestAcrComm.lambda$static$9((AxisLong)enum_, arg_0, arg_1));
        }
        for (Enum enum_ : AxisBit.values()) {
            setters.put(enum_.name(), (arg_0, arg_1) -> TestAcrComm.lambda$static$10((AxisBit)enum_, arg_0, arg_1));
        }
        AXIS_SETTERS = Collections.unmodifiableMap(setters);
        setters = new HashMap();
        for (Enum enum_ : MasterBit.values()) {
            setters.put(enum_.name(), (arg_0, arg_1) -> TestAcrComm.lambda$static$11((MasterBit)enum_, arg_0, arg_1));
        }
        MASTER_SETTERS = Collections.unmodifiableMap(setters);
        setters = new HashMap();
        for (Enum enum_ : EncoderLong.values()) {
            setters.put(enum_.name(), (arg_0, arg_1) -> TestAcrComm.lambda$static$12((EncoderLong)enum_, arg_0, arg_1));
        }
        ENCODER_SETTERS = Collections.unmodifiableMap(setters);
        setters = new HashMap();
        for (Enum enum_ : SystemUnsigned.values()) {
            setters.put(enum_.name(), arg_0 -> TestAcrComm.lambda$static$13((SystemUnsigned)enum_, arg_0));
        }
        for (Enum enum_ : SystemBit.values()) {
            setters.put(enum_.name(), arg_0 -> TestAcrComm.lambda$static$14((SystemBit)enum_, arg_0));
        }
        SYSTEM_SETTERS = Collections.unmodifiableMap(setters);
        HashMap<String, Consumer<ProgramName>> getters = new HashMap<String, Consumer<ProgramName>>();
        for (Enum enum_ : LocalLong.values()) {
            getters.put(enum_.name(), arg_0 -> TestAcrComm.lambda$static$15((LocalLong)enum_, arg_0));
        }
        for (Enum enum_ : LocalSingle.values()) {
            getters.put(enum_.name(), arg_0 -> TestAcrComm.lambda$static$16((LocalSingle)enum_, arg_0));
        }
        for (Enum enum_ : LocalDouble.values()) {
            getters.put(enum_.name(), arg_0 -> TestAcrComm.lambda$static$17((LocalDouble)enum_, arg_0));
        }
        for (Enum enum_ : LocalString.values()) {
            getters.put(enum_.name(), arg_0 -> TestAcrComm.lambda$static$18((LocalString)enum_, arg_0));
        }
        for (Enum enum_ : LocalLongArray.values()) {
            getters.put(enum_.name(), arg_0 -> TestAcrComm.lambda$static$19((LocalLongArray)enum_, arg_0));
        }
        for (Enum enum_ : LocalSingleArray.values()) {
            getters.put(enum_.name(), arg_0 -> TestAcrComm.lambda$static$20((LocalSingleArray)enum_, arg_0));
        }
        for (Enum enum_ : LocalDoubleArray.values()) {
            getters.put(enum_.name(), arg_0 -> TestAcrComm.lambda$static$21((LocalDoubleArray)enum_, arg_0));
        }
        for (Enum enum_ : LocalStringArray.values()) {
            getters.put(enum_.name(), arg_0 -> TestAcrComm.lambda$static$22((LocalStringArray)enum_, arg_0));
        }
        PROGRAM_GETTERS = Collections.unmodifiableMap(getters);
        setters = new HashMap();
        for (Enum enum_ : LocalLong.values()) {
            setters.put(enum_.name(), (arg_0, arg_1) -> TestAcrComm.lambda$static$23((LocalLong)enum_, arg_0, arg_1));
        }
        for (Enum enum_ : LocalSingle.values()) {
            setters.put(enum_.name(), (arg_0, arg_1) -> TestAcrComm.lambda$static$24((LocalSingle)enum_, arg_0, arg_1));
        }
        for (Enum enum_ : LocalDouble.values()) {
            setters.put(enum_.name(), (arg_0, arg_1) -> TestAcrComm.lambda$static$25((LocalDouble)enum_, arg_0, arg_1));
        }
        for (Enum enum_ : LocalString.values()) {
            setters.put(enum_.name(), (arg_0, arg_1) -> TestAcrComm.lambda$static$26((LocalString)enum_, arg_0, arg_1));
        }
        for (Enum enum_ : LocalLongArray.values()) {
            setters.put(enum_.name(), (arg_0, arg_1) -> TestAcrComm.lambda$static$27((LocalLongArray)enum_, arg_0, arg_1));
        }
        for (Enum enum_ : LocalSingleArray.values()) {
            setters.put(enum_.name(), (arg_0, arg_1) -> TestAcrComm.lambda$static$28((LocalSingleArray)enum_, arg_0, arg_1));
        }
        for (Enum enum_ : LocalDoubleArray.values()) {
            setters.put(enum_.name(), (arg_0, arg_1) -> TestAcrComm.lambda$static$29((LocalDoubleArray)enum_, arg_0, arg_1));
        }
        for (Enum enum_ : LocalStringArray.values()) {
            setters.put(enum_.name(), (arg_0, arg_1) -> TestAcrComm.lambda$static$30((LocalStringArray)enum_, arg_0, arg_1));
        }
        PROGRAM_SETTERS = Collections.unmodifiableMap(setters);
    }
}

