/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.plc.Error;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.Closed;
import org.lsst.ccs.subsystem.shutter.statemachine.Closing;
import org.lsst.ccs.subsystem.shutter.statemachine.CompositeState;
import org.lsst.ccs.subsystem.shutter.statemachine.Enabled;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Logging;
import org.lsst.ccs.subsystem.shutter.statemachine.Opened;
import org.lsst.ccs.subsystem.shutter.statemachine.Opening;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Traveling;

class Prod
extends CompositeState<Prod, Enabled> {
    private static final Logger LOG = Logger.getLogger(Prod.class.getName());
    private Closed closedState;
    private Opening openingState;
    private Traveling travelingState;
    private Opened openedState;
    private Closing closingState;

    public Prod(Actions actions, Enabled context) {
        super(actions, context);
    }

    @Override
    public void init() {
        this.makeTransition(this.getClosedState(), null);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    synchronized Closed getClosedState() {
        if (this.closedState == null) {
            this.closedState = new Closed(this);
        }
        return this.closedState;
    }

    synchronized Opening getOpeningState() {
        if (this.openingState == null) {
            this.openingState = new Opening(this);
        }
        return this.openingState;
    }

    synchronized Traveling getTravelingState() {
        if (this.travelingState == null) {
            this.travelingState = new Traveling(this);
        }
        return this.travelingState;
    }

    synchronized Opened getOpenedState() {
        if (this.openedState == null) {
            this.openedState = new Opened(this);
        }
        return this.openedState;
    }

    synchronized Closing getClosingState() {
        if (this.closingState == null) {
            this.closingState = new Closing(this);
        }
        return this.closingState;
    }

    @Override
    public void error(Channel<EventReply> chan, Error err) throws InterruptedException {
        Logging.logEvent(this);
        chan.write(PromptReply.ACCEPTED);
        ((Enabled)this.getContext()).makeTransition(((Enabled)this.getContext()).getMaintState(), () -> {
            ((Enabled)this.getContext()).getActions().setPhysicalState(PhysicalState.OTHER);
            ((Enabled)this.getContext()).getActions().raisePLCAlert(err);
        });
    }

    @Override
    public void reset(Channel<EventReply> chan) throws InterruptedException {
        Logging.logEvent(this);
        chan.write(PromptReply.ACCEPTED);
        ((Enabled)this.getContext()).makeTransition(((Enabled)this.getContext()).getMaintState(), () -> {
            ((Enabled)this.getContext()).getActions().setPhysicalState(PhysicalState.OTHER);
            ((Enabled)this.getContext()).getActions().lowerMotionAlert();
            ((Enabled)this.getContext()).getActions().lowerPLCAlert();
            ((Enabled)this.getContext()).getActions().lowerWatchdogAlert();
            ((Enabled)this.getContext()).getActions().resetPLC();
        });
    }
}

