// Groovy file for the prototype gantry with one Ensemble CP controller.

import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.motorplatform.gantry.GantryMain;
import org.lsst.ccs.subsystem.motorplatform.gantry.Ensemble;
import org.lsst.ccs.subsystem.motorplatform.gantry.Axis;
import org.lsst.ccs.subsystem.motorplatform.gantry.LoadCellAxis;
import org.lsst.ccs.subsystem.motorplatform.gantry.AnalogInput;
import org.lsst.ccs.subsystem.motorplatform.gantry.DigitalInput;
import org.lsst.ccs.subsystem.motorplatform.gantry.DigitalOutput;

CCSBuilder builder = ["protogantry-motorplatform"]

builder.
    main(GantryMain) {
        // Subsystem main. Takes commands from the CCS bus and
        // delegates operations to the Controller.

        Controller(Ensemble) {
            // The Controller sends commands to the motor controller,
            // if any, and publishes status reports.

            // Axis names, indexes and units must match those configured in the
            // motor controller.
            ZAxis(LoadCellAxis, axisName:"Z", index:0, units:"mm") {
                // In each category of I/O the members must be ordered
                // as the GUI and the worker subsystem expect. You can't rely
                // on the ordering of things in this description file, so
                // there's an integer "order" field used solely to sort each
                // list of I/O object into the correct order. DIN and DOUT commands
                // require an axis name, a port number and a bit number.
                //
                // See sections 2.5.3, 2.5.4 and 2.5.7 of the Ensemble CP hardware
                // manual for wiring diagrams.
                // For analog lines the GUI expects the display format to
                // come after the vertical bar in the description.AIN
                // commands require an axis name and a channel number.
                // On an Ensemble CP controller the first analog input is on the AUX I/O
                // connector J104, pins 13 (+), 14 (-) and 23 (shield/GND). It accepts
                // from -10V to 10V with 16-bit resolution (about 0.3 mV).
                LoadCell(AnalogInput, description:"Load cell (N)|%g", order:0, channel:0)

                Doubt(DigitalOutput, lineName:"Digital out|[off] |[on] ", order:0, port:0, bit:0)
                Drought(DigitalOutput, lineName:"Digital out2", order:1, port:0, bit:1)
                Noise(DigitalInput, lineName:"active Din|in|", order:0, port:0, bit:0)
                Clamor(DigitalInput, lineName:"Din2", order:1, port:0, bit:1)
            }
        }

    }
