/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;

public class LoaderMain
extends MainModule {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Loader loader;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private FilterHolder autochanger;

    public LoaderMain(BridgeToHardware bridge) {
        super(bridge);
    }

    public void init() {
        ((AgentPropertiesService)this.subs.getAgentService(AgentPropertiesService.class)).setAgentProperty("org.lsst.ccs.subsystem.fcs.loader", "loader");
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Update loader state in reading the sensors.")
    public void updateStateWithSensors() {
        this.loader.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Update FCS state and FCS readyness state and publishes on the status bus.")
    public void updateFCSStateToReady() {
        if (this.loader.isInitialized()) {
            ((AgentStateService)this.subs.getAgentService(AgentStateService.class)).updateAgentState(new Enum[]{FcsEnumerations.FilterState.READY, FcsEnumerations.FilterReadinessState.READY});
        }
    }

    @Override
    public void initializeHardware() {
        this.loader.initializeHardware();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Connect the loader hardware.")
    public void connectLoader() {
        this.bridge.connectHardware();
        this.loader.postStart();
    }

    public void postStart() {
        this.connectLoader();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Print the list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.bridge.printHardwareState());
        sb.append("\n ");
        sb.append(this.loader.printHardwareState());
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("\n").append(this.loader.toString());
        return sb.toString();
    }
}

