/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.plc.Error;
import org.lsst.ccs.subsystem.shutter.plc.GoToProd;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.Calibrating;
import org.lsst.ccs.subsystem.shutter.statemachine.Centering1;
import org.lsst.ccs.subsystem.shutter.statemachine.Centering2;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.CompositeState;
import org.lsst.ccs.subsystem.shutter.statemachine.Enabled;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Logging;
import org.lsst.ccs.subsystem.shutter.statemachine.Moving;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Still;

class Maint
extends CompositeState<Maint, Enabled> {
    private static final Logger LOG = Logger.getLogger(Maint.class.getName());
    private Still stillState;
    private Calibrating calibratingState;
    private Centering1 centering1State;
    private Centering2 centering2State;
    private Moving movingState;

    public Maint(Actions actions, Enabled context) {
        super(actions, context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void init() {
        this.makeTransition(this.getStillState(), null);
    }

    synchronized Still getStillState() {
        if (this.stillState == null) {
            this.stillState = new Still(this);
        }
        return this.stillState;
    }

    synchronized Calibrating getCalibratingState() {
        if (this.calibratingState == null) {
            this.calibratingState = new Calibrating(this);
        }
        return this.calibratingState;
    }

    synchronized Centering1 getCentering1State() {
        if (this.centering1State == null) {
            this.centering1State = new Centering1(this);
        }
        return this.centering1State;
    }

    synchronized Centering2 getCentering2State() {
        if (this.centering2State == null) {
            this.centering2State = new Centering2(this);
        }
        return this.centering2State;
    }

    synchronized Moving getMovingState() {
        if (this.movingState == null) {
            this.movingState = new Moving(this);
        }
        return this.movingState;
    }

    @Override
    public void error(Channel<EventReply> chan, Error err) throws InterruptedException {
        Logging.logEvent(this);
        chan.write(PromptReply.ACCEPTED);
        ((Enabled)this.getContext()).makeTransition(((Enabled)this.getContext()).getMaintState(), () -> {
            ((Enabled)this.getContext()).getActions().setPhysicalState(PhysicalState.OTHER);
            ((Enabled)this.getContext()).getActions().raisePLCAlert(err);
        });
    }

    @Override
    public void reset(Channel<EventReply> chan) throws InterruptedException {
        Logging.logEvent(this);
        chan.write(PromptReply.ACCEPTED);
        ((Enabled)this.getContext()).makeTransition(((Enabled)this.getContext()).getMaintState(), () -> {
            ((Enabled)this.getContext()).getActions().setPhysicalState(PhysicalState.OTHER);
            ((Enabled)this.getContext()).getActions().lowerMotionAlert();
            ((Enabled)this.getContext()).getActions().lowerPLCAlert();
            ((Enabled)this.getContext()).getActions().lowerWatchdogAlert();
            ((Enabled)this.getContext()).getActions().resetPLC();
        });
    }

    @Override
    public void gotoProd(Channel<EventReply> chan) throws InterruptedException {
        Logging.logEvent(this);
        Enabled ctx = (Enabled)this.getContext();
        String msg = ctx.getActions().shutterIsReady();
        if (msg == null) {
            chan.write(PromptReply.ACCEPTED);
            ctx.makeTransition(ctx.getProdState(), () -> ctx.getActions().relay(new GoToProd()));
        } else {
            chan.write(new PromptReply(msg));
        }
    }
}

