/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.Source;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.RebNode;
import org.lsst.ccs.subsystem.imagehandling.SourceHandler;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

class ImageHandler
implements Callable<FileList> {
    private final Image image;
    private final ImageHandlingConfig config;
    private final ExecutorService executor;
    private final List<RebNode> rebs;
    private final boolean isStreaming;

    ImageHandler(Image image, ExecutorService executor, ImageHandlingConfig config, List<RebNode> rebs, boolean isStreaming) {
        this.image = image;
        this.config = config;
        this.executor = executor;
        this.rebs = rebs;
        this.isStreaming = isStreaming;
    }

    @Override
    public FileList call() throws IOException, DAQException, InterruptedException, ExecutionException {
        List sources = this.image.listSources();
        LocationSet locationsToProcess = this.config.getLocationsToProcess();
        ArrayList lffl = new ArrayList();
        sources.stream().filter(arg_0 -> ImageHandler.lambda$call$0((Set)locationsToProcess, arg_0)).forEach(source -> {
            Location location = source.getLocation();
            for (RebNode r : this.rebs) {
                if (!r.isEnabled() || !r.getLocation().equals((Object)location)) continue;
                lffl.add(this.executor.submit(new SourceHandler((Source)source, this.config, r, this.isStreaming)));
            }
        });
        FileList result = new FileList();
        for (Future ffl : lffl) {
            FileList fl = (FileList)ffl.get();
            result.addAll(fl);
        }
        return result;
    }

    private static /* synthetic */ boolean lambda$call$0(Set locationsToProcess, Source source) {
        return locationsToProcess.contains(source.getLocation());
    }
}

