/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mmm.ir2.actions;

import java.util.Map;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher;
import org.lsst.ccs.subsystem.mmm.AlertNotification;
import org.lsst.ccs.subsystem.mmm.MMM_IR2;
import org.lsst.ccs.subsystem.mmm.MinionIR2;
import org.lsst.ccs.subsystem.power.states.RebPowerState;
import org.lsst.ccs.subsystem.rafts.alerts.RaftAlert;

public class FocalPlaneRebTemperatureTooHighAction
extends AlertDispatcher.AlertAction
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    AlertDispatcher dispatcher;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    MMM_IR2 mmm;

    @Override
    public void accept(AlertNotification t) {
        String alertId;
        if (t.getSubsystemType() == MinionIR2.FOCAL_PLANE && ((alertId = t.getAlert().getAlertId()).equals(RaftAlert.ASPICS_TEMPERATURE_TOO_HIGH.getAlertId()) || alertId.equals(RaftAlert.REB_BOARD_TEMPERATURE_TOO_HIGH.getAlertId()))) {
            this.getLogger().info((Object)("REB temperature too high action required at level: " + t.getSeverity() + " (" + t.getCause() + ")"));
            String destination = this.dispatcher.getMmmUtilities().getDestination(this.dispatcher.getGroup(), MinionIR2.POWER);
            StateBundle powerStateBundle = this.dispatcher.getMmmUtilities().getState(destination);
            if (powerStateBundle != null) {
                Map powerStates = powerStateBundle.getComponentsWithState(RebPowerState.class);
                this.getLogger().info((Object)("Overall Power state: " + powerStateBundle.getState(RebPowerState.class)));
                this.getLogger().info((Object)("Component Power state " + powerStates));
                if (t.getSeverity() == AlertState.ALARM) {
                    this.getLogger().warn((Object)("********** Powering off the rebs for group " + this.dispatcher.getGroupName()));
                    String command = "powerOffAllRebs";
                    this.getLogger().warn((Object)("Sending command \"" + command + "\" to " + destination));
                    try {
                        this.dispatcher.getMmmUtilities().send(destination, command, new Object[0]);
                    }
                    catch (Exception e) {
                        this.getLogger().severe((Object)"FAILED TO TURN OFF REBS", (Throwable)e);
                    }
                }
            } else {
                this.getLogger().warning((Object)("No state information is available for " + destination + ". The subsystem might not be available on the buses."));
                this.getLogger().warning((Object)"The Reb Temperature Too High Action is skipped!");
            }
        }
    }

    @Override
    public String getDescription() {
        return "Powers off the Rebs upon ALARM by sending sequencePower i false to " + this.dispatcher.getMmmUtilities().getDestination(this.dispatcher.getGroup(), MinionIR2.POWER);
    }
}

