/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.ImageCoordinator;
import org.lsst.ccs.subsystem.focalplane.ImageCoordinatorService;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.data.FitsFilesWrittenEvent;
import org.lsst.ccs.subsystem.imagehandling.data.ImageReceivedEvent;

class ImageMessageHandling
implements AgentPresenceListener,
StatusMessageListener,
HasLifecycle {
    private static final Logger LOG = Logger.getLogger(ImageMessageHandling.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private FocalPlaneSubsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ImageCoordinatorService ics;
    private final Set<AgentInfo> imageHandlers = new CopyOnWriteArraySet<AgentInfo>();

    ImageMessageHandling() {
    }

    public void start() {
        this.subsys.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.subsys.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
    }

    public void shutdown() {
        this.subsys.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
        this.subsys.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
    }

    private static boolean isAgentAnImageHandler(AgentInfo agentInfo) {
        return AgentCategory.IMAGE_HANDLER.name().equals(agentInfo.getAgentProperty("agentCategory"));
    }

    public void connected(AgentInfo ... agents) {
        KeyValueDataList sequencerKeyValueData;
        boolean imageHandlerConnected = false;
        for (AgentInfo a : agents) {
            if (!ImageMessageHandling.isAgentAnImageHandler(a)) continue;
            this.imageHandlers.add(a);
            imageHandlerConnected = true;
        }
        if (imageHandlerConnected && (sequencerKeyValueData = this.subsys.getSequencers().getSequencerKeyValueData()) != null) {
            this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)sequencerKeyValueData);
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo a : agents) {
            if (!ImageMessageHandling.isAgentAnImageHandler(a)) continue;
            this.imageHandlers.remove(a);
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        AgentInfo agentInfo = msg.getOriginAgentInfo();
        if (ImageMessageHandling.isAgentAnImageHandler(agentInfo)) {
            String key;
            StatusSubsystemData statusData = (StatusSubsystemData)msg;
            switch (key = statusData.getDataKey()) {
                case "imageReceivedEvent": {
                    ImageReceivedEvent imageEvent = (ImageReceivedEvent)statusData.getSubsystemData().getValue();
                    LOG.log(Level.INFO, "Received imageReceivedEvent for {0} from {1}", new Object[]{imageEvent.getImageName(), agentInfo.getName()});
                    break;
                }
                case "fitsFilesWrittenEvent": {
                    FitsFilesWrittenEvent fitsFileEvent = (FitsFilesWrittenEvent)statusData.getSubsystemData().getValue();
                    FileList fileList = fitsFileEvent.getFileList();
                    LOG.log(Level.INFO, "Received fitsFilesWrittenEvent for {0} from {1} with {2} files", new Object[]{fitsFileEvent.getImageName(), agentInfo.getName(), fileList == null ? 0 : fileList.size()});
                    ImageCoordinator coord = this.ics.getImageCoordinator(fitsFileEvent.getImageName());
                    coord.addFitsFiles(fitsFileEvent);
                }
            }
        }
    }

    int getCount() {
        return this.imageHandlers.size();
    }
}

