/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.devices.power.distribution.APC7900Device;
import org.lsst.ccs.subsystem.common.devices.vacuum.VQMDevice;
import org.lsst.ccs.subsystem.power.states.RebPowerState;
import org.lsst.ccs.subsystem.teststand.AP9630UPSDevice;
import org.lsst.ccs.subsystem.teststand.CryoDevice;
import org.lsst.ccs.subsystem.teststand.UPSMonitor;
import org.lsst.ccs.subsystem.teststand.data.TS7Outlets;
import org.lsst.ccs.subsystem.teststand.data.TestStandAgentProperties;
import org.lsst.ccs.subsystem.teststand.limits.TransitionAlgorithm;
import org.lsst.ccs.utilities.logging.Logger;

public class TS7
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    CryoDevice cryoDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    VQMDevice vqmDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    protected final Map<String, APC7900Device> pduDevicesMap = new HashMap<String, APC7900Device>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    AP9630UPSDevice upsDevc;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configurationService;
    @ConfigurationParameter(isFinal=true)
    private String rebPsSubsystem = "ccs-rebps";
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService als;
    private final Logger LOGGER = Logger.getLogger((String)this.getClass().getPackage().getName());
    private final Object initializationLock = new Object();
    private boolean initializedRebPowerState = false;
    private RebPowerState currentRebsPowerState = RebPowerState.OFF;
    private TransitionAlgorithm vacuumTransitionAlgorithm;
    private TransitionAlgorithm coldTransitionAlgorithm1;
    private TransitionAlgorithm coldTransitionAlgorithm2;
    private TransitionAlgorithm cryoTransitionAlgorithm;
    private volatile boolean alertResponseEnabled = false;
    private UPSMonitor upsMon;

    public void postInit() {
        if (this.cryoDevc == null) {
            this.LOGGER.warning((Object)"Cryo device not defined");
        }
        ((AgentPropertiesService)this.subsys.getAgentService(AgentPropertiesService.class)).setAgentProperty(TestStandAgentProperties.TESTSTAND_TYPE_AGENT_PROPERTY, TS7.class.getCanonicalName());
        this.upsMon = new UPSMonitor(this, this.upsDevc, this.LOGGER, this.pts, this.als);
    }

    public void build() {
        this.pts.scheduleAgentPeriodicTask(new AgentPeriodicTask("ups-timer", () -> this.upsMon.monitorUPS()));
        this.pts.setPeriodicTaskPeriod("ups-timer", Duration.ofSeconds(1L));
    }

    public void postStart() {
        Predicate filter = BusMessageFilterFactory.messageOrigin((String)this.rebPsSubsystem);
        this.subsys.getMessagingAccess().addStatusMessageListener(msg -> this.handlePowerSupplyMessage(msg), filter);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of PDU names")
    public List<String> getPduNames() {
        return new ArrayList<String>(this.pduDevicesMap.keySet());
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of PDU outlet names")
    public List<String> getOutletNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String pduName : this.pduDevicesMap.keySet()) {
            for (String outletName : this.pduDevicesMap.get(pduName).getOutletNames()) {
                names.add(pduName + "/" + outletName);
            }
        }
        return names;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the map of PDU outlet on states")
    public Map<String, Boolean> getOutletOnStateMap() throws DriverException {
        HashMap<String, Boolean> states = new HashMap<String, Boolean>();
        for (String pduName : this.pduDevicesMap.keySet()) {
            Map pduStates = this.pduDevicesMap.get(pduName).getOutletOnStateMap();
            for (String outletName : pduStates.keySet()) {
                states.put(pduName + "/" + outletName, (Boolean)pduStates.get(outletName));
            }
        }
        return states;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePowerSupplyMessage(StatusMessage msg) {
        Object object = this.initializationLock;
        synchronized (object) {
            StateBundle sb;
            if (this.initializedRebPowerState && msg instanceof StatusStateChangeNotification) {
                StatusStateChangeNotification ssn = (StatusStateChangeNotification)msg;
                sb = ssn.getNewState();
            } else {
                sb = !this.initializedRebPowerState ? msg.getState() : null;
            }
            if (sb != null) {
                RebPowerState powerState = (RebPowerState)sb.getState(RebPowerState.class);
                if (powerState != null) {
                    this.initializedRebPowerState = true;
                }
                if (this.currentRebsPowerState != powerState) {
                    this.currentRebsPowerState = powerState;
                    new Thread(() -> this.updatePowerState(this.currentRebsPowerState, sb.getComponentsWithState(RebPowerState.class))).start();
                }
            }
        }
    }

    public RebPowerState getCurrentRebsPowerState() {
        return this.currentRebsPowerState;
    }

    private void updatePowerState(RebPowerState state, Map<String, RebPowerState> map) {
        String rebStateStr = "";
        for (Map.Entry<String, RebPowerState> e : map.entrySet()) {
            rebStateStr = rebStateStr + e.getKey() + "=" + e.getValue() + " ";
        }
        this.LOGGER.info((Object)("Updating power state to " + state + " " + rebStateStr));
    }

    @Command(type=Command.CommandType.ACTION, description="Turn Off named outlet")
    public void turnOutletOff(TS7Outlets outlet) throws DriverException {
        this.changeOutletState(outlet, false);
    }

    @Command(type=Command.CommandType.ACTION, description="Turn On named outlet")
    public void turnOutletOn(TS7Outlets outlet) throws DriverException {
        this.changeOutletState(outlet, true);
    }

    private void changeOutletState(TS7Outlets outlet, boolean on) throws DriverException {
        String outletName = outlet.getOutletName();
        for (APC7900Device pdu : this.pduDevicesMap.values()) {
            if (!pdu.getOutletNames().contains(outletName)) continue;
            if (on) {
                pdu.forceOutletOn(outletName);
            } else {
                pdu.forceOutletOff(outletName);
            }
            return;
        }
        throw new IllegalArgumentException("Could not find device to turn off outlet " + outletName);
    }

    @Command(type=Command.CommandType.ACTION, description="Enable/disable alert response")
    public void enableAlertResponse(boolean enable) {
        this.alertResponseEnabled = enable;
    }

    @Command(type=Command.CommandType.QUERY, description="Get true/false if the alert response is enabled")
    public boolean isAlertResponseEnabled() {
        return this.alertResponseEnabled;
    }
}

