/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gantry;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.aerotech.AerotechPro165;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.motorplatform.gantry.Axis;
import org.lsst.ccs.subsystem.motorplatform.gantry.ReadIO;

public class DigitalInput {
    private String lineName;
    private int order;
    private int port;
    private int bit;
    private volatile int globalOrder = -1;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private Axis axis;

    public String getName() {
        return this.lineName;
    }

    public int getOrder() {
        return this.order;
    }

    public int getGlobalOrder() {
        return this.globalOrder;
    }

    public void setGlobalOrder(int globalOrder) {
        this.globalOrder = globalOrder;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public int getPort() {
        return this.port;
    }

    public int getBit() {
        return this.bit;
    }

    public int getDescriptor() {
        return ReadIO.descriptor(this.getAxis().getIndex(), 0, this.getPort(), this.getBit());
    }

    public int readValue(AerotechPro165 aero) throws DriverException {
        if (this.globalOrder < 0) {
            throw new IllegalArgumentException("Unset globalOrder.");
        }
        return (int)aero.readDoubleAP(String.format("DGLOBAL(%d)", 32 + this.globalOrder));
    }
}

