/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;

public interface AlertRaiser {
    public static final char alertSeparator = '/';

    public String getName();

    public Subsystem getSubsystem();

    public AlertService getAlertService();

    default public char getAlertSeparator() {
        return '/';
    }

    default public void raiseAlarm(FcsEnumerations.FcsAlert fcsAlert, String cause) {
        this.getAlertService().raiseAlert(new Alert(fcsAlert.name(), fcsAlert.getLongDescription()), AlertState.ALARM, cause);
    }

    default public void raiseAlarm(FcsEnumerations.FcsAlert fcsAlert, String cause, Exception ex) {
        FCSCst.FCSLOG.error((Object)ex);
        this.raiseAlarm(fcsAlert, cause + " due to " + ex);
    }

    default public void raiseAlarm(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName) {
        this.getAlertService().raiseAlert(new Alert(deviceName + '/' + fcsAlert.name(), fcsAlert.getLongDescription()), AlertState.ALARM, cause);
    }

    default public void raiseAlarm(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName, Exception ex) {
        this.raiseAlarm(fcsAlert, cause + " due to " + ex, deviceName);
    }

    default public void clearAlarm(FcsEnumerations.FcsAlert fcsAlert, String deviceName) {
        String[] alarmList = new String[]{deviceName + '/' + fcsAlert.name()};
        this.getAlertService().clearAlerts(alarmList);
    }

    default public void raiseWarning(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName) {
        this.getAlertService().raiseAlert(new Alert(deviceName + '/' + fcsAlert.name(), fcsAlert.getLongDescription()), AlertState.WARNING, cause);
    }

    default public void raiseWarning(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName, Exception ex) {
        FCSCst.FCSLOG.warning((Object)ex);
        this.raiseWarning(fcsAlert, cause + " due to " + ex, deviceName);
    }

    default public void raiseAlertOnlyIfNew(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName, AlertState state) {
        RaisedAlertHistory history;
        String alertId = fcsAlert.name();
        if (deviceName != null && !deviceName.isEmpty()) {
            alertId = deviceName + '/' + fcsAlert.name();
        }
        if ((history = this.getAlertService().getRaisedAlertSummary().getRaisedAlert(alertId)) == null || history.getLatestAlertState() != state) {
            this.getAlertService().raiseAlert(new Alert(alertId, fcsAlert.getLongDescription()), state, cause);
        }
    }

    default public void raiseAlarmOnlyIfNew(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName) {
        this.raiseAlertOnlyIfNew(fcsAlert, cause, deviceName, AlertState.ALARM);
    }

    default public void raiseWarningOnlyIfNew(FcsEnumerations.FcsAlert fcsAlert, String cause, String deviceName) {
        this.raiseAlertOnlyIfNew(fcsAlert, cause, deviceName, AlertState.WARNING);
    }
}

