/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselSocket;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnTTC580;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.utils.TTC580Utils;

public class CarouselSocket
extends MobileItem
implements ClearAlertHandler {
    private int id;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule mainModule;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Carousel carousel;
    private CarouselClamp clampXminus;
    private CarouselClamp clampXplus;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*clampXminusController")
    private EPOSController clampXminusController;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*clampXplusController")
    private EPOSController clampXplusController;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private SensorPluggedOnTTC580 slaveModuleSensor;
    private FcsEnumerations.SlaveModuleStatus slaveModuleStatus;
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*autochanger")
    private FilterHolder autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private FilterManager filterManager;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PersistencyService persistenceService;
    private final boolean loadFilterLocationAtStartup = true;
    private final boolean saveFilterLocationAtShutdown = true;
    @ConfigurationParameter(range="-4500000..4500000", description=" carousel position when this socket is at standby")
    private int standbyPosition;
    @Persist
    private int filterID;
    private volatile FcsEnumerations.FilterClampState clampsState = FcsEnumerations.FilterClampState.UNDEFINED;
    private long timeoutForUnlocking = 4000L;
    private long timeoutForReleasing = 4000L;

    public CarouselSocket(int id, CarouselClamp clampXminus, CarouselClamp clampXplus, int standbyPosition) {
        this.id = id;
        this.clampXminus = clampXminus;
        this.clampXplus = clampXplus;
        this.standbyPosition = standbyPosition;
    }

    public void build() {
        this.dataProviderDictionaryService.registerData(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByCarouselSocket()));
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public CarouselClamp getClampXminus() {
        return this.clampXminus;
    }

    public void setClampXminus(CarouselClamp clampXminus) {
        this.clampXminus = clampXminus;
    }

    public CarouselClamp getClampXplus() {
        return this.clampXplus;
    }

    public void setClampXplus(CarouselClamp clampXplus) {
        this.clampXplus = clampXplus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns filterID if a filter is in the socket.")
    public int getFilterID() {
        return this.filterID;
    }

    public String getFilterName() {
        return this.filterManager.getFilterNameByID(this.filterID);
    }

    public void setFilterID(int filterID) {
        this.filterID = filterID;
        this.publishData();
    }

    public int getStandbyPosition() {
        return this.standbyPosition;
    }

    public FcsEnumerations.SlaveModuleStatus getSlaveModuleStatus() {
        return this.slaveModuleStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if this socket is at STANDBY position on the carousel.")
    public boolean isAtStandby() {
        if (this.carousel.isHomingDone()) {
            return Math.abs(this.standbyPosition - this.carousel.getPosition()) <= 1000 && this.carousel.getSocketAtStandbyID() == this.id;
        }
        this.raiseWarningOnlyIfNew(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "carousel homing is not done", this.name);
        return this.carousel.getSocketAtStandbyID() == this.id;
    }

    public void init() {
        this.persistenceService.setAutomatic(true, true);
        this.clampXminus.setController(this.clampXminusController);
        this.clampXplus.setController(this.clampXplusController);
    }

    private boolean isAutochangerHoldingFilter() {
        return this.autochanger.isAtStandby() && this.autochanger.isHoldingFilter();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hardware is connected and ready.")
    public boolean myDevicesReady() {
        return this.clampXminusController.isInitialized() && this.clampXplusController.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return clamps state - doesn't read again sensors.")
    public FcsEnumerations.FilterClampState getClampsState() {
        return this.clampsState;
    }

    public void updateState() {
        FCSLOG.info((Object)(this.name + " updating state....."));
        long beginTimeCmd = System.currentTimeMillis();
        this.slaveModuleStatus = this.slaveModuleSensor.getValue() >= 1 && this.slaveModuleSensor.getValue() <= 7 ? FcsEnumerations.SlaveModuleStatus.getStatusByCode(this.slaveModuleSensor.getValue()) : FcsEnumerations.SlaveModuleStatus.UNKNOWN_STATUS;
        if (this.slaveModuleSensor.getValue() < 4 && this.slaveModuleSensor.getValue() > 0) {
            this.updateClampsState();
        } else {
            this.clampsState = FcsEnumerations.FilterClampState.UNDEFINED;
            this.raiseWarning(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, " slave module status = " + this.slaveModuleSensor.getValue() + " => " + this.slaveModuleStatus, this.name);
        }
        this.publishData();
        long duration = System.currentTimeMillis() - beginTimeCmd;
        FCSLOG.info((Object)(this.name + " updateState duration = " + duration));
    }

    private void updateClampsState() {
        boolean inError;
        this.clampXminus.updateState();
        this.clampXplus.updateState();
        boolean bl = inError = this.clampXminus.getClampState() == FcsEnumerations.FilterClampState.ERROR || this.clampXplus.getClampState() == FcsEnumerations.FilterClampState.ERROR;
        if (this.clampXminus.getClampState() == this.clampXplus.getClampState()) {
            this.clampsState = this.clampXminus.getClampState();
            FCSLOG.info((Object)(this.name + " : clamps are updated"));
        } else if (this.clampXminus.getClampState() == FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY && this.clampXplus.getClampState() == FcsEnumerations.FilterClampState.READYTOCLAMP) {
            this.clampsState = this.clampXminus.isReleased() && this.clampXplus.isReleased() ? FcsEnumerations.FilterClampState.READYTOCLAMP : FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY;
        } else if (!inError) {
            FCSLOG.fine((Object)(this.name + " clampXminus is " + this.clampXminus.getClampState() + " and clampXplus is " + this.clampXplus.getClampState() + " clampState = " + FcsEnumerations.FilterClampState.UNDEFINED));
            this.clampsState = FcsEnumerations.FilterClampState.UNDEFINED;
        } else {
            this.clampsState = FcsEnumerations.FilterClampState.ERROR;
            String msg = this.name + ": clampState at Xminus side is different from clampState at Xplus side. ";
            msg = msg + this.clampXminus.getName() + " state=" + this.clampXminus.getClampState() + " ";
            msg = msg + this.clampXplus.getName() + " state=" + this.clampXplus.getClampState();
            this.raiseWarning(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, msg, this.name);
        }
    }

    public void updateFilterID() {
        if (this.isEmpty()) {
            this.filterID = 0;
        } else if (this.autochanger.isAtStandby()) {
            this.filterID = this.autochanger.getFilterID();
        }
    }

    public void checkAndUpdateOffset2(long sdo) {
        this.clampXminus.checkAndUpdateOffset2(TTC580Utils.getOffset2Xminus(sdo));
        this.clampXplus.checkAndUpdateOffset2(TTC580Utils.getOffset2Xplus(sdo));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is no filter in the socket.")
    public boolean isEmpty() {
        return this.clampXminus.getFilterPresenceStatus() == FcsEnumerations.FilterPresenceStatus.NOFILTER && this.clampXplus.getFilterPresenceStatus() == FcsEnumerations.FilterPresenceStatus.NOFILTER;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is a filter in the socket and the clampsare LOCKED.")
    public boolean isClampedOnFilter() {
        return this.clampsState == FcsEnumerations.FilterClampState.CLAMPEDONFILTER;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is a filter in the socket and the clampsare UNLOCKED.")
    public boolean isUnclampedOnFilter() {
        return this.clampsState == FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if there is NO filter in the socket and the clampsare UNLOCKED.")
    public boolean isUnclampedEmpty() {
        return this.clampsState == FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Returns true if this socket is ready to clamp a filter.")
    public boolean isReadyToClamp() {
        return this.clampsState == FcsEnumerations.FilterClampState.READYTOCLAMP;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Release the 2 clamps of this socket if the socket is at STANDBY position.")
    public void releaseClamps() {
        this.carousel.updateStateWithSensors();
        FCSLOG.info((Object)("Checking conditions for release clamp " + this.name + " on socket at standby position."));
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + " is NOT AT STANDBY - can't unlock clamps.");
        }
        if (this.clampXminus.isFilterEngaged() || this.clampXplus.isFilterEngaged()) {
            throw new RejectedCommandException(this.name + ": Can't release clamps because a filter is engaged in clamps.");
        }
        this.timeoutForReleasing = Math.max(this.clampXminus.timeoutForReleasing, this.clampXplus.timeoutForReleasing);
        FCSLOG.info((Object)(this.name + ": Releasing clamps at standby position."));
        this.executeAction(FcsEnumerations.MobileItemAction.RELEASECLAMPS, this.timeoutForReleasing);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unlock the 2 clamps of this socket if the socket is at STANDBY position.")
    public void unlockClamps() {
        this.carousel.updateStateWithSensors();
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + " is NOT AT STANDBY - can't unlock clamps.");
        }
        if (!this.isAutochangerHoldingFilter()) {
            throw new RejectedCommandException("CANNOT UNLOCK CLAMPS if FILTER is not HELD by autochanger.");
        }
        this.timeoutForUnlocking = Math.max(this.clampXminus.timeoutForUnlocking, this.clampXplus.timeoutForUnlocking);
        this.executeAction(FcsEnumerations.MobileItemAction.UNLOCKCLAMPS, this.timeoutForUnlocking);
        FCSLOG.info((Object)"Command unlockClamps completed");
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns a String representation of a CarouselSocket.")
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(",FilterID in socket : ");
        sb.append(this.filterID).append("\n");
        return sb.toString();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.UNLOCKCLAMPS) {
            return this.clampsState == FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
        }
        if (action == FcsEnumerations.MobileItemAction.RELEASECLAMPS) {
            return this.clampsState == FcsEnumerations.FilterClampState.READYTOCLAMP;
        }
        throw new IllegalArgumentException("Action on clamps on socket must be UNLOCKCLAMPS or RELEASECLAMPS");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.carousel.updateSocketAtStandbyWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.UNLOCKCLAMPS) {
            this.clampXminusController.enable();
            this.clampXplusController.enable();
            this.clampXminusController.writeCurrent(-100);
            this.clampXplusController.writeCurrent(-100);
            this.clampXminusController.writeCurrent(this.clampXminus.getCurrentToUnlock());
            this.clampXplusController.writeCurrent(this.clampXplus.getCurrentToUnlock());
        } else if (action == FcsEnumerations.MobileItemAction.RELEASECLAMPS) {
            this.clampXminusController.disableOperation();
            this.clampXplusController.disableOperation();
        } else {
            throw new IllegalArgumentException("Action on clamps on socket must be UNLOCKCLAMPS or RELEASECLAMPS");
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " is ABORTING action " + action.toString() + " within delay " + delay));
        FCSLOG.debug((Object)(this.name + " NOTHING BEING DONE HERE"));
    }

    @Override
    public void endAction(FcsEnumerations.MobileItemAction action) {
        FCSLOG.debug((Object)(this.name + " is ENDING action " + action.toString()));
        this.carousel.updateStateWithSensors();
        FCSLOG.debug((Object)(this.name + " NOTHING BEING DONE HERE"));
    }

    @Override
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByCarouselSocket()));
    }

    public StatusDataPublishedByCarouselSocket createStatusDataPublishedByCarouselSocket() {
        StatusDataPublishedByCarouselSocket status = new StatusDataPublishedByCarouselSocket();
        status.setAtStandby(this.isAtStandby());
        status.setSlaveStatus(this.slaveModuleStatus);
        status.setClampsState(this.clampsState);
        status.setEmpty(this.isEmpty());
        status.setFilterID(this.filterID);
        status.setSocketID(this.id);
        if (this.isEmpty()) {
            status.setFilterName("NO FILTER");
        } else {
            status.setFilterName(this.getFilterName());
        }
        return status;
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        String alertId = this.name + this.getAlertSeparator() + FcsEnumerations.FcsAlert.CA_SENSOR_ERROR.name();
        if (alert.getAlertId().equals(alertId)) {
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    @Override
    public void shutdown() {
        this.persistenceService.persistNow();
    }
}

