/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystem.teststand.limits.AlgorithmFactory;
import org.lsst.ccs.subsystem.teststand.limits.ChannelLimits;
import org.lsst.ccs.subsystem.teststand.limits.LimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.Limits;
import org.lsst.ccs.subsystem.teststand.limits.TransitionAlgorithm;

public class ThermalConfiguration {
    @ConfigurationParameter(category="thermal")
    double coldSetPoint;
    @ConfigurationParameter(category="thermal")
    List<Double> coldSetPointLimits;
    @ConfigurationParameter(category="thermal")
    double cryoSetPoint;
    @ConfigurationParameter(category="thermal")
    List<Double> cryoSetPointLimits;
    @ConfigurationParameter(category="thermal")
    String coldMonitoringLimitAlgorithm;
    @ConfigurationParameter(category="thermal")
    String cryoMonitoringLimitAlgorithm;
    @ConfigurationParameter(category="thermal")
    List<Double> coldMonitoringLimitAlgorithmParameters;
    @ConfigurationParameter(category="thermal")
    List<Double> cryoMonitoringLimitAlgorithmParameters;
    @ConfigurationParameter(category="thermal")
    String coldMonitoringTransitionAlgorithm;
    @ConfigurationParameter(category="thermal")
    String cryoMonitoringTransitionAlgorithm;
    @ConfigurationParameter(category="thermal")
    List<Double> coldMonitoringTransitionAlgorithmParameters = new ArrayList<Double>();
    @ConfigurationParameter(category="thermal")
    List<Double> cryoMonitoringTransitionAlgorithmParameters = new ArrayList<Double>();

    LimitAlgorithm createColdLimitsAlgorithm(double nominalInitialValue, Limits initialLimits) {
        LimitAlgorithm la = AlgorithmFactory.createLimitAlgorithm(this.coldMonitoringLimitAlgorithm);
        Limits setPointLimits = new Limits(this.coldSetPointLimits);
        la.init(this.coldMonitoringLimitAlgorithmParameters, nominalInitialValue, initialLimits, this.coldSetPoint, setPointLimits);
        return la;
    }

    LimitAlgorithm createCryoLimitsAlgorithm(double nominalInitialValue, Limits initialLimits) {
        LimitAlgorithm la = AlgorithmFactory.createLimitAlgorithm(this.cryoMonitoringLimitAlgorithm);
        Limits setPointLimits = new Limits(this.cryoSetPointLimits);
        la.init(this.cryoMonitoringLimitAlgorithmParameters, nominalInitialValue, initialLimits, this.cryoSetPoint, setPointLimits);
        return la;
    }

    TransitionAlgorithm createColdTransitionAlgorithm(LimitAlgorithm limitsAlgorithm, double initialValue, ChannelLimits limits, long startTime) {
        if (this.coldMonitoringTransitionAlgorithm != null && !this.coldMonitoringTransitionAlgorithm.isEmpty()) {
            TransitionAlgorithm ta = AlgorithmFactory.createTransitionAlgorithm(this.coldMonitoringTransitionAlgorithm);
            ta.init(this.coldMonitoringTransitionAlgorithmParameters, limitsAlgorithm, initialValue, limits, startTime);
            return ta;
        }
        return null;
    }

    TransitionAlgorithm createCryoTransitionAlgorithm(LimitAlgorithm limitsAlgorithm, double initialValue, ChannelLimits limits, long startTime) {
        if (this.cryoMonitoringTransitionAlgorithm != null && !this.cryoMonitoringTransitionAlgorithm.isEmpty()) {
            TransitionAlgorithm ta = AlgorithmFactory.createTransitionAlgorithm(this.cryoMonitoringTransitionAlgorithm);
            ta.init(this.cryoMonitoringTransitionAlgorithmParameters, limitsAlgorithm, initialValue, limits, startTime);
            return ta;
        }
        return null;
    }

    public String toString() {
        return "ThermalConfiguration{coldSetPoint=" + this.coldSetPoint + ", cryoSetPoint=" + this.cryoSetPoint + ", coldMonitoringLimitAlgorithm=" + this.coldMonitoringLimitAlgorithm + ", cryoMonitoringLimitAlgorithm=" + this.cryoMonitoringLimitAlgorithm + ", coldMonitoringLimitAlgorithmParameters=" + this.coldMonitoringLimitAlgorithmParameters + ", cryoMonitoringLimitAlgorithmParameters=" + this.cryoMonitoringLimitAlgorithmParameters + ", coldMonitoringTransitionAlgorithm=" + this.coldMonitoringTransitionAlgorithm + ", cryoMonitoringTransitionAlgorithm=" + this.cryoMonitoringTransitionAlgorithm + ", coldMonitoringTransitionAlgorithmParameters=" + this.coldMonitoringTransitionAlgorithmParameters + ", cryoMonitoringTransitionAlgorithmParameters=" + this.cryoMonitoringTransitionAlgorithmParameters + '}';
    }
}

