/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.dcom.common.impl;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JICallBuilder;
import org.jinterop.dcom.core.JIString;
import org.openscada.opc.dcom.common.impl.BaseCOMObject;
import org.openscada.opc.dcom.common.impl.Helper;

public class EnumString
extends BaseCOMObject {
    public static final int DEFAULT_BATCH_SIZE = Integer.getInteger("openscada.dcom.enum-batch-size", 10);

    public EnumString(IJIComObject enumStringObject) throws IllegalArgumentException, UnknownHostException, JIException {
        super(enumStringObject.queryInterface("00000101-0000-0000-C000-000000000046"));
    }

    public int next(List<String> list, int num) throws JIException {
        if (num <= 0) {
            return 0;
        }
        JICallBuilder callObject = new JICallBuilder(true);
        callObject.setOpnum(0);
        callObject.addInParamAsInt(num, 0);
        callObject.addOutParamAsObject(new JIArray(new JIString(4), null, 1, true, true), 0);
        callObject.addOutParamAsType(Integer.class, 0);
        Object[] result = Helper.callRespectSFALSE(this.getCOMObject(), callObject);
        JIString[] resultData = (JIString[])((JIArray)result[0]).getArrayInstance();
        Integer cnt = (Integer)result[1];
        for (int i = 0; i < cnt; ++i) {
            list.add(resultData[i].getString());
        }
        return cnt;
    }

    public Collection<String> next(int num) throws JIException {
        ArrayList<String> list = new ArrayList<String>(num);
        this.next(list, num);
        return list;
    }

    public void skip(int num) throws JIException {
        if (num <= 0) {
            return;
        }
        JICallBuilder callObject = new JICallBuilder(true);
        callObject.setOpnum(1);
        callObject.addInParamAsInt(num, 0);
        this.getCOMObject().call(callObject);
    }

    public void reset() throws JIException {
        JICallBuilder callObject = new JICallBuilder(true);
        callObject.setOpnum(2);
        this.getCOMObject().call(callObject);
    }

    public EnumString cloneObject() throws JIException, IllegalArgumentException, UnknownHostException {
        JICallBuilder callObject = new JICallBuilder(true);
        callObject.setOpnum(3);
        callObject.addOutParamAsType(IJIComObject.class, 0);
        Object[] result = this.getCOMObject().call(callObject);
        IJIComObject object = (IJIComObject)result[0];
        return new EnumString(object);
    }

    public Collection<String> asCollection(int batchSize) throws JIException {
        this.reset();
        ArrayList<String> data = new ArrayList<String>();
        int i = 0;
        while ((i = this.next(data, batchSize)) == batchSize) {
        }
        return data;
    }

    public Collection<String> asCollection() throws JIException {
        return this.asCollection(DEFAULT_BATCH_SIZE);
    }
}

