/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.motorplatform.bot.PlanToken;
import org.lsst.ccs.subsystem.motorplatform.bot.PlanTokenizer;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.MetroCommand;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.MetroEndSession;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.MetroRunSamplingScan;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.MetroSetTransform;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.MetroStartSession;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.MetroTakeSamplesAt;
import org.lsst.ccs.subsystem.motorplatform.bus.bot.MetroWait;

public class PlanCompiler {
    private final PlanTokenizer tok;
    private final Map<String, Double> transformations;
    private String currentLabel;
    private List<MetroCommand> commands;

    public PlanCompiler(PlanTokenizer scn) {
        this.tok = scn;
        this.transformations = new HashMap<String, Double>();
        this.currentLabel = "<none>";
        this.commands = null;
    }

    public List<MetroCommand> plan(String outfile) throws IOException {
        this.commands = new LinkedList<MetroCommand>();
        this.commands.add((MetroCommand)new MetroStartSession(outfile));
        this.tok.get();
        while (this.tok.id != PlanToken.EOF) {
            if (this.tok.id == PlanToken.REAL) {
                this.samplePoint();
                continue;
            }
            if (this.tok.id == PlanToken.BANG) {
                this.tok.get();
                if (this.tok.id == PlanToken.PART) {
                    this.label();
                    continue;
                }
                this.command();
                continue;
            }
            throw new ParseException("Expected a number or '!' at the start of the line.");
        }
        if (!(this.transformations.containsKey("X0") && this.transformations.containsKey("Y0") && this.transformations.containsKey("THETA"))) {
            throw new ParseException("Must have TF definitions for X0, Y0 and theta");
        }
        this.commands.add(1, (MetroCommand)new MetroSetTransform(this.transformations.get("X0").doubleValue(), this.transformations.get("Y0").doubleValue(), this.transformations.get("THETA").doubleValue()));
        this.commands.add((MetroCommand)new MetroEndSession());
        return new ArrayList<MetroCommand>(this.commands);
    }

    private void samplePoint() throws IOException {
        ArrayList<Double> coords = new ArrayList<Double>(2);
        this.point(coords);
        this.commands.add((MetroCommand)new MetroTakeSamplesAt(this.currentLabel, ((Double)coords.get(0)).doubleValue(), ((Double)coords.get(1)).doubleValue(), this.currentLabel.contains("REF") ? 10 : 1));
    }

    private void point(List<Double> coords) throws IOException {
        if (this.tok.id != PlanToken.REAL && this.tok.id != PlanToken.INTEGER) {
            throw new ParseException("Expected the first coordinate (a number)");
        }
        coords.add(this.tok.value);
        this.tok.get();
        if (this.tok.id != PlanToken.REAL && this.tok.id != PlanToken.INTEGER) {
            throw new ParseException("Expected the second coordinate (a number)");
        }
        coords.add(this.tok.value);
        this.tok.get();
        if (this.tok.id != PlanToken.NEWLINE) {
            throw new ParseException("Expected nothing on the line after the point coordinates.");
        }
        this.tok.get();
    }

    private void label() throws IOException {
        this.tok.get();
        if (this.tok.id != PlanToken.OF) {
            throw new ParseException("Expected 'of' after 'part'");
        }
        this.tok.get();
        if (this.tok.id != PlanToken.LABEL) {
            throw new ParseException("Expected 'label' after 'of'");
        }
        this.tok.get();
        if (this.tok.id == PlanToken.REF || this.tok.id == PlanToken.SENSOR || this.tok.id == PlanToken.FID) {
            this.currentLabel = this.tok.text.toUpperCase();
            this.tok.get();
            if (this.tok.id != PlanToken.NEWLINE) {
                throw new ParseException("Expected nothing else on the line after the label.");
            }
        } else {
            throw new ParseException("The label doesn't have a valid form.");
        }
        this.tok.get();
    }

    private void command() throws IOException {
        if (this.tok.id == PlanToken.TF) {
            this.transform();
        } else if (this.tok.id == PlanToken.SCAN) {
            this.scan();
        } else if (this.tok.id == PlanToken.WAIT) {
            this.mywait();
        } else {
            throw new ParseException("Expected 'part', 'TF', 'SCAN' or 'WAIT' after the '!'");
        }
    }

    private void transform() throws IOException {
        this.tok.get();
        if (this.tok.id != PlanToken.X0 && this.tok.id != PlanToken.Y0 && this.tok.id != PlanToken.THETA) {
            throw new ParseException("Expected 'X0', 'Y0' or 'theta' after 'TF'");
        }
        PlanToken param = this.tok.id;
        this.tok.get();
        if (this.tok.id != PlanToken.EQUALS) {
            throw new ParseException("Expected '=' after the parameter name");
        }
        this.tok.get();
        if (this.tok.id != PlanToken.REAL) {
            throw new ParseException("Expected a real number after the '='");
        }
        this.transformations.put(param.toString(), this.tok.value);
        this.tok.get();
        if (this.tok.id != PlanToken.NEWLINE) {
            throw new ParseException("Expected nothing on the line after the parameter value");
        }
        this.tok.get();
    }

    private void scan() throws IOException {
        this.tok.get();
        HashMap<String, Double> params = new HashMap<String, Double>();
        this.scanParam(params);
        int n = ((Double)params.get("N")).intValue();
        double dc = (Double)params.get("DC");
        ArrayList<Double> coords = new ArrayList<Double>();
        this.point(coords);
        this.point(coords);
        this.commands.add((MetroCommand)new MetroRunSamplingScan(this.currentLabel, ((Double)coords.get(0)).doubleValue(), ((Double)coords.get(1)).doubleValue(), ((Double)coords.get(2)).doubleValue(), ((Double)coords.get(3)).doubleValue(), n, dc));
    }

    private void scanParam(Map<String, Double> params) throws IOException {
        if (this.tok.id != PlanToken.N) {
            throw new ParseException("Expected 'n' after 'SCAN'");
        }
        this.tok.get();
        if (this.tok.id != PlanToken.EQUALS) {
            throw new ParseException("Expected '=' after 'n'");
        }
        this.tok.get();
        if (this.tok.id != PlanToken.INTEGER) {
            throw new ParseException("Expected an integer after 'n='");
        }
        params.put("N", this.tok.value);
        this.tok.get();
        if (this.tok.id != PlanToken.DC) {
            throw new ParseException("Expected 'dc' after setting of the 'n' parameter.");
        }
        this.tok.get();
        if (this.tok.id != PlanToken.EQUALS) {
            throw new ParseException("Expected '=' after 'dc'");
        }
        this.tok.get();
        if (this.tok.id != PlanToken.REAL) {
            throw new ParseException("Expected a real number after 'dc='");
        }
        params.put("DC", this.tok.value);
        this.tok.get();
        if (this.tok.id != PlanToken.NEWLINE) {
            throw new ParseException("Expected nothing on the line after the scan parameter settings");
        }
        this.tok.get();
    }

    private void mywait() throws IOException {
        this.tok.get();
        if (this.tok.id != PlanToken.REAL && this.tok.id != PlanToken.INTEGER) {
            throw new ParseException("Expected a number after 'WAIT'");
        }
        this.commands.add((MetroCommand)new MetroWait(this.tok.value.doubleValue()));
        this.tok.get();
        if (this.tok.id != PlanToken.NEWLINE) {
            throw new ParseException("Expected nothing on the line after the wait time");
        }
        this.tok.get();
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String msg) {
            super(msg);
        }
    }
}

