/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusData;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.statusdb.BatchPersister;
import org.lsst.ccs.localdb.statusdb.CloseMetaData;
import org.lsst.ccs.localdb.statusdb.MetaDataPersister;
import org.lsst.ccs.localdb.statusdb.RegisterDataGroup;
import org.lsst.ccs.localdb.statusdb.StatDataPersister;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataGroup;
import org.lsst.ccs.localdb.statusdb.model.DataPath;
import org.lsst.ccs.localdb.statusdb.model.MetaDataData;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.utilities.logging.Logger;

public class StatusDataPersister
extends BatchPersister<Object[]>
implements StatusMessageListener,
HasLifecycle,
AgentPresenceListener {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.statusdb");
    private static final DataDesc NULL_DESCRIPTION = new DataDesc();
    private static final long[] DEFAULT_TIME_BIN_WIDTH = new long[]{300000L, 1800000L};
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentPeriodicTaskService periodicTaskService;
    private final Map<DataPath, DataDesc> map = new ConcurrentHashMap<DataPath, DataDesc>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private StatDataPersister statAccumulator;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final MetaDataPersister mdAccumulator = new MetaDataPersister();
    private final Set<String> dictionaryProcessed = new CopyOnWriteArraySet<String>();
    private ConcurrentMessagingUtils cmu;

    public StatusDataPersister() {
        super(1000, true, 6);
    }

    public void build() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("statdata-accumulator", (Runnable)this.statAccumulator).withIsFixedRate(false).withPeriod(Duration.ofSeconds(1L)));
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("metadata-accumulator", (Runnable)this.mdAccumulator).withIsFixedRate(false).withPeriod(Duration.ofSeconds(1L)));
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("data-accumulator", (Runnable)this).withIsFixedRate(false).withPeriod(Duration.ofSeconds(1L)));
    }

    public void init() {
        SessionFactory fac = StatusdbUtils.getSessionFactory(null);
        log.fine((Object)"init StatusPersister");
        Session sess = fac.openSession();
        Transaction tx = sess.beginTransaction();
        List l = sess.createQuery("from DataDesc").list();
        for (DataDesc dd : l) {
            this.map.put(dd.getDataPath(), dd);
            log.fine((Object)("storing " + dd.getDataPath().getFullKey()));
            StatusDataPersister.getStatDescs(dd, sess);
        }
        tx.commit();
        sess.close();
        log.info((Object)"analyzing data desc integrity ...");
        this.analizeDataMapIntegrity();
        this.cmu = new ConcurrentMessagingUtils(this.subsys.getMessagingAccess());
    }

    public void start() {
        this.subsys.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.subsys.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, BusMessageFilterFactory.messageClass(StatusData.class).or(BusMessageFilterFactory.messageClass(StatusDataProviderDictionary.class)).or(BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class)).and(BusMessageFilterFactory.messageOrigin(null)));
    }

    public void shutdown() {
        this.subsys.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
        this.subsys.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
    }

    public void connected(AgentInfo ... agents) {
        for (AgentInfo ai : agents) {
            if (ai.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) < 0) {
                return;
            }
            if (this.dictionaryProcessed.contains(ai.getName())) continue;
            this.mdAccumulator.addToQueue(new CloseMetaData(ai.getName()));
            this.subsys.getScheduler().schedule(() -> {
                if (!this.dictionaryProcessed.contains(ai.getName())) {
                    this.subsys.getLogger().warn((Object)"Requesting publication of dictionary. This should not be necessary");
                    this.cmu.sendAsynchronousCommand(new CommandRequest(ai.getName(), "publishDataProviderDictionary"));
                }
            }, 3L, TimeUnit.SECONDS);
        }
    }

    public void disconnecting(AgentInfo ai) {
        if (ai.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) < 0) {
            return;
        }
        this.mdAccumulator.addToQueue(new CloseMetaData(ai.getName()));
        this.dictionaryProcessed.remove(ai.getName());
    }

    public void onStatusMessage(StatusMessage s) {
        block9: {
            block8: {
                if (!(s instanceof StatusData)) break block8;
                KeyValueDataList encodedData = (KeyValueDataList)s.getEncodedData();
                if (encodedData == null) break block9;
                this.processEncodedData(s.getOriginAgentInfo().getName(), encodedData);
                break block9;
            }
            if (s instanceof StatusDataProviderDictionary) {
                String name = s.getOriginAgentInfo().getName();
                log.debug((Object)("received a data dictionary for " + name));
                if (this.dictionaryProcessed.contains(name)) {
                    return;
                }
                this.dictionaryProcessed.add(name);
                StatusDataProviderDictionary sdpd = (StatusDataProviderDictionary)s;
                DataProviderDictionary dpd = (DataProviderDictionary)sdpd.getObject();
                RegisterDataGroup rdg = new RegisterDataGroup(s.getOriginAgentInfo());
                this.addToQueue(new Object[]{rdg, dpd});
                for (DataProviderInfo dpi : dpd.getDataProviderInfos()) {
                    DataProviderInfo.Type dataType;
                    String typeStr = dpi.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
                    if (typeStr == null || (dataType = DataProviderInfo.Type.valueOf((String)typeStr)) != DataProviderInfo.Type.MONITORING && dataType != DataProviderInfo.Type.TRENDING) continue;
                    for (DataProviderInfo.Attribute attr : dpi.getAttributes()) {
                        if (!attr.isMetadata()) continue;
                        this.queueImmediateMetaData(s.getOriginAgentInfo().getAgentStartTime().getUTCInstant().toEpochMilli(), new DataPath(name, dpi.getPath()), attr.getName(), dpi.getAttributeValue(attr));
                    }
                }
            } else if (s instanceof StatusConfigurationInfo) {
                ConfigurationInfo ci = ((StatusConfigurationInfo)s).getConfigurationInfo();
                log.fine((Object)("Processing configurationInfo for " + ((StatusConfigurationInfo)s).getOriginAgentInfo().getName()));
                HashMap<String, ChannelMetadata> channelsMetadata = new HashMap<String, ChannelMetadata>();
                for (ConfigurationParameterInfo par : ci.getAllParameterInfo()) {
                    String parName = par.getParameterName();
                    if (!parName.equals("limitLo") && !parName.equals("limitHi") && !parName.equals("dbandHi") && !parName.equals("dbandLo")) continue;
                    String channelPath = par.getComponentName();
                    ChannelMetadata channelMetadata = channelsMetadata.getOrDefault(channelPath, new ChannelMetadata(channelPath));
                    channelMetadata.setMetaValue(parName, par.getCurrentValue());
                    channelsMetadata.put(channelPath, channelMetadata);
                }
                for (ChannelMetadata channelMetadata : channelsMetadata.values()) {
                    this.queueImmediateMetaData(s.getCCSTimeStamp().getUTCInstant().toEpochMilli(), new DataPath(s.getOriginAgentInfo().getName(), channelMetadata.channelPath), "alarmLow", channelMetadata.getAlarmLow());
                    this.queueImmediateMetaData(s.getCCSTimeStamp().getUTCInstant().toEpochMilli(), new DataPath(s.getOriginAgentInfo().getName(), channelMetadata.channelPath), "alarmHigh", channelMetadata.getAlarmHigh());
                    this.queueImmediateMetaData(s.getCCSTimeStamp().getUTCInstant().toEpochMilli(), new DataPath(s.getOriginAgentInfo().getName(), channelMetadata.channelPath), "warningLow", channelMetadata.getWarningLow());
                    this.queueImmediateMetaData(s.getCCSTimeStamp().getUTCInstant().toEpochMilli(), new DataPath(s.getOriginAgentInfo().getName(), channelMetadata.channelPath), "warningHigh", channelMetadata.getWarningHigh());
                    log.fine((Object)("Updating metadata for " + channelMetadata.channelPath + ": alarmLow(" + channelMetadata.getAlarmLow() + ") warningLow(" + channelMetadata.getWarningLow() + ") warningHigh(" + channelMetadata.getWarningHigh() + ") alarmHigh(" + channelMetadata.getAlarmHigh() + ")"));
                }
            }
        }
    }

    private void queueImmediateMetaData(long tStamp, DataPath name, String metadata, String value) {
        MetaDataData md = new MetaDataData(tStamp);
        md.setName(metadata);
        md.setValue(value);
        this.addToQueue(new Object[]{md, name});
    }

    public synchronized void processEncodedData(String source, KeyValueDataList encodedData) {
        for (KeyValueData d : encodedData) {
            KeyValueData.KeyValueDataType type = d.getType();
            if (null == type) continue;
            switch (type) {
                case KeyValueTrendingData: {
                    this.queueImmediateScalar(source, d);
                    break;
                }
                case KeyValueMetaData: {
                    String metaPath = d.getKey();
                    int lastIndex = metaPath.lastIndexOf(47);
                    String metaname = metaPath.substring(lastIndex + 1);
                    if (metaname.equals("alarmHigh") || metaname.equals("alarmLow") || metaname.equals("warningHigh") || metaname.equals("warningLow")) break;
                    String key = metaPath.replace("/" + metaname, "");
                    this.queueImmediateMetaData(d.getCCSTimeStamp().getUTCInstant().toEpochMilli(), new DataPath(source, key), metaname, (String)((Object)d.getValue()));
                    break;
                }
            }
        }
    }

    private void queueImmediateScalar(String source, KeyValueData kvd) {
        long tStamp = kvd.getCCSTimeStamp().getUTCInstant().toEpochMilli();
        DataPath name = new DataPath(source, kvd.getKey());
        Serializable d = kvd.getValue();
        log.debug((Object)("got update " + name));
        RawData data = new RawData();
        data.setTime(tStamp);
        if (d instanceof Double) {
            data.setDoubleData((Double)d);
        } else if (d instanceof Float) {
            data.setDoubleData(Double.valueOf(((Float)d).doubleValue()));
        } else if (d instanceof Integer) {
            data.setDoubleData(Double.valueOf(((Integer)d).doubleValue()));
        } else if (d instanceof Short) {
            data.setDoubleData(Double.valueOf(((Short)d).doubleValue()));
        } else if (d instanceof Long) {
            data.setDoubleData(Double.valueOf(((Long)d).doubleValue()));
        } else {
            data.setStringData(String.valueOf(d));
        }
        this.addToQueue(new Object[]{data, name});
    }

    private void persistData(RawData data, DataPath name, Session sess) {
        if (data.getDoubleData() != null && Double.isNaN(data.getDoubleData())) {
            return;
        }
        DataDesc dd = this.getDataDescription(name, "trending", sess);
        if (dd == null || dd == NULL_DESCRIPTION) {
            return;
        }
        data.setDataDesc(dd);
        sess.lock((Object)dd, LockMode.NONE);
        sess.persist((Object)data);
        this.statAccumulator.addToQueue(data);
    }

    public StatDataPersister getStatAccumulator() {
        return this.statAccumulator;
    }

    private void persistMetadata(MetaDataData md, DataPath name, Session sess) {
        DataGroup dg = this.getDataGroup(name.getAgentName(), name.getDataName(), sess);
        md.setDataGroup(dg);
        this.mdAccumulator.addToQueue(md);
    }

    private void persistDataGroups(RegisterDataGroup rdg, DataProviderDictionary dpd, Session sess) {
        String agentName = rdg.getAgentName();
        boolean useFullPaths = rdg.isUseFullPath();
        ArrayList<DataPath> dictionaryPaths = new ArrayList<DataPath>();
        for (DataProviderInfo dataProviderInfo : dpd.getDataProviderInfos()) {
            String typeStr = dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE);
            if (typeStr == null) continue;
            try {
                DataProviderInfo.Type dataType = DataProviderInfo.Type.valueOf((String)typeStr);
                if (dataType != DataProviderInfo.Type.MONITORING && dataType != DataProviderInfo.Type.TRENDING) continue;
                dictionaryPaths.add(new DataPath(agentName, useFullPaths ? dataProviderInfo.getPath() : dataProviderInfo.getKey()));
            }
            catch (Exception e) {
                log.warning((Object)("Illegal type conversion from " + typeStr));
            }
        }
        for (Map.Entry entry : this.map.entrySet()) {
            boolean isInDictionary = dictionaryPaths.remove(entry.getKey());
            DataDesc dataDesc = (DataDesc)entry.getValue();
            if (dataDesc.getDataPath() == null || !dataDesc.getDataPath().getAgentName().equals(agentName)) continue;
            if (!dataDesc.getActive()) {
                if (!isInDictionary) continue;
                dataDesc.setActive(true);
                sess.saveOrUpdate((Object)dataDesc);
                continue;
            }
            if (isInDictionary) continue;
            log.warning((Object)("Disabling Data description for " + entry.getKey()));
            dataDesc.setActive(false);
            sess.saveOrUpdate((Object)dataDesc);
        }
        for (String string : dpd.getGroups()) {
            for (DataProviderInfo dpi : dpd.getDataProviderDescriptionsForGroup(string)) {
                DataDesc dd = this.getDataDescription(new DataPath(agentName, useFullPaths ? dpi.getPath() : dpi.getKey()), "trending", sess);
                rdg.addDataDescToGroup(string, dd);
            }
        }
        log.debug((Object)"persisting data group information");
        for (Map.Entry entry : rdg.getDataDescs().entrySet()) {
            String groupName = (String)entry.getKey();
            DataGroup dg = this.getDataGroup(agentName, groupName, sess);
            log.debug((Object)("updating data group " + groupName + " for " + agentName));
            for (DataDesc dd : (List)entry.getValue()) {
                if (dg.getMembers().containsKey(dd.getDataPath())) continue;
                dg.addMember(dd);
            }
        }
        sess.flush();
    }

    private DataDesc getDataDescription(DataPath key, String type, Session sess) {
        Query q = sess.getNamedQuery("findDataDesc").setString("agentName", key.getAgentName()).setString("dataName", key.getDataName());
        DataDesc dd = (DataDesc)q.uniqueResult();
        if (dd == null) {
            dd = new DataDesc();
            dd.setDataPath(key);
            dd.setDataType(type);
            sess.persist((Object)dd);
            log.fine((Object)("Adding default Data Description for " + key + ": " + dd.getId()));
            this.map.put(key, dd);
        }
        return dd;
    }

    private DataGroup getDataGroup(String agentName, String groupName, Session sess) {
        Query q = sess.getNamedQuery("findDataGroup").setString("agentName", agentName).setString("groupName", groupName);
        DataGroup dg = (DataGroup)q.uniqueResult();
        if (dg == null) {
            dg = new DataGroup(agentName, groupName);
            sess.persist((Object)dg);
        }
        return dg;
    }

    public static List<StatDesc> getStatDescs(DataDesc dd, Session sess) {
        List stats = sess.getNamedQuery("findStatDesc").setEntity("dd", (Object)dd).setFlushMode(FlushMode.COMMIT).setCacheable(true).list();
        if (stats.isEmpty()) {
            try {
                for (long statInterval : DEFAULT_TIME_BIN_WIDTH) {
                    StatDesc defaultSD = new StatDesc();
                    defaultSD.setDataDesc(dd);
                    defaultSD.setTimeBinWidth(statInterval);
                    sess.persist((Object)defaultSD);
                    stats.add(defaultSD);
                    log.fine((Object)("Adding default statistical binning of " + statInterval + " milliseconds to " + dd.getDataPath()));
                }
            }
            catch (Exception e) {
                log.warn((Object)("Problem getting statistical data bin for " + dd.getDataPath() + " " + dd.getId()));
                throw e;
            }
        }
        return stats;
    }

    private void analizeDataMapIntegrity() {
    }

    static boolean areDataNamesConsistent(String name1, String name2) {
        if (name1.equals(name2)) {
            return true;
        }
        String[] array1 = name1.split("/");
        String[] array2 = name2.split("/");
        for (int i = 0; i < Math.min(array1.length, array2.length); ++i) {
            if (array1[i].equals(array2[i])) continue;
            return true;
        }
        return array1.length == array2.length;
    }

    @Override
    public void persist(Object[] obj, Session sess) {
        Object toPersist = obj[0];
        if (toPersist instanceof RegisterDataGroup) {
            this.persistDataGroups((RegisterDataGroup)toPersist, (DataProviderDictionary)obj[1], sess);
        } else {
            DataPath name = (DataPath)obj[1];
            if (toPersist instanceof RawData) {
                this.persistData((RawData)toPersist, name, sess);
            } else if (toPersist instanceof MetaDataData) {
                this.persistMetadata((MetaDataData)toPersist, name, sess);
            } else if (toPersist != null) {
                sess.persist(toPersist);
            }
        }
    }

    class ChannelMetadata {
        private final String channelPath;
        private double limitLo;
        private double limitHi;
        private double dbandLo;
        private double dbandHi;

        ChannelMetadata(String channelPath) {
            this.channelPath = channelPath;
        }

        void setMetaValue(String parName, String parValue) {
            double val = Double.parseDouble(parValue);
            if (parName.equals("limitLo")) {
                this.limitLo = val;
            } else if (parName.equals("limitHi")) {
                this.limitHi = val;
            } else if (parName.equals("dbandHi")) {
                this.dbandHi = val;
            } else if (parName.equals("dbandLo")) {
                this.dbandLo = val;
            } else {
                throw new IllegalArgumentException("Illegal Parameter name " + parName);
            }
        }

        String getAlarmHigh() {
            return String.valueOf(this.limitHi);
        }

        String getWarningHigh() {
            return String.valueOf(this.dbandHi <= 0.0 ? this.limitHi : this.limitHi - this.dbandHi);
        }

        String getWarningLow() {
            return String.valueOf(this.dbandLo <= 0.0 ? this.limitLo : this.limitLo + this.dbandLo);
        }

        String getAlarmLow() {
            return String.valueOf(this.limitLo);
        }
    }
}

